/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.navigator.internal;

import java.io.File;
import org.eclipse.jdt.internal.ui.navigator.OpenAndExpand;
import org.eclipse.jdt.ui.actions.OpenAction;
import org.eclipse.jdt.ui.actions.OpenEditorActionGroup;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.n4js.ui.navigator.internal.ResourceNode;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class N4JSOpenActions
extends CommonActionProvider {
    private IAction openAndExpandAction;
    private OpenEditorActionGroup openGroup;
    private boolean inViewPart = false;
    private ISelection selection;

    public void fillActionBars(IActionBars actionBars) {
        if (this.inViewPart && this.canEnableOpenAction()) {
            this.openGroup.fillActionBars(actionBars);
            if (this.openAndExpandAction == null && this.openGroup.getOpenAction().isEnabled()) {
                actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", this.openGroup.getOpenAction());
            } else if (this.openAndExpandAction != null && this.openAndExpandAction.isEnabled()) {
                actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", this.openAndExpandAction);
            }
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        if (this.inViewPart && this.canEnableOpenAction() && this.openGroup.getOpenAction().isEnabled()) {
            this.openGroup.fillContextMenu(menu);
        }
    }

    public void init(ICommonActionExtensionSite site) {
        ICommonViewerWorkbenchSite workbenchSite = null;
        if (site.getViewSite() instanceof ICommonViewerWorkbenchSite) {
            workbenchSite = (ICommonViewerWorkbenchSite)site.getViewSite();
        }
        if (workbenchSite != null && workbenchSite.getPart() != null && workbenchSite.getPart() instanceof IViewPart) {
            IViewPart viewPart = (IViewPart)workbenchSite.getPart();
            this.openGroup = new OpenEditorActionGroup(viewPart);
            if (site.getStructuredViewer() instanceof TreeViewer) {
                this.openAndExpandAction = new OpenAndExpand((IWorkbenchSite)workbenchSite.getSite(), (OpenAction)this.openGroup.getOpenAction(), (TreeViewer)site.getStructuredViewer());
            }
            this.inViewPart = true;
        }
    }

    public void setContext(ActionContext context) {
        super.setContext(context);
        ISelection iSelection = this.selection = context == null ? null : context.getSelection();
        if (this.inViewPart) {
            this.openGroup.setContext(context);
        }
    }

    public void dispose() {
        if (this.openGroup != null) {
            this.openGroup.dispose();
        }
        super.dispose();
    }

    private boolean canEnableOpenAction() {
        Object[] elements;
        if (this.selection == null) {
            return false;
        }
        if (!(this.selection instanceof IStructuredSelection)) {
            return false;
        }
        Object[] objectArray = elements = ((IStructuredSelection)this.selection).toArray();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceNode node;
            File resource;
            Object element = objectArray[n2];
            if (element instanceof ResourceNode && !(resource = (node = (ResourceNode)element).getResource()).isFile()) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

