/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.ArrowFunction;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.ExportedVariableStatement;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.ImportSpecifier;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4EnumDeclaration;
import org.eclipse.n4js.n4JS.N4InterfaceDeclaration;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.n4JS.NamespaceImportSpecifier;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.ReturnStatement;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.VariableBinding;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.VariableStatement;
import org.eclipse.n4js.transpiler.PreparationStep;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.TranspilerState;
import org.eclipse.n4js.transpiler.im.IdentifierRef_IM;
import org.eclipse.n4js.transpiler.im.ParameterizedPropertyAccessExpression_IM;
import org.eclipse.n4js.transpiler.im.ReferencingElementExpression_IM;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryIMOnly;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryInternal;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryOriginal;
import org.eclipse.n4js.transpiler.im.VersionedNamedImportSpecifier_IM;
import org.eclipse.n4js.transpiler.operations.SymbolTableManagement;
import org.eclipse.n4js.transpiler.operations.TranspilerStateOperations;
import org.eclipse.n4js.transpiler.utils.TranspilerDebugUtils;
import org.eclipse.n4js.transpiler.utils.TranspilerUtils;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public abstract class TranspilerComponent {
    @Inject
    private TranspilerState state;
    @Inject
    private PreparationStep preparationStep;

    public TranspilerComponent() {
        if (this.getClass().isAnnotationPresent(Singleton.class)) {
            throw new IllegalStateException("subclasses of TranspilerComponent must not be annotated with @Singleton");
        }
    }

    protected TranspilerState getState() {
        if (this.state == null) {
            throw new IllegalStateException("transpiler state not available");
        }
        return this.state;
    }

    protected SymbolTableEntryOriginal addNamespaceImport(TModule moduleToImport, String namespaceName) {
        return TranspilerStateOperations.addNamespaceImport(this.state, moduleToImport, namespaceName);
    }

    public SymbolTableEntryOriginal addNamedImport(IdentifiableElement elementToImport, String aliasOrNull) {
        return TranspilerStateOperations.addNamedImport(this.state, elementToImport, aliasOrNull);
    }

    public void addNamedImport(SymbolTableEntryOriginal steOfElementToImport, String aliasOrNull) {
        TranspilerStateOperations.addNamedImport(this.state, steOfElementToImport, aliasOrNull);
    }

    public void addEmptyImport(String moduleSpecifier) {
        TranspilerStateOperations.addEmptyImport(this.state, moduleSpecifier);
    }

    protected void setTarget(ParameterizedCallExpression callExpr, Expression newTarget) {
        TranspilerStateOperations.setTarget(this.state, callExpr, newTarget);
    }

    protected void setTarget(ParameterizedPropertyAccessExpression_IM accExpr, Expression newTarget) {
        TranspilerStateOperations.setTarget(this.state, accExpr, newTarget);
    }

    protected void addArgument(ParameterizedCallExpression callExpr, int index, Expression newArgument) {
        TranspilerStateOperations.addArgument(this.state, callExpr, index, newArgument);
    }

    protected void remove(EObject elementInIntermediateModel) {
        TranspilerStateOperations.remove(this.state, elementInIntermediateModel);
    }

    protected VariableStatement removeExport(ExportedVariableStatement varStmt) {
        return TranspilerStateOperations.removeExport(this.state, varStmt);
    }

    protected void replace(N4ClassDeclaration classDecl, FunctionDeclaration funDecl) {
        TranspilerStateOperations.replace(this.state, classDecl, funDecl);
    }

    protected void replace(N4InterfaceDeclaration ifcDecl, VariableDeclaration varDecl) {
        TranspilerStateOperations.replace(this.state, ifcDecl, varDecl);
    }

    protected void replace(N4EnumDeclaration enumDecl, VariableDeclaration varDecl) {
        TranspilerStateOperations.replace(this.state, enumDecl, varDecl);
    }

    protected void replace(N4EnumDeclaration enumDecl, FunctionDeclaration funDecl) {
        TranspilerStateOperations.replace(this.state, enumDecl, funDecl);
    }

    protected void replace(N4MemberDeclaration memberDecl, N4MemberDeclaration replacement) {
        TranspilerStateOperations.replace(this.state, memberDecl, replacement);
    }

    protected void replace(FunctionDeclaration funDecl, VariableDeclaration varDecl) {
        TranspilerStateOperations.replace(this.state, funDecl, varDecl);
    }

    protected void replace(VariableStatement varStmnt, Statement ... newStmnts) {
        TranspilerStateOperations.replace(this.state, varStmnt, newStmnts);
    }

    protected void replace(VariableBinding varBinding, VariableDeclaration ... varDecls) {
        TranspilerStateOperations.replace(this.state, varBinding, varDecls);
    }

    protected void replace(Statement stmnt, ReturnStatement returnStmnt) {
        TranspilerStateOperations.replace(this.state, stmnt, returnStmnt);
    }

    protected void replace(Expression exprOld, Expression exprNew) {
        TranspilerStateOperations.replace(this.state, exprOld, exprNew);
    }

    protected void replace(ArrowFunction exprOld, ParameterizedCallExpression exprNew, FunctionExpression rewireTarget) {
        TranspilerStateOperations.replace(this.state, exprOld, exprNew, rewireTarget);
    }

    protected void replaceAndRelocate(FormalParameter fPar_to_remove, VariableStatement varStmnt, VariableDeclaration varDecl_wireTo, Block newContainer) {
        TranspilerStateOperations.replaceAndRelocate(this.state, fPar_to_remove, varStmnt, varDecl_wireTo, newContainer);
    }

    protected <T extends Expression> void wrapExistingExpression(T exprToWrap, Expression outerExpr_without_exprToWrap, Procedures.Procedure1<? super T> inserterFunction) {
        TranspilerStateOperations.wrapExistingExpression(this.state, exprToWrap, outerExpr_without_exprToWrap, inserterFunction);
    }

    protected void insertBefore(EObject elementInIntermediateModel, EObject ... newElements) {
        TranspilerStateOperations.insertBefore(this.state, elementInIntermediateModel, newElements);
    }

    protected void insertAfter(EObject elementInIntermediateModel, EObject ... newElements) {
        TranspilerStateOperations.insertAfter(this.state, elementInIntermediateModel, newElements);
    }

    protected <T extends EObject> T copy(T elementInIM) {
        return TranspilerStateOperations.copy(this.state, elementInIM);
    }

    public <T extends EObject> T copyAlienElement(T someElement) {
        if (TranspilerUtils.isIntermediateModelElement(someElement)) {
            throw new IllegalArgumentException("method #copyAlienElement() not intended for copying IM elements - use method #copy() instead!");
        }
        return this.preparationStep.copyForIM(this.state, someElement);
    }

    protected SymbolTableEntryOriginal createSymbolTableEntryOriginal(IdentifiableElement originalTarget) {
        return SymbolTableManagement.createSymbolTableEntryOriginal(this.state, originalTarget);
    }

    protected SymbolTableEntryIMOnly createSymbolTableEntryIMOnly(NamedElement elementInIntermediateModel) {
        return SymbolTableManagement.createSymbolTableEntryIMOnly(this.state, elementInIntermediateModel);
    }

    protected SymbolTableEntryInternal createSymbolTableEntryInternal(String name) {
        return SymbolTableManagement.createSymbolTableEntryInternal(this.state, name);
    }

    protected SymbolTableEntryOriginal getSymbolTableEntryOriginal(IdentifiableElement originalTarget, boolean create) {
        return SymbolTableManagement.getSymbolTableEntryOriginal(this.state, originalTarget, create);
    }

    protected SymbolTableEntryOriginal getSymbolTableEntryForMember(TClassifier type, String memberName, boolean writeAccess, boolean staticAccess, boolean create) {
        return SymbolTableManagement.getSymbolTableEntryForMember(this.state, type, memberName, writeAccess, staticAccess, create);
    }

    protected SymbolTableEntry findSymbolTableEntryForElement(NamedElement elementInIntermediateModel, boolean create) {
        return SymbolTableManagement.findSymbolTableEntryForElement(this.state, elementInIntermediateModel, create);
    }

    protected SymbolTableEntryInternal getSymbolTableEntryInternal(String name, boolean create) {
        return SymbolTableManagement.getSymbolTableEntryInternal(this.state, name, create);
    }

    protected SymbolTableEntryOriginal findSymbolTableEntryForNamespaceImport(NamespaceImportSpecifier importspec) {
        return SymbolTableManagement.findSymbolTableEntryForNamespaceImport(this.state, importspec);
    }

    protected SymbolTableEntryOriginal findSymbolTableEntryForNamedImport(NamedImportSpecifier importspec) {
        return SymbolTableManagement.findSymbolTableEntryForNamedImport(this.state, importspec);
    }

    protected Collection<SymbolTableEntryOriginal> findSymbolTableEntriesForVersionedTypeImport(VersionedNamedImportSpecifier_IM importspec) {
        return SymbolTableManagement.findSymbolTableEntriesForVersionedTypeImport(this.state, importspec);
    }

    protected void rename(SymbolTableEntry entry, String newName) {
        TranspilerStateOperations.rename(this.state, entry, newName);
    }

    public void addOriginal(SymbolTableEntryOriginal steOriginal) {
        SymbolTableManagement.addOriginal(this.state, steOriginal);
    }

    public <T extends EObject> List<T> collectNodes(EObject root, Class<T> cls, boolean searchForNestedNodes) {
        return TranspilerUtils.collectNodes(root, cls, searchForNestedNodes);
    }

    public ReferencingElementExpression_IM __NSSafe_IdentRef(SymbolTableEntry entry) {
        ImportSpecifier impSpec;
        if (entry instanceof SymbolTableEntryOriginal && (impSpec = ((SymbolTableEntryOriginal)entry).getImportSpecifier()) instanceof NamespaceImportSpecifier) {
            SymbolTableEntryOriginal steNS = this.findSymbolTableEntryForNamespaceImport((NamespaceImportSpecifier)impSpec);
            return TranspilerBuilderBlocks._PropertyAccessExpr(steNS, entry);
        }
        return TranspilerBuilderBlocks._IdentRef(entry);
    }

    public ParameterizedPropertyAccessExpression_IM __NSSafe_PropertyAccessExpr(SymbolTableEntry target, SymbolTableEntry ... properties) {
        return TranspilerBuilderBlocks._PropertyAccessExpr(this.__NSSafe_IdentRef(target), properties);
    }

    protected void assertTrue(String message, boolean value) {
        TranspilerDebugUtils.assertTrue(message, value);
    }

    protected void assertFalse(String message, boolean value) {
        TranspilerDebugUtils.assertFalse(message, value);
    }

    protected void assertNull(String message, Object value) {
        TranspilerDebugUtils.assertNull(message, value);
    }

    protected void assertNotNull(String message, Object value) {
        TranspilerDebugUtils.assertNotNull(message, value);
    }

    protected IdentifierRef_IM undefinedRef() {
        return TranspilerBuilderBlocks._IdentRef(this.getSymbolTableEntryForMember((TClassifier)RuleEnvironmentExtensions.globalObjectType((RuleEnvironment)this.state.G), "undefined", false, false, true));
    }

    public SymbolTableEntryInternal steFor_arguments() {
        return this.getSymbolTableEntryInternal("arguments", true);
    }

    public SymbolTableEntryInternal steFor_N4ApiNotImplementedError() {
        return this.getSymbolTableEntryInternal("N4ApiNotImplementedError", true);
    }

    public SymbolTableEntryInternal steFor_$makeClass() {
        return this.getSymbolTableEntryInternal("$makeClass", true);
    }

    public SymbolTableEntryInternal steFor_$methods() {
        return this.getSymbolTableEntryInternal("$methods", true);
    }

    public SymbolTableEntryInternal steFor_$makeInterface() {
        return this.getSymbolTableEntryInternal("$makeInterface", true);
    }

    public SymbolTableEntryInternal steFor_$makeEnum() {
        return this.getSymbolTableEntryInternal("$makeEnum", true);
    }

    public SymbolTableEntryInternal steFor_N4Class() {
        return this.getSymbolTableEntryInternal("N4Class", true);
    }

    public SymbolTableEntryInternal steFor_N4Interface() {
        return this.getSymbolTableEntryInternal("N4Interface", true);
    }

    public SymbolTableEntryInternal steFor_N4EnumType() {
        return this.getSymbolTableEntryInternal("N4EnumType", true);
    }

    public SymbolTableEntryInternal steFor_N4Method() {
        return this.getSymbolTableEntryInternal("N4Method", true);
    }

    public SymbolTableEntryInternal steFor_N4Accessor() {
        return this.getSymbolTableEntryInternal("N4Accessor", true);
    }

    public SymbolTableEntryInternal steFor_N4DataField() {
        return this.getSymbolTableEntryInternal("N4DataField", true);
    }

    public SymbolTableEntryInternal steFor_N4Member() {
        return this.getSymbolTableEntryInternal("N4Member", true);
    }

    public SymbolTableEntryInternal steFor_N4Annotation() {
        return this.getSymbolTableEntryInternal("N4Annotation", true);
    }

    public SymbolTableEntryInternal steFor_$fieldInit() {
        return this.getSymbolTableEntryInternal("$fieldInit", true);
    }

    public SymbolTableEntryInternal steFor___proto__() {
        return this.getSymbolTableEntryInternal("__proto__", true);
    }

    public SymbolTableEntryInternal steFor_get() {
        return this.getSymbolTableEntryInternal("get", true);
    }

    public SymbolTableEntryInternal steFor_set() {
        return this.getSymbolTableEntryInternal("set", true);
    }

    public SymbolTableEntryInternal steFor_value() {
        return this.getSymbolTableEntryInternal("value", true);
    }

    public SymbolTableEntryInternal steFor_$sliceToArrayForDestruct() {
        return this.getSymbolTableEntryInternal("$sliceToArrayForDestruct", true);
    }

    public SymbolTableEntryInternal steFor_$implements() {
        return this.getSymbolTableEntryInternal("$implements", true);
    }

    public SymbolTableEntryInternal steFor_$instanceof() {
        return this.getSymbolTableEntryInternal("$instanceof", true);
    }

    public SymbolTableEntryInternal steFor_Array() {
        return this.getSymbolTableEntryInternal("Array", true);
    }

    public SymbolTableEntryInternal steFor_prototype() {
        return this.getSymbolTableEntryInternal("prototype", true);
    }

    public SymbolTableEntryInternal steFor_slice() {
        return this.getSymbolTableEntryInternal("slice", true);
    }

    public SymbolTableEntryInternal steFor_call() {
        return this.getSymbolTableEntryInternal("call", true);
    }

    public SymbolTableEntryInternal steFor_System() {
        return this.getSymbolTableEntryInternal("System", true);
    }

    public SymbolTableEntryInternal steFor_register() {
        return this.getSymbolTableEntryInternal("register", true);
    }

    public SymbolTableEntryInternal steFor_$n4Export() {
        return this.getSymbolTableEntryInternal("$n4Export", true);
    }

    public SymbolTableEntryInternal steFor_$spawn() {
        return this.getSymbolTableEntryInternal("$spawn", true);
    }

    public SymbolTableEntryInternal steFor_$n4promisifyFunction() {
        return this.getSymbolTableEntryInternal("$n4promisifyFunction", true);
    }

    public SymbolTableEntryInternal steFor_$n4promisifyMethod() {
        return this.getSymbolTableEntryInternal("$n4promisifyMethod", true);
    }

    public SymbolTableEntryInternal steFor_global() {
        return this.getSymbolTableEntryInternal("global", true);
    }

    public SymbolTableEntryInternal steFor_self() {
        return this.getSymbolTableEntryInternal("self", true);
    }

    public SymbolTableEntryInternal steFor_module() {
        return this.getSymbolTableEntryInternal("module", true);
    }

    public SymbolTableEntryInternal steFor_exports() {
        return this.getSymbolTableEntryInternal("exports", true);
    }

    public SymbolTableEntryInternal steFor_Object() {
        return this.getSymbolTableEntryInternal("Object", true);
    }

    public SymbolTableEntryInternal steFor_undefined() {
        return this.getSymbolTableEntryInternal("undefined", true);
    }

    public SymbolTableEntryInternal steFor_require() {
        return this.getSymbolTableEntryInternal("require", true);
    }

    public SymbolTableEntryInternal steFor_assign() {
        return this.getSymbolTableEntryInternal("assign", true);
    }
}

