/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.DestroyFailedException;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.loader.KeyPairResourceParser;
import org.apache.sshd.common.keyprovider.FileKeyPairProvider;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.eclipse.jgit.internal.transport.sshd.RepeatingFilePasswordProvider;
import org.eclipse.jgit.internal.transport.sshd.SshdText;

public abstract class EncryptedFileKeyPairProvider
extends FileKeyPairProvider {
    public EncryptedFileKeyPairProvider(List<Path> paths) {
        super(paths);
    }

    protected KeyPair doLoadKey(String resourceKey, InputStream inputStream, FilePasswordProvider provider) throws IOException, GeneralSecurityException {
        if (!(provider instanceof RepeatingFilePasswordProvider)) {
            return super.doLoadKey(resourceKey, inputStream, provider);
        }
        KeyPairResourceParser parser = SecurityUtils.getKeyPairResourceParser();
        if (parser == null) {
            throw new NoSuchProviderException("No registered key-pair resource parser");
        }
        RepeatingFilePasswordProvider realProvider = (RepeatingFilePasswordProvider)provider;
        List lines = IoUtils.readAllLines((InputStream)inputStream);
        Collection ids = null;
        while (ids == null) {
            try {
                ids = parser.loadKeyPairs(resourceKey, (FilePasswordProvider)realProvider, lines);
                realProvider.handleDecodeAttemptResult(resourceKey, "", null);
                break;
            }
            catch (IOException | RuntimeException | GeneralSecurityException e) {
                RepeatingFilePasswordProvider.ResourceDecodeResult loadResult = realProvider.handleDecodeAttemptResult(resourceKey, "", e);
                if (loadResult == null || loadResult == RepeatingFilePasswordProvider.ResourceDecodeResult.TERMINATE) {
                    throw e;
                }
                if (loadResult != RepeatingFilePasswordProvider.ResourceDecodeResult.RETRY) break;
            }
        }
        if (ids == null) {
            throw new InvalidKeyException(MessageFormat.format(SshdText.get().identityFileNoKey, resourceKey));
        }
        Iterator<KeyPair> keys = ids.iterator();
        if (!keys.hasNext()) {
            throw new InvalidKeyException(MessageFormat.format(SshdText.get().identityFileUnsupportedFormat, resourceKey));
        }
        KeyPair result = (KeyPair)keys.next();
        if (keys.hasNext()) {
            this.log.warn(MessageFormat.format(SshdText.get().identityFileMultipleKeys, resourceKey));
            keys.forEachRemaining(k -> {
                PrivateKey pk = k.getPrivate();
                if (pk != null) {
                    try {
                        pk.destroy();
                    }
                    catch (DestroyFailedException destroyFailedException) {
                        // empty catch block
                    }
                }
            });
        }
        return result;
    }
}

