/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.versions;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.Versionable;
import org.eclipse.n4js.ts.typeRefs.VersionedParameterizedTypeRef;
import org.eclipse.n4js.ts.types.TVersionable;

public class VersionableUtils {
    public static boolean isTVersionable(EObject element) {
        return element instanceof TVersionable && ((TVersionable)element).getVersion() != 0;
    }

    public static boolean isVersionable(EObject element) {
        return element instanceof Versionable && ((Versionable)element).getVersion() != 0;
    }

    public static int getVersion(TypeRef typeRef) {
        return VersionableUtils.streamVersionedSubReferences(typeRef).findFirst().map(s -> s.getVersion()).orElse(0);
    }

    public static int getVersion(List<TypeRef> typeRefs) {
        return typeRefs.stream().map(ref -> VersionableUtils.getVersion(ref)).filter(v -> v != 0).findFirst().orElse(0);
    }

    public static Stream<VersionedParameterizedTypeRef> streamVersionedSubReferences(TypeRef typeRef) {
        return VersionableUtils.streamSubReferences(typeRef).filter(t -> t instanceof VersionedParameterizedTypeRef).map(t -> (VersionedParameterizedTypeRef)t);
    }

    private static Stream<TypeRef> streamSubReferences(TypeRef typeRef) {
        Iterator refAndChildren = Iterators.concat((Iterator)Iterators.singletonIterator((Object)typeRef), (Iterator)typeRef.eAllContents());
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(refAndChildren, 16), false).filter(TypeRef.class::isInstance).map(TypeRef.class::cast);
    }
}

