/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.snippeteditor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.JavaSnippetEditor;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.SnippetMessages;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.actions.OpenAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.handlers.IHandlerService;

public class SnippetOpenOnSelectionAction
extends OpenAction {
    protected JavaSnippetEditor fEditor;
    private String fDialogTitle;
    private String fDialogMessage;

    public SnippetOpenOnSelectionAction(JavaSnippetEditor editor) {
        super((IWorkbenchSite)editor.getSite());
        this.fEditor = editor;
        this.setResources();
        this.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.open.editor");
        ActionHandler handler = new ActionHandler((IAction)this);
        IHandlerService service = (IHandlerService)editor.getSite().getService(IHandlerService.class);
        service.activateHandler("org.eclipse.jdt.ui.edit.text.java.open.editor", (IHandler)handler);
    }

    protected void setResources() {
        this.setText(SnippetMessages.getString("SnippetOpenOnSelectionAction.label"));
        this.setDescription(SnippetMessages.getString("SnippetOpenOnSelectionAction.tooltip"));
        this.setToolTipText(SnippetMessages.getString("SnippetOpenOnSelectionAction.description"));
        this.setDialogTitle(SnippetMessages.getString("SnippetOpenOnSelectionDialog.title"));
        this.setDialogMessage(SnippetMessages.getString("SnippetOpenOnSelectionDialog.message"));
    }

    protected void setDialogTitle(String title) {
        this.fDialogTitle = title;
    }

    protected void setDialogMessage(String message) {
        this.fDialogMessage = message;
    }

    protected void setEditor(JavaSnippetEditor contentEditor) {
        this.fEditor = contentEditor;
    }

    protected IJavaElement selectJavaElement(List<IJavaElement> elements, Shell shell, String title, String message) {
        Object[] selection;
        int nResults = elements.size();
        if (nResults == 0) {
            return null;
        }
        if (nResults == 1) {
            return elements.get(0);
        }
        int flags = JavaElementLabelProvider.SHOW_DEFAULT | 0x400 | 0x40;
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new JavaElementLabelProvider(flags));
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setElements(elements.toArray());
        if (dialog.open() == 0 && (selection = dialog.getResult()) != null && selection.length > 0) {
            nResults = selection.length;
            int i = 0;
            while (i < nResults) {
                Object current = selection[i];
                if (current instanceof IJavaElement) {
                    return (IJavaElement)current;
                }
                ++i;
            }
        }
        return null;
    }

    protected List<IJavaElement> filterResolveResults(IJavaElement[] codeResolveResults) {
        int nResults = codeResolveResults.length;
        ArrayList<IJavaElement> refs = new ArrayList<IJavaElement>(nResults);
        int i = 0;
        while (i < nResults) {
            if (codeResolveResults[i] instanceof ISourceReference) {
                refs.add(codeResolveResults[i]);
            }
            ++i;
        }
        return refs;
    }

    public void run() {
        if (this.fEditor == null) {
            return;
        }
        try {
            IJavaElement chosen;
            IJavaElement[] result = this.fEditor.codeResolve();
            if (result != null && result.length > 0 && (chosen = this.selectJavaElement(this.filterResolveResults(result), this.getShell(), this.fDialogTitle, this.fDialogMessage)) != null) {
                this.run((IStructuredSelection)new StructuredSelection((Object)chosen));
                return;
            }
        }
        catch (JavaModelException x) {
            JDIDebugUIPlugin.log(x);
        }
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(this.fEditor != null);
    }
}

