/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.server.resources.tests;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.n4js.tester.domain.TestResult;
import org.eclipse.n4js.tester.events.TestEndedEvent;
import org.eclipse.n4js.tester.events.TestEvent;
import org.eclipse.n4js.tester.server.HttpConstants;
import org.eclipse.n4js.tester.server.resources.ClientResourceException;
import org.eclipse.n4js.tester.server.resources.ContentType;
import org.eclipse.n4js.tester.server.resources.HttpMethod;
import org.eclipse.n4js.tester.server.resources.Resource;
import org.eclipse.n4js.tester.server.resources.tests.TestResource;

@Resource(path="/{sessionId}/tests/{testId}/end/", method={HttpMethod.POST}, requestContentType={ContentType.END_TEST})
public class EndTestResource
extends TestResource {
    @Inject
    private ObjectMapper mapper;

    @Override
    protected TestEvent createEvent(String sessionId, String testId, String body) throws ClientResourceException {
        if (Strings.isNullOrEmpty((String)body)) {
            throw new ClientResourceException(400);
        }
        AtomicReference<TestResult> result = new AtomicReference<TestResult>();
        try {
            result.set((TestResult)this.mapper.readValue(body, TestResult.class));
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ClientResourceException(HttpConstants.SC_UNPROCESSABLE_ENTITY);
        }
        catch (IOException e) {
            throw new ClientResourceException(400);
        }
        return new TestEndedEvent(sessionId, testId, (TestResult)result.get());
    }
}

