/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.ui.results;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.n4js.xpect.ui.N4IDEXpectUIPlugin;
import org.eclipse.n4js.xpect.ui.results.ConsoleDisplayMgr;
import org.eclipse.n4js.xpect.ui.results.N4IDEXpectView;
import org.eclipse.n4js.xpect.ui.results.XpectConsole;
import org.eclipse.n4js.xpect.ui.results.XpectFileContentsUtil;
import org.eclipse.n4js.xpect.ui.runner.N4IDEXpectFileNameUtil;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.junit.runner.Description;

public abstract class GenerateXpectReportCommandHandler
extends AbstractHandler {
    private N4IDEXpectView view;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        IWorkbenchWindow[] windows = N4IDEXpectUIPlugin.getDefault().getWorkbench().getWorkbenchWindows();
        try {
            this.view = (N4IDEXpectView)windows[0].getActivePage().showView("org.eclipse.n4js.xpect.ui.runner.N4IDEXpectView");
        }
        catch (PartInitException e) {
            N4IDEXpectUIPlugin.logError("cannot refresh test view window", e);
        }
        Description desc = (Description)selection.getFirstElement();
        if (desc.isSuite()) {
            N4IDEXpectView finalview = this.view;
            boolean suitePassed = desc.getChildren().stream().noneMatch(childDescription -> n4IDEXpectView.testsExecutionStatus.hasFailed((Description)childDescription));
            if (suitePassed) {
                XpectFileContentsUtil.getXpectFileContentAccess(desc).ifPresent(xpectFielContentAccess -> {
                    if (xpectFielContentAccess.containsFixme()) {
                        this.generateAndDisplayReport(N4IDEXpectFileNameUtil.getSuiteName(desc), xpectFielContentAccess.getContetns());
                    }
                });
            } else {
                XpectConsole console = ConsoleDisplayMgr.getOrCreate("generated bug for " + N4IDEXpectFileNameUtil.getSuiteName(desc));
                console.clear();
                String ls = System.lineSeparator();
                console.log("Suite must be passing and contain XPECT FIXME marker to be submited bug report. Please :" + ls + " - fix failing tests" + ls + " - mark test in question with XPECT FIXME");
            }
        }
        return null;
    }

    protected abstract void generateAndDisplayReport(String var1, String var2);
}

