/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xpand2.ast;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.internal.xpand2.ast.AbstractDefinition;
import org.eclipse.internal.xpand2.ast.AbstractXpandVisitor;
import org.eclipse.internal.xpand2.ast.ExpandStatement;
import org.eclipse.internal.xpand2.ast.Template;
import org.eclipse.internal.xpand2.ast.XpandAnalyzable;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.TypeNameUtil;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportDeclaration
extends SyntaxElement
implements XpandAnalyzable {
    private Identifier importString;

    public ImportDeclaration(Identifier importString) {
        this.importString = importString;
    }

    public Identifier getImportString() {
        return this.importString;
    }

    @Override
    public void analyze(XpandExecutionContext ctx, Set<AnalysationIssue> issues) {
        try {
            if (ctx.getCallback() != null && !ctx.getCallback().pre((SyntaxElement)this, (ExecutionContext)ctx)) {
                return;
            }
            boolean knownNamespace = false;
            String importStringValue = this.importString.toString();
            if (!ctx.getNamespaces().contains(importStringValue)) {
                Type[] typeArray = ctx.getAllTypes();
                int n = typeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Type t = typeArray[n2];
                    if (importStringValue.equals(TypeNameUtil.withoutLastSegment((String)t.getName()))) {
                        knownNamespace = true;
                        break;
                    }
                    ++n2;
                }
            } else {
                knownNamespace = true;
            }
            if (!knownNamespace) {
                Template tpl = (Template)ctx.currentResource();
                final HashSet targetNamespaces = new HashSet();
                AbstractDefinition[] abstractDefinitionArray = tpl.getAllDefinitions();
                int n = abstractDefinitionArray.length;
                int n3 = 0;
                while (n3 < n) {
                    AbstractDefinition def = abstractDefinitionArray[n3];
                    def.accept(new AbstractXpandVisitor(){

                        protected Object visitExpandStatement(ExpandStatement node) {
                            if (node.getTargetNamespace() != null) {
                                targetNamespaces.add(node.getTargetNamespace());
                            }
                            return super.visitExpandStatement(node);
                        }
                    });
                    ++n3;
                }
                for (String namespace : targetNamespaces) {
                    if (!importStringValue.equals(namespace)) continue;
                    knownNamespace = true;
                    break;
                }
            }
            if (!knownNamespace) {
                String msg = "Namespace " + importStringValue + " is unknown or unused.";
                issues.add(new AnalysationIssue(AnalysationIssue.INTERNAL_ERROR, msg, (SyntaxElement)this, true));
            }
        }
        finally {
            if (ctx.getCallback() != null) {
                ctx.getCallback().post((SyntaxElement)this, (ExecutionContext)ctx, null);
            }
        }
    }

    public String toString() {
        return "\u00ab" + "IMPORT" + " " + this.importString + "\u00bb" + " (" + this.getFileName() + '@' + this.getLine() + ':' + this.getStart() + '-' + this.getEnd() + ")";
    }
}

