/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.n4js.ts.types.FieldAccessor;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.types.TStructField;
import org.eclipse.n4js.ts.types.TypingStrategy;
import org.eclipse.n4js.utils.MembersByNameTypeAndAccessComparator;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.n4js.utils.StructuralMembersPredicates;
import org.eclipse.n4js.utils.StructuralMembersTriple;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class StructuralMembersTripleIterator
implements Iterator<StructuralMembersTriple> {
    private static final MembersByNameTypeAndAccessComparator MEMBERS_BY_NameTypeAndAccess = new MembersByNameTypeAndAccessComparator(false);
    private static final MembersByNameTypeAndAccessComparator MEMBERS_BY_NameAndAccess = new MembersByNameTypeAndAccessComparator(true);
    private final TMember[] membersLeft;
    private final TMember[] membersRight;
    private final TypingStrategy leftStrategy;
    private final TypingStrategy rightStrategy;
    private int leftIndex = 0;
    private int rightIndex = 0;
    private Optional<StructuralMembersTriple> nextTriple = null;

    private StructuralMembersTripleIterator(TMember[] membersLeft, TMember[] membersRight, TypingStrategy leftStrategy, TypingStrategy rightStrategy) {
        this.membersLeft = membersLeft;
        this.membersRight = membersRight;
        this.leftStrategy = leftStrategy;
        this.rightStrategy = rightStrategy;
        this.computeNext();
    }

    public static StructuralMembersTripleIterator ofUnprepared(Iterable<TMember> membersLeft, Iterable<TMember> membersRight, TypingStrategy leftStrategy, TypingStrategy rightStrategy) {
        return StructuralMembersTripleIterator.ofPrepared(StructuralMembersTripleIterator.toSortedArray(membersLeft), StructuralMembersTripleIterator.toSortedArray(membersRight), leftStrategy, rightStrategy);
    }

    public static StructuralMembersTripleIterator ofPrepared(TMember[] membersLeft, TMember[] membersRight, TypingStrategy leftStrategy, TypingStrategy rightStrategy) {
        return new StructuralMembersTripleIterator(membersLeft, membersRight, leftStrategy, rightStrategy);
    }

    @Override
    public boolean hasNext() {
        return this.nextTriple.isPresent();
    }

    @Override
    public StructuralMembersTriple next() {
        boolean _not;
        boolean _isPresent = this.nextTriple.isPresent();
        boolean bl = _not = !_isPresent;
        if (_not) {
            throw new NoSuchElementException();
        }
        StructuralMembersTriple currentTriple = (StructuralMembersTriple)this.nextTriple.get();
        this.computeNext();
        return currentTriple;
    }

    private void computeNext() {
        boolean _lessThan;
        int _size = ((List)Conversions.doWrapArray((Object)this.membersRight)).size();
        boolean bl = _lessThan = this.rightIndex < _size;
        if (_lessThan) {
            TMember rightMember = this.membersRight[this.rightIndex];
            TMember leftMember = null;
            int compare = 0;
            do {
                TMember _xifexpression = null;
                int _size_1 = ((List)Conversions.doWrapArray((Object)this.membersLeft)).size();
                boolean _lessThan_1 = this.leftIndex < _size_1;
                _xifexpression = _lessThan_1 ? this.membersLeft[this.leftIndex] : null;
                leftMember = _xifexpression;
                compare = MEMBERS_BY_NameAndAccess.compare(leftMember, rightMember);
                if (compare == 0 && !this.compatibleMemberTypes(leftMember, rightMember)) {
                    compare = MEMBERS_BY_NameTypeAndAccess.compare(leftMember, rightMember);
                }
                if (compare < 0) {
                    ++this.leftIndex;
                    continue;
                }
                if (compare <= 0) continue;
                leftMember = null;
            } while (compare < 0);
            FieldAccessor leftOtherAccessor = null;
            if (rightMember instanceof TField && leftMember instanceof FieldAccessor) {
                TMember _xifexpression = null;
                int _size_1 = ((List)Conversions.doWrapArray((Object)this.membersLeft)).size();
                boolean _lessThan_1 = this.leftIndex + 1 < _size_1;
                _xifexpression = _lessThan_1 ? this.membersLeft[this.leftIndex + 1] : null;
                TMember leftMemberNext = _xifexpression;
                if (leftMemberNext instanceof FieldAccessor && Objects.equal((Object)leftMemberNext.getName(), (Object)rightMember.getName())) {
                    leftOtherAccessor = (FieldAccessor)leftMemberNext;
                    ++this.leftIndex;
                }
            }
            StructuralMembersTriple _structuralMembersTriple = new StructuralMembersTriple(leftMember, rightMember, leftOtherAccessor);
            this.nextTriple = Optional.of((Object)_structuralMembersTriple);
            ++this.rightIndex;
        } else {
            this.nextTriple = Optional.absent();
        }
    }

    private boolean compatibleMemberTypes(TMember left, TMember right) {
        if (TypingStrategy.STRUCTURAL_FIELD_INITIALIZER == this.rightStrategy && TypingStrategy.STRUCTURAL_WRITE_ONLY_FIELDS == this.leftStrategy && left instanceof FieldAccessor && N4JSLanguageUtils.isWriteableField(right)) {
            return false;
        }
        return left instanceof TField && right instanceof TField || left instanceof TGetter && right instanceof TGetter || left instanceof TSetter && right instanceof TSetter || left instanceof TMethod && right instanceof TMethod || left instanceof FieldAccessor && N4JSLanguageUtils.isWriteableField(right) || N4JSLanguageUtils.isWriteableField(left) && right instanceof FieldAccessor || left instanceof TGetter && N4JSLanguageUtils.isReadOnlyField(right) || N4JSLanguageUtils.isReadOnlyField(left) && right instanceof TGetter || left instanceof TStructField && right instanceof TMethod || TypingStrategy.STRUCTURAL_FIELD_INITIALIZER == this.rightStrategy && TypingStrategy.STRUCTURAL_WRITE_ONLY_FIELDS != this.leftStrategy && StructuralMembersPredicates.WRITABLE_FIELDS_PREDICATE.apply((Object)right) != false && StructuralMembersPredicates.READABLE_FIELDS_PREDICATE.apply((Object)left) != false;
    }

    public static TMember[] toSortedArray(Iterable<TMember> members) {
        return (TMember[])Conversions.unwrapArray((Object)IterableExtensions.sortWith((Iterable)IterableExtensions.toSet(members), (Comparator)MEMBERS_BY_NameTypeAndAccess), TMember.class);
    }
}

