/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.console;

import java.io.File;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSStackTraceLocationText {
    public static final Pattern JAVASCRIPT_STRACKTRACE_LOCATION_PATTERN = Pattern.compile("\\((.*):([0-9]+):([0-9]+)\\)");
    public final String fileName;
    public final int line;
    public final int column;

    public JSStackTraceLocationText(String linkText) {
        String name;
        Matcher matcher = JAVASCRIPT_STRACKTRACE_LOCATION_PATTERN.matcher(linkText);
        if (matcher.find()) {
            name = matcher.group(1);
            if (name.startsWith("file://")) {
                name = name.substring("file://".length());
            }
        } else {
            throw new IllegalArgumentException("No matches found");
        }
        this.fileName = name;
        this.line = Integer.parseInt(matcher.group(2));
        this.column = Integer.parseInt(matcher.group(3));
    }

    public JSStackTraceLocationText(Matcher matcher) {
        String name = matcher.group(1);
        if (name.startsWith("file://")) {
            name = name.substring("file://".length());
        }
        this.fileName = name;
        this.line = Integer.parseInt(matcher.group(2));
        this.column = Integer.parseInt(matcher.group(3));
    }

    public JSStackTraceLocationText(Path path, int line, int column) {
        this.fileName = path.toString();
        this.line = line;
        this.column = column;
    }

    public String getSimpleName() {
        File f = new File(this.fileName);
        return f.getName();
    }

    public String getExtension() {
        String name = this.getSimpleName();
        int i = name.lastIndexOf(46);
        if (i >= 0 && i < name.length()) {
            return name.substring(i + 1);
        }
        return "";
    }
}

