/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.internal;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.n4js.external.ExternalProject;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.ui.internal.ProjectDescriptionLoadListener;
import org.eclipse.n4js.ui.projectModel.IN4JSEclipseCore;
import org.eclipse.n4js.ui.projectModel.IN4JSEclipseProject;

public class N4JSProjectDependencyStrategy
implements ProjectDescriptionLoadListener.Strategy {
    private final IN4JSEclipseCore core;

    @Inject
    N4JSProjectDependencyStrategy(IN4JSEclipseCore core) {
        this.core = core;
    }

    @Override
    public List<IProject> getProjectDependencies(IProject project) {
        return this.getProjectDependencies(project, false);
    }

    public List<IProject> getProjectDependencies(IProject project, boolean includeMissingOrClosedProjects) {
        IN4JSEclipseProject n4Project = (IN4JSEclipseProject)this.core.create(project).orNull();
        if (n4Project != null) {
            ImmutableList<? extends IN4JSEclipseProject> dependencies = n4Project.getDependenciesAndImplementedApis(includeMissingOrClosedProjects);
            ImmutableList providedRuntimeLibs = FluentIterable.from((Iterable)n4Project.getProvidedRuntimeLibraries()).filter(IN4JSEclipseProject.class).toList();
            IN4JSProject runtimeEnvironmentProject = (IN4JSProject)n4Project.getExtendedRuntimeEnvironment().orNull();
            IN4JSEclipseProject extendedRE = runtimeEnvironmentProject instanceof IN4JSEclipseProject ? (IN4JSEclipseProject)runtimeEnvironmentProject : null;
            int projectCount = dependencies.size() + providedRuntimeLibs.size();
            if (extendedRE != null) {
                ++projectCount;
            }
            IProject[] projects = new IProject[projectCount];
            int i = 0;
            for (IN4JSEclipseProject dependency : dependencies) {
                projects[i++] = dependency.getProject();
            }
            for (IN4JSEclipseProject providedRuntimeLib : providedRuntimeLibs) {
                projects[i++] = providedRuntimeLib.getProject();
            }
            if (extendedRE != null) {
                projects[i] = extendedRE.getProject();
            }
            return FluentIterable.from(Arrays.asList(projects)).filter(p -> !(p instanceof ExternalProject)).toList();
        }
        return Collections.emptyList();
    }
}

