/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.bundle;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.pde.internal.core.bundle.BundleObject;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.ManifestHeader;
import org.eclipse.pde.internal.core.util.HeaderMap;

public class Bundle
extends BundleObject
implements IBundle {
    private static final long serialVersionUID = 1L;
    private final Map<String, IManifestHeader> fDocumentHeaders = new HeaderMap<String, IManifestHeader>();

    @Override
    public void setHeader(String key, String value) {
        if (value == null) {
            IManifestHeader header = this.fDocumentHeaders.remove(key);
            if (header != null) {
                this.getModel().fireModelObjectChanged(header, key, header.getValue(), null);
            }
        } else {
            IManifestHeader header = this.fDocumentHeaders.get(key);
            if (header == null) {
                header = this.getModel().getFactory().createHeader(key, value);
                this.fDocumentHeaders.put(key, header);
                this.getModel().fireModelObjectChanged(header, key, null, value);
            } else {
                String old = header.getValue();
                header.setValue(value);
                this.getModel().fireModelObjectChanged(header, key, old, value);
            }
        }
    }

    @Override
    public String getHeader(String key) {
        ManifestHeader header = (ManifestHeader)this.fDocumentHeaders.get(key);
        return header != null ? header.getValue() : null;
    }

    public void load(Map<?, ?> headers) {
        this.fDocumentHeaders.clear();
        Iterator<?> iter = headers.keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next().toString();
            if (headers.get(key) == null) continue;
            String value = headers.get(key).toString();
            IManifestHeader header = this.getModel().getFactory().createHeader(key.toString(), value);
            header.update();
            this.fDocumentHeaders.put(key.toString(), header);
        }
    }

    @Override
    public String getLocalization() {
        String localization = this.getHeader("Bundle-Localization");
        return localization != null ? localization : "OSGI-INF/l10n/bundle";
    }

    @Override
    public void renameHeader(String key, String newKey) {
        ManifestHeader header = (ManifestHeader)this.getManifestHeader(key);
        if (header != null) {
            header.setName(newKey);
            this.fDocumentHeaders.put(newKey, this.fDocumentHeaders.remove(key));
        }
        this.getModel().fireModelObjectChanged(header, newKey, key, newKey);
    }

    @Override
    public IManifestHeader getManifestHeader(String key) {
        return this.fDocumentHeaders.get(key);
    }

    @Override
    public Map<String, IManifestHeader> getManifestHeaders() {
        HeaderMap<String, IManifestHeader> copy = new HeaderMap<String, IManifestHeader>();
        copy.putAll(this.fDocumentHeaders);
        return copy;
    }

    protected Map<String, String> getHeaders() {
        HashMap<String, String> result = new HashMap<String, String>(this.fDocumentHeaders.values().size());
        for (IManifestHeader header : this.fDocumentHeaders.values()) {
            if (header.getValue() == null) continue;
            result.put(header.getKey(), header.getValue());
        }
        return result;
    }
}

