/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.jsdoc.ITagDefinition;
import org.eclipse.n4js.jsdoc.MD2HTMLConvertingBuilder;
import org.eclipse.n4js.jsdoc.N4JSDocletParser;
import org.eclipse.n4js.jsdoc.dom.Composite;
import org.eclipse.n4js.jsdoc.dom.ContentNode;
import org.eclipse.n4js.jsdoc.dom.Doclet;
import org.eclipse.n4js.jsdoc.dom.FullMemberReference;
import org.eclipse.n4js.jsdoc.dom.FullTypeReference;
import org.eclipse.n4js.jsdoc.dom.InlineTag;
import org.eclipse.n4js.jsdoc.dom.LineTag;
import org.eclipse.n4js.jsdoc.dom.Literal;
import org.eclipse.n4js.jsdoc.dom.SimpleTypeReference;
import org.eclipse.n4js.jsdoc.dom.TagTitle;
import org.eclipse.n4js.jsdoc.dom.TagValue;
import org.eclipse.n4js.jsdoc.dom.Text;
import org.eclipse.n4js.jsdoc.dom.util.DomSwitch;
import org.eclipse.n4js.jsdoc.tags.AbstractLineTagDefinition;
import org.eclipse.xtext.util.Strings;

public class JSDoc2HoverSerializer
extends DomSwitch<Boolean> {
    private static TagHandler TAG_IGNORE = new TagHandler(){

        @Override
        void content(LineTag lineTag, JSDoc2HoverSerializer serializer, boolean isFirstLine) {
        }
    };
    private static TagHandler TAG_SECTION = new TagHandler(){

        @Override
        void open(ITagDefinition tagDef, JSDoc2HoverSerializer serializer) {
            serializer.md2HtmlBuilder.append("\n<dt>").append(Strings.toFirstUpper((String)tagDef.getTitle())).append(":</dt>\n<dd>");
        }
    };
    private static TagHandler TAG_LIST = new TagHandler(){

        @Override
        void open(ITagDefinition tagDef, JSDoc2HoverSerializer serializer) {
            serializer.md2HtmlBuilder.append("\n<dt>").append(Strings.toFirstUpper((String)tagDef.getTitle())).append(":</dt>\n<dd>");
            serializer.md2HtmlBuilder.append("\n<ul>");
        }

        @Override
        void content(LineTag lineTag, JSDoc2HoverSerializer serializer, boolean isFirstLine) {
            serializer.md2HtmlBuilder.append("<li>");
            for (TagValue val : lineTag.getValues()) {
                serializer.appendContents(val.getContents());
            }
            serializer.md2HtmlBuilder.append("</li>");
        }

        @Override
        void close(ITagDefinition tagDef, JSDoc2HoverSerializer serializer) {
            serializer.md2HtmlBuilder.append("</ul></dd>");
        }
    };
    static Map<ITagDefinition, TagHandler> LINETAG_HANDLERS = new HashMap<ITagDefinition, TagHandler>();
    public static final String NL = "\n * ";
    public static final String NL_PREFIX = " * ";
    MD2HTMLConvertingBuilder md2HtmlBuilder = new MD2HTMLConvertingBuilder();

    static {
        LINETAG_HANDLERS.put(N4JSDocletParser.TAG_SPEC, TAG_SECTION);
        LINETAG_HANDLERS.put(N4JSDocletParser.TAG_AUTHOR, TAG_SECTION);
        LINETAG_HANDLERS.put(N4JSDocletParser.TAG_TODO, TAG_LIST);
        LINETAG_HANDLERS.put(N4JSDocletParser.TAG_PARAM, TAG_LIST);
        LINETAG_HANDLERS.put(N4JSDocletParser.TAG_RETURN, TAG_SECTION);
        LINETAG_HANDLERS.put(N4JSDocletParser.TAG_SPECFROMDESCR, TAG_IGNORE);
        LINETAG_HANDLERS.put(N4JSDocletParser.TAG_TASK, TAG_IGNORE);
        LINETAG_HANDLERS.put(N4JSDocletParser.TAG_REQID, TAG_IGNORE);
        LINETAG_HANDLERS.put(N4JSDocletParser.TAG_API_NOTE, TAG_SECTION);
        LINETAG_HANDLERS.put(N4JSDocletParser.TAG_API_STATE, TAG_IGNORE);
        LINETAG_HANDLERS.put(N4JSDocletParser.TAG_TESTEE, TAG_IGNORE);
        LINETAG_HANDLERS.put(N4JSDocletParser.TAG_TESTEEFROMTYPE, TAG_IGNORE);
        LINETAG_HANDLERS.put(N4JSDocletParser.TAG_TESTEETYPE, TAG_IGNORE);
        LINETAG_HANDLERS.put(N4JSDocletParser.TAG_TESTEEMEMBER, TAG_IGNORE);
    }

    public static String toJSDocString(EObject obj) {
        JSDoc2HoverSerializer serializer = new JSDoc2HoverSerializer();
        if (obj == null) {
            return "";
        }
        serializer.doSwitch(obj);
        return serializer.md2HtmlBuilder.done();
    }

    @Override
    public Boolean caseDoclet(Doclet doclet) {
        this.md2HtmlBuilder.resetMarkdownConverter();
        this.appendContents(doclet.getContents());
        this.md2HtmlBuilder.resetMarkdownConverter();
        HashMap<ITagDefinition, ArrayList<LineTag>> groupedLineTags = new HashMap<ITagDefinition, ArrayList<LineTag>>();
        for (LineTag lineTag : doclet.getLineTags()) {
            ITagDefinition tagDef = lineTag.getTagDefinition();
            ArrayList<LineTag> group = (ArrayList<LineTag>)groupedLineTags.get(tagDef);
            if (group == null) {
                group = new ArrayList<LineTag>(5);
                groupedLineTags.put(tagDef, group);
            }
            group.add(lineTag);
        }
        if (!groupedLineTags.isEmpty()) {
            this.md2HtmlBuilder.append("\n<dl>");
            AbstractLineTagDefinition[] abstractLineTagDefinitionArray = N4JSDocletParser.N4JS_LINE_TAGS;
            int n = N4JSDocletParser.N4JS_LINE_TAGS.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractLineTagDefinition tagDef = abstractLineTagDefinitionArray[n2];
                TagHandler tagHandler = LINETAG_HANDLERS.get(tagDef);
                if (tagHandler == null) {
                    tagHandler = TAG_SECTION;
                }
                if (tagHandler != null) {
                    List lineTags = (List)groupedLineTags.get(tagDef);
                    this.handleLineTags(tagDef, tagHandler, lineTags);
                    this.md2HtmlBuilder.resetMarkdownConverter();
                }
                ++n2;
            }
            this.md2HtmlBuilder.append("\n</dl>");
        }
        return false;
    }

    private void handleLineTags(ITagDefinition tagDef, TagHandler tagHandler, List<LineTag> lineTags) {
        if (lineTags != null && !lineTags.isEmpty()) {
            tagHandler.open(tagDef, this);
            boolean first = true;
            for (LineTag lineTag : lineTags) {
                this.md2HtmlBuilder.resetMarkdownConverter();
                tagHandler.content(lineTag, this, first);
                first = false;
            }
            tagHandler.close(tagDef, this);
        }
    }

    @Override
    public Boolean caseLiteral(Literal object) {
        this.md2HtmlBuilder.append(object.getValue());
        return false;
    }

    @Override
    public Boolean caseSimpleTypeReference(SimpleTypeReference object) {
        this.md2HtmlBuilder.append("<code>").append(object.getTypeName()).append("</code>");
        return false;
    }

    @Override
    public Boolean caseFullTypeReference(FullTypeReference object) {
        this.md2HtmlBuilder.append("<code>");
        this.md2HtmlBuilder.append(object.getModuleName()).append(".");
        this.md2HtmlBuilder.append(object.getTypeName());
        this.md2HtmlBuilder.append("</code>");
        return false;
    }

    @Override
    public Boolean caseFullMemberReference(FullMemberReference object) {
        this.md2HtmlBuilder.append("<code>");
        this.md2HtmlBuilder.append(object.getModuleName()).append(".");
        this.md2HtmlBuilder.append(object.getTypeName());
        if (!object.getMemberName().isEmpty()) {
            if (object.isStaticMember()) {
                this.md2HtmlBuilder.append("#");
            } else {
                this.md2HtmlBuilder.append("'.");
            }
            this.md2HtmlBuilder.append(object.getMemberName());
        }
        this.md2HtmlBuilder.append("</code>");
        return false;
    }

    @Override
    public Boolean caseComposite(Composite object) {
        this.appendContents(object.getContents());
        return false;
    }

    private void appendContents(EList<ContentNode> contents) {
        if (contents.isEmpty()) {
            return;
        }
        for (ContentNode content : contents) {
            this.doSwitch(content);
        }
    }

    @Override
    public Boolean caseText(Text text) {
        this.md2HtmlBuilder.convertAndAppend(text.getText());
        return false;
    }

    @Override
    public Boolean caseLineTag(LineTag lineTag) {
        return false;
    }

    @Override
    public Boolean caseTagTitle(TagTitle object) {
        return false;
    }

    @Override
    public Boolean caseInlineTag(InlineTag tag) {
        String htag = "i";
        if (tag.getTagDefinition() == N4JSDocletParser.TAG_CODE) {
            htag = "code";
        }
        this.md2HtmlBuilder.append("<" + htag + ">");
        for (TagValue tagValue : tag.getValues()) {
            this.doSwitch(tagValue);
        }
        this.md2HtmlBuilder.append("</" + htag + ">");
        return false;
    }

    private static abstract class TagHandler {
        private TagHandler() {
        }

        void open(ITagDefinition tagDef, JSDoc2HoverSerializer serializer) {
        }

        void content(LineTag lineTag, JSDoc2HoverSerializer serializer, boolean isFirstLine) {
            if (!isFirstLine) {
                serializer.md2HtmlBuilder.append("<p>");
            }
            for (TagValue val : lineTag.getValues()) {
                serializer.appendContents(val.getContents());
            }
        }

        void close(ITagDefinition tagDef, JSDoc2HoverSerializer serializer) {
        }
    }
}

