/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.op.TagOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.decorators.GitLightweightDecorator;
import org.eclipse.egit.ui.internal.dialogs.CreateTagDialog;
import org.eclipse.egit.ui.internal.push.PushTagsWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TagBuilder;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class TagActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        RevObject tagTarget;
        String currentBranchName;
        final Repository repo = this.getRepository(true, event);
        if (repo == null) {
            return null;
        }
        if (!repo.getRepositoryState().canCheckout()) {
            MessageDialog.openError((Shell)this.getShell(event), (String)UIText.TagAction_cannotCheckout, (String)NLS.bind((String)UIText.TagAction_repositoryState, (Object)repo.getRepositoryState().getDescription()));
            return null;
        }
        try {
            currentBranchName = repo.getBranch();
        }
        catch (IOException e) {
            Activator.handleError(UIText.TagAction_cannotGetBranchName, e, true);
            return null;
        }
        CreateTagDialog dialog = new CreateTagDialog(this.getShell(event), currentBranchName, repo);
        if (dialog.open() != 0) {
            return null;
        }
        final TagBuilder tag = new TagBuilder();
        PersonIdent personIdent = new PersonIdent(repo);
        final String tagName = dialog.getTagName();
        tag.setTag(tagName);
        tag.setTagger(personIdent);
        tag.setMessage(dialog.getTagMessage());
        try {
            tagTarget = this.getTagTarget(repo, dialog.getTagCommit());
        }
        catch (IOException e1) {
            Activator.handleError(UIText.TagAction_unableToResolveHeadObjectId, e1, true);
            return null;
        }
        tag.setObjectId(tagTarget);
        String tagJobName = NLS.bind((String)UIText.TagAction_creating, (Object)tagName);
        final boolean shouldMoveTag = dialog.shouldOverWriteTag();
        Job tagJob = new Job(tagJobName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        new TagOperation(repo, tag, shouldMoveTag).execute(monitor);
                    }
                    catch (CoreException e) {
                        IStatus iStatus = Activator.createErrorStatus(UIText.TagAction_taggingFailed, e);
                        GitLightweightDecorator.refresh();
                        return iStatus;
                    }
                }
                finally {
                    GitLightweightDecorator.refresh();
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.TAG.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        if (dialog.shouldStartPushWizard()) {
            tagJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent jobChangeEvent) {
                    if (jobChangeEvent.getResult().isOK()) {
                        PushTagsWizard.openWizardDialog(repo, tagName);
                    }
                }
            });
        }
        tagJob.setUser(true);
        tagJob.schedule();
        return null;
    }

    @Override
    public boolean isEnabled() {
        Repository repo = this.getRepository();
        return repo != null && this.containsHead(repo);
    }

    private RevObject getTagTarget(Repository repo, ObjectId objectId) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (RevWalk rw = new RevWalk(repo);){
            if (objectId == null) {
                return rw.parseAny((AnyObjectId)repo.resolve("HEAD"));
            }
            return rw.parseAny((AnyObjectId)objectId);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

