/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.runner.ui;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.n4js.runner.IExecutor;
import org.eclipse.n4js.runner.RunConfiguration;
import org.eclipse.n4js.runner.RunnerFrontEnd;

@Singleton
public class RunnerFrontEndUI {
    @Inject
    private RunnerFrontEnd runnerFrontEnd;

    public Process runInUI(RunConfiguration config) throws ExecutionException {
        return this.runnerFrontEnd.run(config, this.createEclipseExecutor());
    }

    public IExecutor createEclipseExecutor() {
        return new IExecutor(){

            public Process exec(String[] cmdLine, File workingDirectory, Map<String, String> envp) throws ExecutionException {
                String[] envpArray = (String[])envp.entrySet().stream().map(pair -> String.valueOf((String)pair.getKey()) + "=" + (String)pair.getValue()).toArray(String[]::new);
                try {
                    return DebugPlugin.exec((String[])cmdLine, (File)workingDirectory, (String[])envpArray);
                }
                catch (CoreException e) {
                    throw new ExecutionException(e);
                }
            }
        };
    }
}

