/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.wizard.project;

import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.n4js.json.JSON.JSONPackage;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.resource.packagejson.PackageJsonResourceDescriptionExtension;
import org.eclipse.n4js.ui.wizard.project.N4JSProjectInfo;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;

public class N4JSTestedProjectWizardPage
extends WizardPage {
    private final IResourceDescriptions resourceDescriptions;
    private final N4JSProjectInfo projectInfo;

    public N4JSTestedProjectWizardPage(N4JSProjectInfo projectInfo, IResourceDescriptions resourceDescriptions) {
        super("Select projects to be tested");
        this.resourceDescriptions = resourceDescriptions;
        this.projectInfo = projectInfo;
        this.setTitle("Select projects to be tested");
        this.setMessage("Select projects to be tested in your new test project");
    }

    public void createControl(Composite parent) {
        Composite listComposite = new Composite(parent, 0);
        listComposite.setLayout((Layout)new FillLayout());
        ListViewer projectListViewer = new ListViewer(listComposite, 2050);
        projectListViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        projectListViewer.setInput((Object)this.getNonTestProjects());
        DataBindingContext databindingContext = new DataBindingContext();
        parent.addDisposeListener(e -> databindingContext.dispose());
        databindingContext.bindList((IObservableList)ViewersObservables.observeMultiSelection((Viewer)projectListViewer), PojoProperties.list(N4JSProjectInfo.class, (String)"testedProjects").observe((Object)this.projectInfo));
        this.setControl((Control)listComposite);
    }

    private boolean isExternal(URI resourceURI) {
        return !resourceURI.isPlatformResource();
    }

    private String[] getNonTestProjects() {
        Stream<IEObjectDescription> projectDescriptions = StreamSupport.stream(this.resourceDescriptions.getExportedObjectsByType(JSONPackage.Literals.JSON_DOCUMENT).spliterator(), false);
        return (String[])projectDescriptions.filter(desc -> {
            ProjectType type = PackageJsonResourceDescriptionExtension.getProjectType((IEObjectDescription)desc);
            return type != null && !ProjectType.TEST.equals((Object)type);
        }).filter(desc -> !this.isExternal(desc.getEObjectURI())).map(d -> PackageJsonResourceDescriptionExtension.getProjectName((IEObjectDescription)d)).sorted().toArray(String[]::new);
    }
}

