/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesystem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.ts.typeRefs.BoundThisTypeRef;
import org.eclipse.n4js.ts.typeRefs.ComposedTypeRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExprOrRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeRef;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.StructuralTypeRef;
import org.eclipse.n4js.ts.typeRefs.ThisTypeRef;
import org.eclipse.n4js.ts.typeRefs.ThisTypeRefStructural;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeTypeRef;
import org.eclipse.n4js.ts.typeRefs.Wildcard;
import org.eclipse.n4js.ts.typeRefs.util.TypeRefsSwitch;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.AbstractJudgment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pair;

final class SubstTypeVariablesJudgment
extends AbstractJudgment {
    SubstTypeVariablesJudgment() {
    }

    public TypeArgument apply(RuleEnvironment G, TypeArgument typeArg) {
        if (typeArg == null) {
            return null;
        }
        SubstTypeVariablesSwitch theSwitch = new SubstTypeVariablesSwitch(G);
        TypeArgument result = (TypeArgument)theSwitch.doSwitch((EObject)typeArg);
        if (result == null) {
            String stringRep = typeArg.getTypeRefAsString();
            throw new IllegalArgumentException("null return value in substTypeVariables judgment for type argument: " + stringRep);
        }
        return result;
    }

    private final class SubstTypeVariablesSwitch
    extends TypeRefsSwitch<TypeArgument> {
        private final RuleEnvironment G;

        public SubstTypeVariablesSwitch(RuleEnvironment G) {
            this.G = G;
        }

        private Wildcard substTypeVariables(RuleEnvironment G2, Wildcard wildcard) {
            return (Wildcard)this.substTypeVariables(G2, (TypeArgument)wildcard);
        }

        private TypeRef substTypeVariables(RuleEnvironment G2, TypeRef typeRef) {
            return (TypeRef)this.substTypeVariables(G2, (TypeArgument)typeRef);
        }

        private TypeArgument substTypeVariables(RuleEnvironment G2, TypeArgument typeArg) {
            if (G2 == this.G) {
                return (TypeArgument)this.doSwitch((EObject)typeArg);
            }
            return SubstTypeVariablesJudgment.this.apply(G2, typeArg);
        }

        public TypeArgument caseTypeArgument(TypeArgument typeArg) {
            return typeArg;
        }

        public TypeArgument caseWildcard(Wildcard wildcard) {
            TypeRef lb;
            TypeRef ub = wildcard.getDeclaredUpperBound();
            if (ub != null) {
                ub = this.substTypeVariables(this.G, ub);
            }
            if ((lb = wildcard.getDeclaredLowerBound()) != null) {
                lb = this.substTypeVariables(this.G, lb);
            }
            if (ub != wildcard.getDeclaredUpperBound() || lb != wildcard.getDeclaredLowerBound()) {
                Wildcard cpy = (Wildcard)TypeUtils.copy((EObject)wildcard);
                cpy.setDeclaredUpperBound((TypeRef)TypeUtils.copyIfContained((EObject)ub));
                cpy.setDeclaredLowerBound((TypeRef)TypeUtils.copyIfContained((EObject)lb));
                return cpy;
            }
            return wildcard;
        }

        public TypeArgument caseThisTypeRef(ThisTypeRef thisTypeRef) {
            TypeRef boundRefFromEnvUncasted = RuleEnvironmentExtensions.getThisType(this.G);
            if (boundRefFromEnvUncasted instanceof BoundThisTypeRef) {
                BoundThisTypeRef boundRefFromEnv = (BoundThisTypeRef)boundRefFromEnvUncasted;
                BoundThisTypeRef boundRef = TypeUtils.createBoundThisTypeRef((ParameterizedTypeRef)boundRefFromEnv.getActualThisTypeRef());
                boundRef.setTypingStrategy(thisTypeRef.getTypingStrategy());
                TypeUtils.copyTypeModifiers((TypeRef)boundRef, (TypeRef)thisTypeRef);
                return boundRef;
            }
            return thisTypeRef;
        }

        public TypeArgument caseThisTypeRefStructural(ThisTypeRefStructural thisTypeRef) {
            TypeRef boundRefFromEnvUncasted = RuleEnvironmentExtensions.getThisType(this.G);
            if (boundRefFromEnvUncasted instanceof BoundThisTypeRef) {
                BoundThisTypeRef boundRefFromEnv = (BoundThisTypeRef)boundRefFromEnvUncasted;
                BoundThisTypeRef boundRef = TypeUtils.createBoundThisTypeRefStructural((ParameterizedTypeRef)boundRefFromEnv.getActualThisTypeRef(), (ThisTypeRefStructural)thisTypeRef);
                TypeUtils.copyTypeModifiers((TypeRef)boundRef, (TypeRef)thisTypeRef);
                return boundRef;
            }
            return thisTypeRef;
        }

        public TypeArgument caseFunctionTypeRef(FunctionTypeRef typeRef) {
            return this.caseFunctionTypeExprOrRef((FunctionTypeExprOrRef)typeRef);
        }

        public TypeArgument caseFunctionTypeExprOrRef(FunctionTypeExprOrRef typeRef) {
            return SubstTypeVariablesJudgment.this.typeSystemHelper.createSubstitutionOfFunctionTypeExprOrRef(this.G, typeRef);
        }

        public TypeArgument caseComposedTypeRef(ComposedTypeRef typeRef) {
            boolean haveReplacement = false;
            ArrayList substTypeRefs = CollectionLiterals.newArrayList();
            for (TypeRef currTypeRef : typeRef.getTypeRefs()) {
                TypeRef substTypeRef = this.substTypeVariables(this.G, currTypeRef);
                substTypeRefs.add(substTypeRef);
                haveReplacement |= substTypeRef != currTypeRef;
            }
            if (haveReplacement) {
                ComposedTypeRef result = (ComposedTypeRef)TypeUtils.copy((EObject)typeRef);
                result.getTypeRefs().clear();
                result.getTypeRefs().addAll(TypeUtils.copyAll((Collection)substTypeRefs));
                return result;
            }
            return typeRef;
        }

        public TypeArgument caseTypeTypeRef(TypeTypeRef typeRef) {
            TypeArgument tResult;
            TypeArgument typeArg = typeRef.getTypeArg();
            if (typeArg != null && (tResult = this.substTypeVariables(this.G, typeArg)) != typeRef.getTypeArg()) {
                TypeTypeRef result = (TypeTypeRef)TypeUtils.copyIfContained((EObject)typeRef);
                result.setTypeArg((TypeArgument)TypeUtils.copyIfContained((EObject)tResult));
                return result;
            }
            return typeRef;
        }

        public TypeArgument caseParameterizedTypeRef(ParameterizedTypeRef typeRef) {
            ParameterizedTypeRef result = typeRef;
            Type typeRefDeclType = typeRef.getDeclaredType();
            if (typeRefDeclType instanceof TypeVariable) {
                TypeVariable typeVar = (TypeVariable)typeRefDeclType;
                Object tempFromEnvUntyped = this.G.get(typeVar);
                if (tempFromEnvUntyped instanceof TypeRef) {
                    TypeRef tempFromEnv = (TypeRef)tempFromEnvUntyped;
                    TypeRef temp = TypeUtils.mergeTypeModifiers((TypeRef)tempFromEnv, (TypeRef)typeRef);
                    Type tempDeclaredType = temp.getDeclaredType();
                    Pair guardKey = Pair.of((Object)"substTypeVariablesInParameterizedTypeRef", (Object)temp);
                    if (typeVar != tempDeclaredType && (TypeUtils.isOrContainsRefToTypeVar((EObject)temp, (TypeVariable[])new TypeVariable[0]) || tempDeclaredType != null && tempDeclaredType.isGeneric()) && this.G.get(guardKey) == null) {
                        RuleEnvironment G2 = RuleEnvironmentExtensions.wrap(this.G);
                        G2.put(guardKey, Boolean.TRUE);
                        result = this.substTypeVariables(G2, temp);
                        result = (TypeRef)TypeUtils.copy((EObject)result);
                    } else {
                        result = (TypeRef)TypeUtils.copy((EObject)temp);
                    }
                } else if (tempFromEnvUntyped instanceof List) {
                    List l_raw = (List)tempFromEnvUntyped;
                    ArrayList l = CollectionLiterals.newArrayList();
                    int i = 0;
                    while (i < l_raw.size()) {
                        TypeRef temp = (TypeRef)l_raw.get(i);
                        Type tempDeclaredType = temp.getDeclaredType();
                        Pair guardKey = Pair.of((Object)"substTypeVariablesInParameterizedTypeRef", (Object)temp);
                        if (typeVar != tempDeclaredType && (TypeUtils.isOrContainsRefToTypeVar((EObject)temp, (TypeVariable[])new TypeVariable[0]) || tempDeclaredType != null && tempDeclaredType.isGeneric()) && this.G.get(guardKey) == null) {
                            RuleEnvironment G2 = RuleEnvironmentExtensions.wrap(this.G);
                            G2.put(guardKey, Boolean.TRUE);
                            TypeRef tempResult = this.substTypeVariables(G2, temp);
                            tempResult = (TypeRef)TypeUtils.copy((EObject)tempResult);
                            l.add(tempResult);
                        } else {
                            l.add((TypeRef)TypeUtils.copy((EObject)temp));
                        }
                        ++i;
                    }
                    if (typeVar.isDeclaredCovariant()) {
                        result = SubstTypeVariablesJudgment.this.typeSystemHelper.createIntersectionType(this.G, l.toArray(new TypeRef[l.size()]));
                    } else if (typeVar.isDeclaredContravariant()) {
                        result = SubstTypeVariablesJudgment.this.typeSystemHelper.createUnionType(this.G, l.toArray(new TypeRef[l.size()]));
                    } else {
                        RuleEnvironmentExtensions.addInconsistentSubstitutions(this.G, typeVar, l);
                        result = SubstTypeVariablesJudgment.unknown();
                    }
                    TypeUtils.copyTypeModifiers((TypeRef)result, (TypeRef)typeRef);
                }
            }
            if (typeRefDeclType != null && typeRefDeclType.isGeneric()) {
                int len = typeRef.getTypeArgs().size();
                boolean haveSubstitution = false;
                TypeArgument[] argsChanged = new TypeArgument[len];
                int i = 0;
                while (i < len) {
                    TypeArgument arg = (TypeArgument)typeRef.getTypeArgs().get(i);
                    TypeArgument argSubst = this.substTypeVariables(this.G, arg);
                    if (argSubst != arg) {
                        argsChanged[i] = argSubst;
                        haveSubstitution = true;
                    }
                    ++i;
                }
                if (haveSubstitution) {
                    if (result == typeRef) {
                        result = (TypeRef)TypeUtils.copy((EObject)typeRef);
                    }
                    i = 0;
                    while (i < len) {
                        TypeArgument argCh = argsChanged[i];
                        if (argCh != null) {
                            result.getTypeArgs().set(i, (Object)argCh);
                        }
                        ++i;
                    }
                }
            }
            if (result instanceof StructuralTypeRef) {
                result = SubstTypeVariablesJudgment.this.typeSystemHelper.substTypeVariablesInStructuralMembers(this.G, (StructuralTypeRef)result);
            }
            return result;
        }
    }
}

