/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesystem.utils;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.ts.typeRefs.ComposedTypeRef;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.utils.TypeCompareHelper;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.typesystem.utils.TypeSystemHelperStrategy;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

class SimplifyComputer
extends TypeSystemHelperStrategy {
    @Inject
    @Extension
    private TypeCompareHelper _typeCompareHelper;

    SimplifyComputer() {
    }

    public TypeRef createUnionType(RuleEnvironment G, TypeRef ... elements) {
        return this.simplify(G, TypeUtils.createNonSimplifiedUnionType((TypeRef[])elements));
    }

    public TypeRef createIntersectionType(RuleEnvironment G, TypeRef ... elements) {
        return this.simplify(G, TypeUtils.createNonSimplifiedIntersectionType((TypeRef[])elements));
    }

    public <T extends ComposedTypeRef> TypeRef simplify(RuleEnvironment G, T composedType) {
        List<TypeRef> tRs = this.getSimplifiedTypeRefs(G, composedType, true);
        EClass eClass = composedType.eClass();
        EObject _create = EcoreUtil.create((EClass)eClass);
        ComposedTypeRef simplified = (ComposedTypeRef)_create;
        EList typeRefs = simplified.getTypeRefs();
        typeRefs.addAll(tRs);
        int _size = typeRefs.size();
        switch (_size) {
            case 0: {
                return RuleEnvironmentExtensions.undefinedTypeRef(G);
            }
            case 1: {
                return (TypeRef)IterableExtensions.head((Iterable)typeRefs);
            }
        }
        return simplified;
    }

    public <T extends ComposedTypeRef> List<TypeRef> getSimplifiedTypeRefs(RuleEnvironment G, T composedType) {
        return this.getSimplifiedTypeRefs(G, composedType, false);
    }

    private <T extends ComposedTypeRef> List<TypeRef> getSimplifiedTypeRefs(RuleEnvironment G, T composedType, boolean copyIfContained) {
        if (composedType == null) {
            return null;
        }
        EClass eClass = composedType.eClass();
        Comparator _typeRefComparator = this._typeCompareHelper.getTypeRefComparator();
        TreeSet set = new TreeSet(_typeRefComparator);
        Functions.Function1 _function = it -> eClass.isInstance(it);
        boolean _exists = IterableExtensions.exists((Iterable)composedType.getTypeRefs(), (Functions.Function1)_function);
        if (_exists) {
            Iterables.addAll(set, this.flattenComposedTypes(eClass, (TypeRef)composedType));
        } else {
            set.addAll(composedType.getTypeRefs());
        }
        LinkedList<TypeRef> typeRefs = new LinkedList<TypeRef>();
        ParameterizedTypeRef undefinedTypeRef = RuleEnvironmentExtensions.undefinedTypeRef(G);
        ParameterizedTypeRef nullTypeRef = RuleEnvironmentExtensions.nullTypeRef(G);
        for (TypeRef e : set) {
            if (this._typeCompareHelper.compare((TypeArgument)e, (TypeArgument)undefinedTypeRef) == 0 || this._typeCompareHelper.compare((TypeArgument)e, (TypeArgument)nullTypeRef) == 0) continue;
            TypeRef cpy = e;
            if (copyIfContained) {
                cpy = (TypeRef)TypeUtils.copyIfContained((EObject)e);
            }
            typeRefs.add(cpy);
        }
        return typeRefs;
    }

    private Iterable<TypeRef> flattenComposedTypes(EClass eClass, TypeRef typeRef) {
        Iterable<Object> _xifexpression = null;
        boolean _isInstance = eClass.isInstance((Object)typeRef);
        if (_isInstance) {
            Functions.Function1 _function = it -> this.flattenComposedTypes(eClass, (TypeRef)it);
            _xifexpression = Iterables.concat((Iterable)ListExtensions.map((List)((ComposedTypeRef)typeRef).getTypeRefs(), (Functions.Function1)_function));
        } else {
            _xifexpression = Collections.singleton(typeRef);
        }
        return _xifexpression;
    }
}

