/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.text;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.xpect.text.ITextDifferencer;
import org.eclipse.xpect.util.IDifferencer;

public class TextDiffToString
implements Function<ITextDifferencer.ITextDiff, String> {
    private boolean allowSingleLineDiff = true;
    private boolean allowSingleSegmentDiff = true;
    private int linesAfterDiff = 4;
    private int linesBeforeDiff = 4;

    public String apply(ITextDifferencer.ITextDiff input) {
        return this.apply(input.getLines());
    }

    public String apply(List<ITextDifferencer.ILineDiff> lines) {
        ITextDifferencer.ILineDiff line;
        if ((this.allowSingleLineDiff || this.allowSingleSegmentDiff) && (line = this.findSingleChangedLine(lines)) != null) {
            Chunk chunk;
            List<Chunk> chunks = this.toChunks(line);
            if (this.allowSingleSegmentDiff && (chunk = this.findSingleChangedChunk(chunks)) != null) {
                return chunk.getText();
            }
            return Joiner.on((String)"").join(chunks);
        }
        return this.toMultiLineDiff(lines);
    }

    protected ITextDifferencer.ILineDiff findSingleChangedLine(List<ITextDifferencer.ILineDiff> lines) {
        ITextDifferencer.ILineDiff changed = null;
        for (ITextDifferencer.ILineDiff line : lines) {
            switch (line.getKind()) {
                case SIMILAR: {
                    if (changed == null) {
                        changed = line;
                        break;
                    }
                    return null;
                }
                case LEFT_ONLY: 
                case RIGHT_ONLY: {
                    return null;
                }
            }
        }
        return changed;
    }

    protected Chunk findSingleChangedChunk(List<Chunk> chunks) {
        Chunk changed = null;
        for (Chunk chunk : chunks) {
            if (chunk.isEqual()) continue;
            if (changed == null) {
                changed = chunk;
                continue;
            }
            return null;
        }
        return changed;
    }

    protected String getHiddenBetween(ITextDifferencer.ISegment seg1, ITextDifferencer.ISegment seg2) {
        StringBuilder result1 = new StringBuilder();
        ITextDifferencer.ISegment next = seg1.getNext();
        while (next != null && next.isHidden() && !next.isWrap()) {
            result1.append(next);
            next = next.getNext();
        }
        if (next == seg2) {
            return result1.toString();
        }
        StringBuilder result2 = new StringBuilder();
        ITextDifferencer.ISegment prev = seg2.getPrevious();
        while (prev != null && prev.isHidden() && !prev.isWrap()) {
            result2.insert(0, prev);
            prev = prev.getPrevious();
        }
        if (result1.length() > 0 && result2.length() > 0) {
            if (result1.length() < result2.length()) {
                return result1.toString();
            }
            return result2.toString();
        }
        if (result1.length() > 0) {
            return result1.toString();
        }
        return result2.toString();
    }

    protected List<ITextDifferencer.ISegment> getLeftSegments(ITextDifferencer.ILineDiff line) {
        ArrayList result = Lists.newArrayList();
        for (ITextDifferencer.ISegmentDiff match : line.getSegmentDiffs()) {
            ITextDifferencer.ISegment left = match.getLeft();
            if (left == null) continue;
            result.add(left);
        }
        return result;
    }

    public int getLinesAfterDiff() {
        return this.linesAfterDiff;
    }

    public int getLinesBeforeDiff() {
        return this.linesBeforeDiff;
    }

    protected List<ITextDifferencer.ISegment> getRightSegments(ITextDifferencer.ILineDiff line) {
        ArrayList result = Lists.newArrayList();
        for (ITextDifferencer.ISegmentDiff match : line.getSegmentDiffs()) {
            ITextDifferencer.ISegment right = match.getRight();
            if (right == null) continue;
            result.add(right);
        }
        return result;
    }

    public boolean isAllowSingleLineDiff() {
        return this.allowSingleLineDiff;
    }

    public boolean isAllowSingleSegmentDiff() {
        return this.allowSingleSegmentDiff;
    }

    public TextDiffToString setAllowSingleLineDiff(boolean allowSingleLineDiff) {
        this.allowSingleLineDiff = allowSingleLineDiff;
        return this;
    }

    public TextDiffToString setAllowSingleSegmentDiff(boolean allowSingleTokenDiff) {
        this.allowSingleSegmentDiff = allowSingleTokenDiff;
        return this;
    }

    public TextDiffToString setLinesAfterDiff(int linesAfterDiff) {
        this.linesAfterDiff = linesAfterDiff;
        return this;
    }

    public TextDiffToString setLinesBeforeDiff(int linesBeforeDiff) {
        this.linesBeforeDiff = linesBeforeDiff;
        return this;
    }

    private List<Chunk> toChunks(ITextDifferencer.ILineDiff line) {
        List<ITextDifferencer.ISegmentDiff> segmentDiffs = line.getSegmentDiffs();
        ArrayList result = Lists.newArrayList();
        ArrayList left = Lists.newArrayList();
        ArrayList right = Lists.newArrayList();
        ArrayList equal = Lists.newArrayList();
        int i = 0;
        while (i < segmentDiffs.size()) {
            ITextDifferencer.ISegmentDiff match = segmentDiffs.get(i);
            switch (match.getKind()) {
                case EQUAL: {
                    equal.add(match.getLeft());
                    break;
                }
                case LEFT_ONLY: {
                    left.add(match.getLeft());
                    break;
                }
                case RIGHT_ONLY: {
                    right.add(match.getRight());
                    break;
                }
                case SIMILAR: {
                    right.add(match.getRight());
                    left.add(match.getLeft());
                }
            }
            if (match.getKind() == IDifferencer.MatchKind.EQUAL && (left.size() > 0 || right.size() > 0)) {
                result.add(new Chunk("[" + this.toString(left, false, false) + "|" + this.toString(right, false, false) + "]", false));
                left.clear();
                right.clear();
            }
            if (match.getKind() != IDifferencer.MatchKind.EQUAL && equal.size() > 0) {
                result.add(new Chunk(this.toString(equal, true, true), true));
                equal.clear();
            }
            if (i == segmentDiffs.size() - 1) {
                if (left.size() > 0 || right.size() > 0) {
                    result.add(new Chunk("[" + this.toString(left, false, false) + "|" + this.toString(right, false, false) + "]", false));
                }
                if (equal.size() > 0) {
                    result.add(new Chunk(this.toString(equal, true, true), true));
                }
            }
            ++i;
        }
        return result;
    }

    public String toMultiLineDiff(List<ITextDifferencer.ILineDiff> lines) {
        boolean[] enabled = new boolean[lines.size()];
        Arrays.fill(enabled, false);
        int lastDiffLine = -this.linesAfterDiff;
        int line = 0;
        while (line < enabled.length) {
            if (lines.get(line).getKind() != IDifferencer.MatchKind.EQUAL) {
                lastDiffLine = line;
            }
            if (line - lastDiffLine < this.linesAfterDiff) {
                enabled[line] = true;
            }
            ++line;
        }
        lastDiffLine = enabled.length + this.linesBeforeDiff;
        int lastLine = enabled.length - 1;
        while (lastLine >= 0) {
            if (lines.get(lastLine).getKind() != IDifferencer.MatchKind.EQUAL) {
                lastDiffLine = lastLine;
            }
            if (lastDiffLine - lastLine < this.linesBeforeDiff) {
                enabled[lastLine] = true;
            }
            --lastLine;
        }
        ArrayList filtered = Lists.newArrayList();
        boolean out = false;
        int i = 0;
        while (i < enabled.length) {
            if (enabled[i]) {
                filtered.add(this.toPrefixedLine(lines.get(i)));
                out = false;
            } else if (!out) {
                filtered.add("(...)");
                out = true;
            }
            ++i;
        }
        return Joiner.on((char)'\n').join((Iterable)filtered);
    }

    public String toPrefixedLine(ITextDifferencer.ILineDiff line) {
        switch (line.getKind()) {
            case EQUAL: {
                return "  " + this.toString(this.getLeftSegments(line), true, true);
            }
            case LEFT_ONLY: {
                return "- " + this.toString(this.getLeftSegments(line), true, true);
            }
            case RIGHT_ONLY: {
                return "+ " + this.toString(this.getRightSegments(line), true, true);
            }
            case SIMILAR: {
                return "| " + Joiner.on((String)"").join(this.toChunks(line));
            }
        }
        throw new IllegalStateException("unknown MatchKind: " + (Object)((Object)line.getKind()));
    }

    public String toSingleLineDiff(ITextDifferencer.ILineDiff line) {
        return line.toString();
    }

    public String toSingleSegmentDiff(ITextDifferencer.ISegmentDiff segment) {
        return segment.toString();
    }

    protected String toString(List<ITextDifferencer.ISegment> segments, boolean prefix, boolean postfix) {
        if (segments.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        if (prefix) {
            ITextDifferencer.ISegment prev = segments.get(0).getPrevious();
            while (prev != null && prev.isHidden() && !prev.isWrap()) {
                builder.insert(0, prev);
                prev = prev.getPrevious();
            }
        }
        ITextDifferencer.ISegment last = null;
        for (ITextDifferencer.ISegment seg : segments) {
            if (last != null) {
                builder.append(this.getHiddenBetween(last, seg));
            }
            builder.append(seg);
            last = seg;
        }
        if (postfix) {
            ITextDifferencer.ISegment next = segments.get(segments.size() - 1).getNext();
            while (next != null && next.isHidden() && !next.isWrap()) {
                builder.append(next);
                next = next.getNext();
            }
        }
        return builder.toString();
    }

    protected static class Chunk {
        private final boolean equal;
        private final String text;

        public Chunk(String text, boolean equal) {
            this.text = text;
            this.equal = equal;
        }

        public String getText() {
            return this.text;
        }

        public boolean isEqual() {
            return this.equal;
        }

        public String toString() {
            return this.text;
        }
    }
}

