/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.analysis;

import java.util.LinkedList;
import java.util.Objects;
import java.util.TreeSet;
import org.eclipse.n4js.flowgraphs.ControlFlowType;
import org.eclipse.n4js.flowgraphs.analysis.IPathWalker;
import org.eclipse.n4js.flowgraphs.analysis.IPathWalkerInternal;
import org.eclipse.n4js.flowgraphs.analysis.NextEdgesProvider;
import org.eclipse.n4js.flowgraphs.analysis.PathWalkerGuide;
import org.eclipse.n4js.flowgraphs.model.ControlFlowEdge;
import org.eclipse.n4js.flowgraphs.model.Node;
import org.eclipse.n4js.flowgraphs.model.RepresentingNode;
import org.eclipse.n4js.n4JS.ControlFlowElement;

public class Path {
    final Node start;
    final Node end;
    final NextEdgesProvider nextEdgesProvider;
    private final LinkedList<ControlFlowEdge> edges;
    private final TreeSet<ControlFlowType> edgeTypes = new TreeSet();
    private String toString;

    public Path(Node start, Node end, LinkedList<ControlFlowEdge> edges, NextEdgesProvider nextEdgesProvider) {
        Objects.requireNonNull(edges);
        this.start = start;
        this.end = end;
        this.edges = edges;
        this.nextEdgesProvider = nextEdgesProvider;
        this.init();
    }

    public boolean isConnecting() {
        return true;
    }

    public boolean isSelfReturning() {
        return this.start == this.end;
    }

    public boolean isInternal() {
        return !(this.start instanceof RepresentingNode) || !(this.end instanceof RepresentingNode);
    }

    public ControlFlowElement getStart() {
        return this.start.getRepresentedControlFlowElement();
    }

    public ControlFlowElement getEnd() {
        return this.end.getRepresentedControlFlowElement();
    }

    public boolean isEmpty() {
        return this.edges.isEmpty();
    }

    public TreeSet<ControlFlowType> getControlFlowTypes() {
        return this.edgeTypes;
    }

    public int getLength() {
        return this.edges.size();
    }

    public Comparable<?> getIdentifier() {
        return this.toString;
    }

    public void accept(IPathWalker walker) {
        PathWalkerGuide walkerGuide = new PathWalkerGuide(walker);
        this.walkMe(walkerGuide);
    }

    private void init() {
        InitPathWalker initWalker = new InitPathWalker();
        this.walkMe(initWalker);
    }

    private void walkMe(IPathWalkerInternal walker) {
        walker.visitNode(this.start);
        for (ControlFlowEdge edge : this.edges) {
            Node bNode = this.nextEdgesProvider.getPrevNode(edge);
            Node fNode = this.nextEdgesProvider.getNextNode(edge);
            walker.visitEdge(bNode, fNode, edge);
            walker.visitNode(fNode);
        }
    }

    public String toString() {
        return this.toString;
    }

    private class InitPathWalker
    implements IPathWalkerInternal {
        private InitPathWalker() {
        }

        @Override
        public void init() {
            Path.this.toString = "";
            Path.this.edgeTypes.clear();
        }

        @Override
        public void visitNode(Node node) {
            Path.this.toString = String.valueOf(Path.this.toString) + node.name;
        }

        @Override
        public void visitEdge(Node start, Node end, ControlFlowEdge edge) {
            Path.this.toString = String.valueOf(Path.this.toString) + " -" + edge.cfType.name() + "-> ";
            Path.this.edgeTypes.add(edge.cfType);
        }

        @Override
        public void finish() {
        }
    }
}

