/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.resource;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.ts.types.SyntaxRelatedTElement;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.xtext.parser.antlr.IReferableElementsUnloader;

public class N4JSUnloader
implements IReferableElementsUnloader {
    private static final boolean DEBUG = false;
    private static final boolean TIME = false;

    public void unloadRoot(EObject root) {
        List<ObjectToFragment> unloadUs = this.collectElementsToUnload(root);
        this.doUnload(unloadUs, this.getResourceURI(root));
    }

    private URI getResourceURI(EObject root) {
        Resource resource = root.eResource();
        if (resource != null) {
            return resource.getURI();
        }
        return EcoreUtil.getURI((EObject)root).trimFragment();
    }

    private void doUnload(List<ObjectToFragment> result, URI resourceURI) {
        for (ObjectToFragment elementToUnload : result) {
            this.unload(elementToUnload, resourceURI);
        }
    }

    private List<ObjectToFragment> collectElementsToUnload(EObject root) {
        String initialFragment = this.getInitialFragment(root);
        ArrayList result = Lists.newArrayList();
        ObjectToFragment start = new ObjectToFragment(root, initialFragment);
        this.addAndClearAdapters(start, result);
        Iterator<ObjectToFragment> iter = N4JSUnloader.getAllProperContents(start, new StringBuilder(initialFragment));
        while (iter.hasNext()) {
            this.addAndClearAdapters(iter.next(), result);
        }
        return result;
    }

    private String getInitialFragment(EObject root) {
        Resource resource = root.eResource();
        if (resource != null) {
            return resource.getURIFragment(root);
        }
        return EcoreUtil.getURI((EObject)root).fragment();
    }

    private void addAndClearAdapters(ObjectToFragment object, List<ObjectToFragment> result) {
        result.add(object);
        object.object.eAdapters().clear();
    }

    private void unload(ObjectToFragment element, URI resourceURI) {
        SyntaxRelatedTElement casted;
        EObject astElementOrProxy;
        InternalEObject eObject = (InternalEObject)element.object;
        if (eObject instanceof SyntaxRelatedTElement && (astElementOrProxy = (EObject)(casted = (SyntaxRelatedTElement)eObject).eGet((EStructuralFeature)TypesPackage.Literals.SYNTAX_RELATED_TELEMENT__AST_ELEMENT, false)) != null && !astElementOrProxy.eIsProxy()) {
            casted.eSetDeliver(false);
            casted.setAstElement(null);
        }
        eObject.eSetProxyURI(resourceURI.appendFragment(element.fragment));
    }

    private static Iterator<ObjectToFragment> getAllProperContents(ObjectToFragment eObject, final StringBuilder result) {
        return new AbstractTreeIterator<ObjectToFragment>((Object)eObject, false){

            public Iterator<ObjectToFragment> getChildren(Object parent) {
                EObject current = ((ObjectToFragment)parent).object;
                EStructuralFeature[] containments = this.containmentFeatures(current);
                if (containments == null || containments.length == 0) {
                    return Collections.emptyIterator();
                }
                result.append('/');
                return Iterators.concat(this.getFeatureIterators(current, containments));
            }

            private Iterator<Iterator<ObjectToFragment>> getFeatureIterators(final EObject current, final EStructuralFeature[] containments) {
                return new AbstractIterator<Iterator<ObjectToFragment>>(){
                    private final int prevLength;
                    private int featureIdx;
                    {
                        this.prevLength = stringBuilder.length();
                        this.featureIdx = 0;
                    }

                    protected Iterator<ObjectToFragment> computeNext() {
                        while (this.featureIdx < containments.length) {
                            EStructuralFeature containment = containments[this.featureIdx];
                            ++this.featureIdx;
                            if (!current.eIsSet(containment)) continue;
                            result.setLength(this.prevLength);
                            result.append('@').append(containment.getName());
                            return this.newValueIterator(containment);
                        }
                        return (Iterator)this.endOfData();
                    }

                    private Iterator<ObjectToFragment> newValueIterator(EStructuralFeature feature) {
                        if (feature.isMany()) {
                            result.append('.');
                            return this.newManyValueIterator((List)current.eGet(feature));
                        }
                        return this.newSingleValueIterator((EObject)current.eGet(feature));
                    }

                    private Iterator<ObjectToFragment> newSingleValueIterator(EObject value) {
                        ObjectToFragment objectToFragment = new ObjectToFragment(value, result.toString());
                        return Iterators.singletonIterator((Object)objectToFragment);
                    }

                    private AbstractIterator<ObjectToFragment> newManyValueIterator(final List<?> values) {
                        return new AbstractIterator<ObjectToFragment>(){
                            private final int prevLengthBeforeIdx;
                            private int valueIdx;
                            {
                                this.prevLengthBeforeIdx = stringBuilder.length();
                                this.valueIdx = 0;
                            }

                            protected ObjectToFragment computeNext() {
                                if (this.valueIdx < values.size()) {
                                    EObject value = (EObject)values.get(this.valueIdx);
                                    result.setLength(this.prevLengthBeforeIdx);
                                    result.append(this.valueIdx);
                                    ++this.valueIdx;
                                    return new ObjectToFragment(value, result.toString());
                                }
                                return (ObjectToFragment)this.endOfData();
                            }
                        };
                    }
                };
            }

            private EStructuralFeature[] containmentFeatures(EObject current) {
                return ((EClassImpl.FeatureSubsetSupplier)current.eClass().getEAllStructuralFeatures()).containments();
            }
        };
    }

    private static class ObjectToFragment {
        final EObject object;
        final String fragment;

        private ObjectToFragment(EObject object, String fragment) {
            this.object = object;
            this.fragment = fragment;
        }
    }
}

