/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.CancelIndicatorBaseExtractor;
import org.eclipse.n4js.generator.AbstractSubGenerator;
import org.eclipse.n4js.generator.CompilerDescriptor;
import org.eclipse.n4js.generator.GeneratorOption;
import org.eclipse.n4js.internal.RaceDetectionHelper;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.smith.Measurement;
import org.eclipse.n4js.smith.N4JSDataCollectors;
import org.eclipse.n4js.transpiler.AbstractTranspiler;
import org.eclipse.n4js.transpiler.es.EcmaScriptTranspiler;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.util.CancelIndicator;

public class EcmaScriptSubGenerator
extends AbstractSubGenerator {
    private static String COMPILER_ID = "es";
    private static CompilerDescriptor DEFAULT_DESCRIPTOR = EcmaScriptSubGenerator.createDescriptor();
    @Inject
    private EcmaScriptTranspiler ecmaScriptTranspiler;
    @Inject
    private CancelIndicatorBaseExtractor ciExtractor;

    private static CompilerDescriptor createDescriptor() {
        CompilerDescriptor result = new CompilerDescriptor();
        result.setIdentifier(COMPILER_ID);
        result.setName("N4JS to ECMAScript transpiler");
        result.setDescription("Transpiles N4JS to ECMAScript, currently ES5 plus some selected ES6 features supported by V8.");
        result.setActive(true);
        result.setCompiledFileExtension("js");
        result.setCompiledFileSourceMapExtension("map");
        OutputConfiguration outCfg = new OutputConfiguration(COMPILER_ID);
        outCfg.setDescription("N4JS to ECMAScript transpiler");
        outCfg.setOutputDirectory("src-gen");
        outCfg.setOverrideExistingResources(true);
        outCfg.setCreateOutputDirectory(true);
        outCfg.setCleanUpDerivedResources(true);
        outCfg.setSetDerivedProperty(true);
        outCfg.setKeepLocalHistory(Boolean.valueOf(true));
        outCfg.setCanClearOutputDirectory(true);
        result.setOutputConfiguration(outCfg);
        return result;
    }

    public String getCompilerID() {
        return COMPILER_ID;
    }

    public CompilerDescriptor getDefaultDescriptor() {
        return DEFAULT_DESCRIPTOR;
    }

    protected void internalDoGenerate(Resource resource, GeneratorOption[] options, IFileSystemAccess fsa) {
        if (!(resource instanceof N4JSResource)) {
            if ("package.json".equals(resource.getURI().lastSegment())) {
                return;
            }
            throw new IllegalArgumentException("Given resource is not an N4JSResource. " + resource);
        }
        N4JSResource resourceCasted = (N4JSResource)resource;
        if (resourceCasted.getModule().isStaticPolyfillModule()) {
            return;
        }
        Measurement measurement = N4JSDataCollectors.dcTranspiler.getMeasurement(resource.getURI().toString());
        CancelIndicator monitor = this.ciExtractor.extractCancelIndicator((Object)fsa);
        if (this.shouldBeCompiled(resource, monitor)) {
            Script root;
            RaceDetectionHelper.log((String)"About to compile %s", (Object)resource.getURI());
            String compiledFileExtension = this.getCompiledFileExtension(resource);
            String filename = this.getTargetFileName(resource, compiledFileExtension);
            String sourceMapFileExtension = this.getCompiledFileSourceMapExtension(resource);
            String sourceMapFileName = this.getTargetFileName(resource, sourceMapFileExtension);
            RaceDetectionHelper.log((String)"About to write %s", (Object)filename);
            String simpleSourceMapFileName = new File(sourceMapFileName).toPath().getFileName().toString();
            String simpleCompiledFileName = new File(filename).toPath().getFileName().toString();
            Path relativeNavigationToSrc = this.calculateNavigationFromOutputToSourcePath(fsa, this.getCompilerID(), resourceCasted);
            boolean createSourceMap = true;
            if (filename != null && (root = this.rootElement(resource)) != null) {
                StringWriter buffCode = new StringWriter();
                Optional optSourceMapData = Optional.absent();
                if (createSourceMap) {
                    AbstractTranspiler.SourceMapInfo sourceMapDataInstance = new AbstractTranspiler.SourceMapInfo(this.getTranspiler());
                    sourceMapDataInstance.sourceMapBuff = new StringWriter();
                    sourceMapDataInstance.simpleSourceMapFileName = simpleSourceMapFileName;
                    sourceMapDataInstance.simpleCompiledFileName = simpleCompiledFileName;
                    sourceMapDataInstance.isExplicitSourceRef = false;
                    sourceMapDataInstance.n4jsFilePath = relativeNavigationToSrc.resolve(resourceCasted.getURI().lastSegment()).toString();
                    sourceMapDataInstance.sourceMapFileExtension = sourceMapFileExtension;
                    optSourceMapData = Optional.of((Object)sourceMapDataInstance);
                }
                this.getTranspiler().transpile(resourceCasted, options, (Writer)buffCode, optSourceMapData);
                RaceDetectionHelper.log((String)"About to write %d chars", (Object)buffCode.getBuffer().length());
                fsa.generateFile(filename, COMPILER_ID, (CharSequence)buffCode.toString());
                if (createSourceMap) {
                    fsa.generateFile(sourceMapFileName, COMPILER_ID, (CharSequence)((AbstractTranspiler.SourceMapInfo)optSourceMapData.get()).sourceMapBuff.toString());
                }
            }
        }
        measurement.close();
    }

    public String getCompileResultAsText(Script root, GeneratorOption[] options) {
        Resource resource = root.eResource();
        if (!(resource instanceof N4JSResource)) {
            throw new IllegalArgumentException("given script must be contained in an N4JSResource");
        }
        N4JSResource resourceCasted = (N4JSResource)resource;
        StringWriter buffCode = new StringWriter();
        this.getTranspiler().transpile(resourceCasted, options, (Writer)buffCode, Optional.absent());
        return ((Object)buffCode).toString();
    }

    protected AbstractTranspiler getTranspiler() {
        return this.ecmaScriptTranspiler;
    }
}

