/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.preferences;

import com.google.common.base.Preconditions;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.n4js.external.ExternalLibraryHelper;
import org.eclipse.n4js.json.JSON.JSONArray;
import org.eclipse.n4js.json.JSON.JSONDocument;
import org.eclipse.n4js.json.JSON.JSONObject;
import org.eclipse.n4js.json.JSON.JSONValue;
import org.eclipse.n4js.json.model.utils.JSONModelUtils;

public class ExternalLibraryPreferenceModel {
    private static final String PROP_EXTERNAL_LIBRARY_LOCATIONS = "externalLibraryLocations";
    private final List<String> externalLibraryLocations = Lists.newArrayList();
    private final LinkedHashSet<URI> externalLibraryLocationURIs = new LinkedHashSet();
    private final LinkedHashSet<URI> externalNodeModulesURIs = new LinkedHashSet();
    private long externalLibraryLocationURIsHash = 0L;

    public static ExternalLibraryPreferenceModel createDefault() {
        URI homeFolderUri = new File(StandardSystemProperty.USER_HOME.value()).toURI();
        return new ExternalLibraryPreferenceModel(homeFolderUri, new URI[0]);
    }

    public static ExternalLibraryPreferenceModel createDefaultForN4Product() {
        Preconditions.checkState((boolean)Platform.isRunning(), (Object)"Expected running platform.");
        return new ExternalLibraryPreferenceModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExternalLibraryPreferenceModel createFromJson(String jsonString) {
        ExternalLibraryPreferenceModel result;
        JSONDocument document = JSONModelUtils.parseJSON((String)jsonString);
        if (document == null) {
            throw new RuntimeException("Error occurred while trying to parse JSON string.");
        }
        JSONValue extLibLocsValue = JSONModelUtils.getProperty((JSONDocument)document, (String)PROP_EXTERNAL_LIBRARY_LOCATIONS).orElse(null);
        List extLibLocs = JSONModelUtils.asStringsInArrayOrEmpty((JSONValue)extLibLocsValue);
        ExternalLibraryPreferenceModel externalLibraryPreferenceModel = result = new ExternalLibraryPreferenceModel();
        synchronized (externalLibraryPreferenceModel) {
            result.externalLibraryLocations.addAll(extLibLocs);
        }
        return result;
    }

    public ExternalLibraryPreferenceModel() {
        this(Collections.emptyList());
    }

    public ExternalLibraryPreferenceModel(URI firstLocation, URI ... restLocations) {
        this(Lists.asList((Object)firstLocation, (Object[])restLocations));
    }

    public ExternalLibraryPreferenceModel(List<URI> locations) {
        for (URI location : locations) {
            this.checkUri(location);
            String path = new File(location).getAbsolutePath();
            if (this.externalLibraryLocations.contains(path)) continue;
            this.externalLibraryLocations.add(path);
        }
    }

    public List<String> getExternalLibraryLocations() {
        return Collections.unmodifiableList(this.externalLibraryLocations);
    }

    public synchronized boolean add(URI location) {
        if (location == null) {
            return false;
        }
        String path = new File(this.checkUri(location)).getAbsolutePath();
        if (this.externalLibraryLocations.contains(path)) {
            return false;
        }
        return this.externalLibraryLocations.add(path);
    }

    public synchronized boolean remove(URI location) {
        if (location == null) {
            return false;
        }
        String path = new File(this.checkUri(location)).getAbsolutePath();
        return this.externalLibraryLocations.remove(path);
    }

    public synchronized void moveUp(URI location) {
        String path;
        int indexOf;
        if (location != null && (indexOf = this.externalLibraryLocations.indexOf(path = new File(this.checkUri(location)).getAbsolutePath())) > 0) {
            this.externalLibraryLocations.remove(indexOf);
            this.externalLibraryLocations.add(indexOf - 1, path);
        }
    }

    public synchronized void moveDown(URI location) {
        String path;
        int indexOf;
        if (location != null && (indexOf = this.externalLibraryLocations.indexOf(path = new File(this.checkUri(location)).getAbsolutePath())) >= 0 && indexOf < this.externalLibraryLocations.size() - 1) {
            this.externalLibraryLocations.remove(indexOf);
            this.externalLibraryLocations.add(indexOf + 1, path);
        }
    }

    public synchronized LinkedHashSet<URI> getExternalLibraryLocationsAsUris() {
        boolean needUpdate;
        int currentHash = this.externalLibraryLocations.hashCode();
        boolean bl = needUpdate = (long)currentHash != this.externalLibraryLocationURIsHash;
        if (needUpdate) {
            this.externalLibraryLocationURIsHash = currentHash;
            List<URI> locations = new LinkedList<URI>();
            for (String pathStr : this.externalLibraryLocations) {
                locations.add(new File(pathStr).toURI());
            }
            locations = ExternalLibraryHelper.sortByShadowing(locations);
            this.externalLibraryLocationURIs.clear();
            this.externalLibraryLocationURIs.addAll(locations);
            this.externalNodeModulesURIs.clear();
            for (URI location : locations) {
                if (!ExternalLibraryPreferenceModel.isNodeModulesLocation(location)) continue;
                this.externalNodeModulesURIs.add(location);
            }
        }
        return this.externalLibraryLocationURIs;
    }

    public static boolean isNodeModulesLocation(URI location) {
        String locStr = location.toString();
        if (locStr.endsWith("/")) {
            return locStr.endsWith("node_modules/");
        }
        return locStr.endsWith("node_modules");
    }

    public synchronized Collection<URI> getNodeModulesLocationsAsUris() {
        return this.externalNodeModulesURIs;
    }

    public synchronized String toJsonString() {
        JSONArray extLibLocsValue = JSONModelUtils.createStringArray(this.externalLibraryLocations);
        JSONObject obj = JSONModelUtils.createObject((Map)ImmutableMap.of((Object)PROP_EXTERNAL_LIBRARY_LOCATIONS, (Object)extLibLocsValue));
        JSONDocument doc = JSONModelUtils.createDocument((JSONValue)obj);
        return JSONModelUtils.serializeJSON((JSONDocument)doc);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.externalLibraryLocations == null ? 0 : this.externalLibraryLocations.hashCode());
        return result;
    }

    public synchronized boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalLibraryPreferenceModel)) {
            return false;
        }
        ExternalLibraryPreferenceModel other = (ExternalLibraryPreferenceModel)obj;
        return !(this.externalLibraryLocations == null ? other.externalLibraryLocations != null : !this.externalLibraryLocations.equals(other.externalLibraryLocations));
    }

    public String toString() {
        return this.toJsonString();
    }

    private URI checkUri(URI uri) {
        try {
            return new File(uri).toURI();
        }
        catch (Exception e) {
            String message = "Illegal URI: '" + uri + "'." + (e.getMessage() != null ? " " + e.getMessage() : "");
            throw new IllegalArgumentException(message, e);
        }
    }
}

