/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesystem;

import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.ts.typeRefs.BoundThisTypeRef;
import org.eclipse.n4js.ts.typeRefs.ExistentialTypeRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExprOrRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeRef;
import org.eclipse.n4js.ts.typeRefs.IntersectionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeTypeRef;
import org.eclipse.n4js.ts.typeRefs.UnionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.Wildcard;
import org.eclipse.n4js.ts.typeRefs.util.TypeRefsSwitch;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.AbstractJudgment;
import org.eclipse.n4js.typesystem.utils.BoundType;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;

class BoundJudgment
extends AbstractJudgment {
    BoundJudgment() {
    }

    public TypeRef applyUpperBound(RuleEnvironment G, TypeArgument typeArg) {
        BoundSwitch theSwitch = new BoundSwitch(G, BoundType.UPPER);
        TypeRef result = (TypeRef)theSwitch.doSwitch((EObject)typeArg);
        if (result == null) {
            String stringRep = typeArg != null ? typeArg.getTypeRefAsString() : "<null>";
            throw new IllegalStateException("null return value in upperBound judgment for type argument: " + stringRep);
        }
        return result;
    }

    public TypeRef applyLowerBound(RuleEnvironment G, TypeArgument typeArg) {
        BoundSwitch theSwitch = new BoundSwitch(G, BoundType.LOWER);
        TypeRef result = (TypeRef)theSwitch.doSwitch((EObject)typeArg);
        if (result == null) {
            String stringRep = typeArg != null ? typeArg.getTypeRefAsString() : "<null>";
            throw new IllegalStateException("null return value in lowerBound judgment for type argument: " + stringRep);
        }
        return result;
    }

    private final class BoundSwitch
    extends TypeRefsSwitch<TypeRef> {
        private final RuleEnvironment G;
        private final BoundType boundType;

        public BoundSwitch(RuleEnvironment G, BoundType boundType) {
            this.G = G;
            this.boundType = boundType;
        }

        public TypeRef caseTypeRef(TypeRef typeRef) {
            return typeRef;
        }

        public TypeRef caseWildcard(Wildcard wildcard) {
            TypeRef declBound;
            TypeRef typeRef = declBound = this.boundType == BoundType.UPPER ? wildcard.getDeclaredOrImplicitUpperBound() : wildcard.getDeclaredLowerBound();
            if (declBound != null) {
                return declBound;
            }
            return this.boundType == BoundType.UPPER ? RuleEnvironmentExtensions.topTypeRef(this.G) : RuleEnvironmentExtensions.bottomTypeRef(this.G);
        }

        public TypeRef caseExistentialTypeRef(ExistentialTypeRef existentialTypeRef) {
            TypeRef result = this.caseWildcard(existentialTypeRef.getWildcard());
            result = (TypeRef)TypeUtils.copy((EObject)result);
            TypeUtils.copyTypeModifiers((TypeRef)result, (TypeRef)existentialTypeRef);
            return result;
        }

        public TypeRef caseUnionTypeExpression(UnionTypeExpression union) {
            UnionTypeExpression result = TypeUtils.createNonSimplifiedUnionType((Iterable)union.getTypeRefs().stream().map(tr -> (TypeRef)this.doSwitch((EObject)tr)).collect(Collectors.toList()));
            TypeUtils.copyTypeModifiers((TypeRef)result, (TypeRef)union);
            return result;
        }

        public TypeRef caseIntersectionTypeExpression(IntersectionTypeExpression intersection) {
            IntersectionTypeExpression result = TypeUtils.createNonSimplifiedIntersectionType((Iterable)intersection.getTypeRefs().stream().map(tr -> (TypeRef)this.doSwitch((EObject)tr)).collect(Collectors.toList()));
            TypeUtils.copyTypeModifiers((TypeRef)result, (TypeRef)intersection);
            return result;
        }

        public TypeRef caseParameterizedTypeRef(ParameterizedTypeRef ptr) {
            if (ptr.getDeclaredType() instanceof TypeVariable) {
                return ptr;
            }
            return ptr;
        }

        public TypeRef caseFunctionTypeRef(FunctionTypeRef F) {
            return this.caseFunctionTypeExprOrRef((FunctionTypeExprOrRef)F);
        }

        public TypeRef caseFunctionTypeExprOrRef(FunctionTypeExprOrRef F) {
            return BoundJudgment.this.typeSystemHelper.createBoundOfFunctionTypeExprOrRef(this.G, F, this.boundType);
        }

        public TypeRef caseBoundThisTypeRef(BoundThisTypeRef boundThisTypeRef) {
            if (this.boundType == BoundType.UPPER) {
                return TypeUtils.createResolvedThisTypeRef((BoundThisTypeRef)boundThisTypeRef);
            }
            ParameterizedTypeRef result = RuleEnvironmentExtensions.bottomTypeRef(this.G);
            TypeUtils.copyTypeModifiers((TypeRef)result, (TypeRef)boundThisTypeRef);
            return result;
        }

        public TypeRef caseTypeTypeRef(TypeTypeRef ct) {
            TypeArgument typeArg;
            if (this.boundType == BoundType.UPPER && (typeArg = ct.getTypeArg()) instanceof BoundThisTypeRef) {
                ParameterizedTypeRef typeArgNew = TypeUtils.createResolvedThisTypeRef((BoundThisTypeRef)((BoundThisTypeRef)typeArg));
                return TypeUtils.createTypeTypeRef((TypeArgument)typeArgNew, (boolean)ct.isConstructorRef());
            }
            return ct;
        }
    }
}

