/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.utils;

import com.google.inject.Inject;
import java.util.Comparator;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.utils.TypeCompareLogic;
import org.eclipse.xtext.naming.IQualifiedNameProvider;

public class TypeCompareHelper {
    @Inject
    private IQualifiedNameProvider fqnProvider;
    private final TypeComparator typeComparator = new TypeComparator();
    private final TypeArgumentComparator typeArgumentComparator = new TypeArgumentComparator();
    private final TypeRefComparator typeRefComparator = new TypeRefComparator();

    public int compareTypes(Iterable<Type> ts1, Iterable<Type> ts2) {
        return TypeCompareLogic.compareTypes(this.fqnProvider, ts1, ts2);
    }

    public int compareTypeArguments(Iterable<TypeArgument> ts1, Iterable<TypeArgument> ts2) {
        return TypeCompareLogic.compareTypeArguments(this.fqnProvider, ts1, ts2);
    }

    public int compare(Type t1, Type t2) {
        return TypeCompareLogic.compare(this.fqnProvider, t1, t2);
    }

    public int compare(TypeArgument t1, TypeArgument t2) {
        return TypeCompareLogic.compare(this.fqnProvider, t1, t2);
    }

    public Comparator<Type> getTypeComparator() {
        return this.typeComparator;
    }

    public Comparator<TypeArgument> getTypeArgumentComparator() {
        return this.typeArgumentComparator;
    }

    public Comparator<TypeRef> getTypeRefComparator() {
        return this.typeRefComparator;
    }

    private final class TypeArgumentComparator
    implements Comparator<TypeArgument> {
        private TypeArgumentComparator() {
        }

        @Override
        public int compare(TypeArgument t1, TypeArgument t2) {
            return TypeCompareLogic.compare(TypeCompareHelper.this.fqnProvider, t1, t2);
        }
    }

    private final class TypeComparator
    implements Comparator<Type> {
        private TypeComparator() {
        }

        @Override
        public int compare(Type t1, Type t2) {
            return TypeCompareLogic.compare(TypeCompareHelper.this.fqnProvider, t1, t2);
        }
    }

    private final class TypeRefComparator
    implements Comparator<TypeRef> {
        private TypeRefComparator() {
        }

        @Override
        public int compare(TypeRef t1, TypeRef t2) {
            return TypeCompareLogic.compare(TypeCompareHelper.this.fqnProvider, (TypeArgument)t1, (TypeArgument)t2);
        }
    }
}

