/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.text;

import org.eclipse.jface.text.GapTextStore;
import org.eclipse.jface.text.ITextStore;
import org.eclipse.wst.sse.core.internal.text.IRegionComparible;

public class StructuredDocumentTextStore
implements ITextStore,
CharSequence,
IRegionComparible {
    private GapTextStore fInternalStore;

    public StructuredDocumentTextStore() {
        this(50, 300);
    }

    public StructuredDocumentTextStore(int lowWatermark, int highWatermark) {
        this.fInternalStore = new GapTextStore(lowWatermark, highWatermark);
    }

    @Override
    public char charAt(int index) {
        return this.fInternalStore.get(index);
    }

    public char get(int offset) {
        return this.fInternalStore.get(offset);
    }

    public String get(int offset, int length) {
        return this.fInternalStore.get(offset, length);
    }

    public int getLength() {
        return this.fInternalStore.getLength();
    }

    @Override
    public int length() {
        return this.fInternalStore.getLength();
    }

    private boolean matchesIgnoreCase(char c1, char c2) {
        boolean result = false;
        if (Character.toUpperCase(c1) == Character.toUpperCase(c2)) {
            result = true;
        } else if (Character.toLowerCase(c1) == Character.toLowerCase(c2)) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean regionMatches(int offset, int length, String stringToCompare) {
        int endOffset;
        boolean result = false;
        int compareLength = stringToCompare.length();
        if (compareLength == length && (endOffset = offset + length) <= this.length()) {
            result = this.regionMatches(offset, stringToCompare);
        }
        return result;
    }

    private boolean regionMatches(int offset, String stringToCompare) {
        boolean result = true;
        int stringOffset = 0;
        int end = offset + stringToCompare.length();
        int i = offset;
        while (i < end) {
            if (this.charAt(i) != stringToCompare.charAt(stringOffset++)) {
                result = false;
                break;
            }
            ++i;
        }
        return result;
    }

    @Override
    public boolean regionMatchesIgnoreCase(int offset, int length, String stringToCompare) {
        int endOffset;
        boolean result = false;
        int compareLength = stringToCompare.length();
        if (compareLength == length && (endOffset = offset + length) <= this.length()) {
            result = this.regionMatchesIgnoreCase(offset, stringToCompare);
        }
        return result;
    }

    private boolean regionMatchesIgnoreCase(int offset, String stringToCompare) {
        boolean result = true;
        int stringOffset = 0;
        int end = offset + stringToCompare.length();
        int i = offset;
        while (i < end) {
            if (!this.matchesIgnoreCase(this.charAt(i), stringToCompare.charAt(stringOffset++))) {
                result = false;
                break;
            }
            ++i;
        }
        return result;
    }

    public void replace(int offset, int length, String text) {
        this.fInternalStore.replace(offset, length, text);
    }

    public void set(String text) {
        this.fInternalStore.set(text);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.fInternalStore.get(start, end - start);
    }
}

