/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.server.hover;

import com.google.inject.Inject;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.lsp4j.MarkedString;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.n4js.ide.server.hover.N4JSElementSignatureProvider;
import org.eclipse.n4js.n4JS.LiteralOrComputedPropertyName;
import org.eclipse.n4js.validation.N4JSElementKeywordProvider;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.server.hover.HoverContext;
import org.eclipse.xtext.ide.server.hover.HoverService;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;

public class N4JSHoverService
extends HoverService {
    private static final String MARKUP_KIND_PLAIN = "";
    private static final String MARKUP_KIND_MARKDOWN = "markdown";
    @Inject
    private N4JSElementSignatureProvider signatureProvider;
    @Inject
    private N4JSElementKeywordProvider keywordProvider;
    @Inject
    private IEObjectDocumentationProvider documentationProvider;
    @Inject
    private EObjectAtOffsetHelper eobjectHelper;

    protected List<Either<String, MarkedString>> getContents(HoverContext ctx) {
        String documentation;
        LinkedList<Either<String, MarkedString>> contents = new LinkedList<Either<String, MarkedString>>();
        EObject element = ctx.getElement();
        EObject idRef = this.getIdentifierRefOrElement(ctx);
        String signature = this.signatureProvider.get(idRef);
        if (signature != null) {
            String keyword = this.keywordProvider.keyword((Object)element);
            String signatureLabel = this.composeFirstLine(keyword, signature);
            MarkedString mdSignatureLabel = new MarkedString(MARKUP_KIND_PLAIN, signatureLabel);
            contents.add((Either<String, MarkedString>)Either.forRight((Object)mdSignatureLabel));
        }
        if ((documentation = this.documentationProvider.getDocumentation(element)) != null) {
            MarkedString mdDocumentation = new MarkedString(MARKUP_KIND_MARKDOWN, documentation);
            contents.add((Either<String, MarkedString>)Either.forRight((Object)mdDocumentation));
        }
        return contents;
    }

    private EObject getIdentifierRefOrElement(HoverContext ctx) {
        EObject idRef = null;
        if (ctx instanceof N4JSHoverContext) {
            idRef = ((N4JSHoverContext)ctx).getIdentifierRef();
        }
        if (idRef == null) {
            idRef = ctx.getElement();
        }
        return idRef;
    }

    private String composeFirstLine(String keyword, String label) {
        String htmlKeyword = keyword;
        String htmlLabel = label == null ? MARKUP_KIND_PLAIN : label;
        String line = String.valueOf(htmlKeyword) + " " + htmlLabel;
        return line;
    }

    protected HoverContext createContext(Document document, XtextResource resource, int offset) {
        HoverContext hoverContext = super.createContext(document, resource, offset);
        EObject idRef = null;
        INode node = this.eobjectHelper.getCrossReferenceNode(resource, (ITextRegion)new TextRegion(offset, 0));
        if (node != null) {
            idRef = NodeModelUtils.findActualSemanticObjectFor((INode)node);
        }
        return new N4JSHoverContext(hoverContext, idRef);
    }

    public static class N4JSHoverContext
    extends HoverContext {
        private final EObject idRef;

        public N4JSHoverContext(Document document, XtextResource resource, int offset, ITextRegion region, EObject element) {
            this(document, resource, offset, region, element, null);
        }

        public N4JSHoverContext(HoverContext hoverContext, EObject idRef) {
            this(hoverContext.getDocument(), hoverContext.getResource(), hoverContext.getOffset(), hoverContext.getRegion(), hoverContext.getElement(), idRef);
        }

        public N4JSHoverContext(Document document, XtextResource resource, int offset, ITextRegion region, EObject element, EObject idRef) {
            super(document, resource, offset, region, N4JSHoverContext.redirectElement(element));
            this.idRef = idRef;
        }

        public EObject getIdentifierRef() {
            return this.idRef;
        }

        private static EObject redirectElement(EObject element) {
            if (element instanceof LiteralOrComputedPropertyName) {
                element = element.eContainer();
            }
            return element;
        }
    }
}

