/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.flowgraphs.ControlFlowType;
import org.eclipse.n4js.flowgraphs.FGUtils;
import org.eclipse.n4js.n4JS.ControlFlowElement;

public class FlowEdge
implements Comparable<FlowEdge> {
    public final ControlFlowElement start;
    public final ControlFlowElement end;
    public final SortedSet<ControlFlowType> cfTypes;
    private final int cachedHash;

    public FlowEdge(ControlFlowElement start, ControlFlowElement end, Set<ControlFlowType> cfTypes) {
        Preconditions.checkState((start != null && end != null ? 1 : 0) != 0);
        this.start = start;
        this.end = end;
        this.cfTypes = Collections.unmodifiableSortedSet(Sets.newTreeSet(cfTypes));
        ArrayList<Object> ar = new ArrayList<Object>();
        ar.add(start);
        ar.add(end);
        ar.addAll(cfTypes);
        this.cachedHash = Objects.hash(ar.toArray());
    }

    public boolean isDead() {
        return this.cfTypes.contains((Object)ControlFlowType.DeadCode);
    }

    @Override
    public int compareTo(FlowEdge fe) {
        int compareVal = 0;
        compareVal = compareVal != 0 ? compareVal : this.start.hashCode() - fe.start.hashCode();
        compareVal = compareVal != 0 ? compareVal : this.end.hashCode() - fe.end.hashCode();
        compareVal = compareVal != 0 ? compareVal : this.cfTypes.size() - fe.cfTypes.size();
        Iterator myCFTs = this.cfTypes.iterator();
        Iterator otherCFTs = fe.cfTypes.iterator();
        while (compareVal == 0 && myCFTs.hasNext()) {
            ControlFlowType myCFT = (ControlFlowType)((Object)myCFTs.next());
            ControlFlowType otherCFT = (ControlFlowType)((Object)otherCFTs.next());
            compareVal = myCFT.hashCode() - otherCFT.hashCode();
        }
        return compareVal;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FlowEdge)) {
            return false;
        }
        FlowEdge fe = (FlowEdge)o;
        boolean equals = true;
        equals &= this.start == fe.start;
        equals &= this.end == fe.end;
        return equals &= this.cfTypes.equals(fe.cfTypes);
    }

    public int hashCode() {
        return this.cachedHash;
    }

    public String toString() {
        String toString = "";
        toString = String.valueOf(toString) + FGUtils.getSourceText((EObject)this.start);
        toString = String.valueOf(toString) + " -";
        boolean firstCFT = true;
        for (ControlFlowType cft : this.cfTypes) {
            if (cft == ControlFlowType.Successor) continue;
            if (!firstCFT) {
                toString = String.valueOf(toString) + "|";
            }
            firstCFT = false;
            toString = String.valueOf(toString) + cft.name();
        }
        toString = String.valueOf(toString) + "-> ";
        toString = String.valueOf(toString) + FGUtils.getSourceText((EObject)this.end);
        return toString;
    }
}

