/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.analysers;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.flowgraphs.FGUtils;
import org.eclipse.n4js.flowgraphs.FlowEdge;
import org.eclipse.n4js.flowgraphs.analysis.BranchWalker;
import org.eclipse.n4js.flowgraphs.analysis.BranchWalkerInternal;
import org.eclipse.n4js.flowgraphs.analysis.GraphExplorer;
import org.eclipse.n4js.flowgraphs.analysis.GraphExplorerInternal;
import org.eclipse.n4js.flowgraphs.analysis.GraphVisitor;
import org.eclipse.n4js.flowgraphs.analysis.TraverseDirection;
import org.eclipse.n4js.n4JS.ControlFlowElement;

public class AllBranchPrintVisitor
extends GraphVisitor {
    final ControlFlowElement startElement;

    public AllBranchPrintVisitor() {
        this(null, null, TraverseDirection.Forward);
    }

    public AllBranchPrintVisitor(ControlFlowElement container) {
        this(container, null, TraverseDirection.Forward);
    }

    public AllBranchPrintVisitor(ControlFlowElement container, ControlFlowElement startElement) {
        this(container, startElement, TraverseDirection.Forward);
    }

    public AllBranchPrintVisitor(ControlFlowElement container, ControlFlowElement startElement, TraverseDirection direction) {
        super(container, direction);
        this.startElement = startElement;
    }

    @Override
    protected void initializeContainer(ControlFlowElement curContainer) {
        if (this.startElement == null) {
            super.requestActivation(new AllBranchPrintExplorer());
        }
    }

    @Override
    protected void visit(ControlFlowElement cfe) {
        if (this.startElement != null && this.startElement == cfe && this.getActivatedExplorerCount() == 0) {
            super.requestActivation(new AllBranchPrintExplorer());
        }
    }

    public List<String> getPathStrings() {
        LinkedList<String> pathStrings = new LinkedList<String>();
        for (GraphExplorerInternal gei : this.getActivatedExplorers()) {
            BranchWalkerInternal firstBranch = gei.getFirstBranch();
            AllBranchPrintWalker firstBranchPW = (AllBranchPrintWalker)firstBranch;
            List<String> explPathStrings = AllBranchPrintVisitor.getPathStrings(firstBranchPW, firstBranch.isDeadCodeBranch());
            pathStrings.addAll(explPathStrings);
        }
        return pathStrings;
    }

    public List<String> getBranchStrings() {
        LinkedList<String> pathStrings = new LinkedList<String>();
        for (GraphExplorerInternal gei : this.getActivatedExplorers()) {
            for (BranchWalkerInternal ap : gei.getAllBranches()) {
                AllBranchPrintWalker printPath = (AllBranchPrintWalker)ap;
                pathStrings.add(printPath.getCompleteBranchString());
            }
        }
        return pathStrings;
    }

    private static List<String> getPathStrings(AllBranchPrintWalker bw, boolean isDead) {
        LinkedList<String> allStrings = new LinkedList<String>();
        boolean visitedSuccessor = false;
        for (BranchWalker succ : bw.getSuccessors()) {
            if (isDead != succ.isDeadCodeBranch()) continue;
            visitedSuccessor = true;
            List<String> succStrings = AllBranchPrintVisitor.getPathStrings((AllBranchPrintWalker)succ, isDead);
            for (String succString : succStrings) {
                if (!(bw.pathString.isEmpty() || succString.isEmpty() || succString.startsWith(" -> "))) {
                    succString = " -> " + succString;
                }
                String prefixedString = String.valueOf(bw.pathString) + succString;
                allStrings.add(prefixedString);
            }
        }
        if (!visitedSuccessor) {
            allStrings.add(bw.pathString);
        }
        return allStrings;
    }

    static class AllBranchPrintExplorer
    extends GraphExplorer {
        AllBranchPrintExplorer() {
            super(GraphExplorerInternal.Quantor.ForAllBranches);
        }

        @Override
        protected AllBranchPrintWalker firstBranchWalker() {
            return new AllBranchPrintWalker();
        }

        @Override
        protected BranchWalker joinBranches(List<BranchWalker> branchWalkers) {
            return new AllBranchPrintWalker();
        }
    }

    static class AllBranchPrintWalker
    extends BranchWalker {
        private String branchString = "";
        private String pathString = "";

        AllBranchPrintWalker() {
        }

        @Override
        protected void visit(ControlFlowElement cfe) {
            if (!this.pathString.isEmpty()) {
                this.pathString = String.valueOf(this.pathString) + " -> ";
            }
            this.pathString = String.valueOf(this.pathString) + FGUtils.getSourceText((EObject)cfe);
            this.branchString = String.valueOf(this.branchString) + FGUtils.getSourceText((EObject)cfe);
        }

        @Override
        protected void visit(FlowEdge edge) {
            boolean considerEdge = true;
            considerEdge &= edge.start != this.getContainer();
            if (considerEdge &= edge.end != this.getContainer()) {
                this.branchString = String.valueOf(this.branchString) + " -> ";
            }
        }

        @Override
        protected AllBranchPrintWalker forkPath() {
            return new AllBranchPrintWalker();
        }

        String getCompleteBranchString() {
            String cbs = "";
            cbs = String.valueOf(cbs) + this.getBranchLetter(this) + this.getNumber() + ": ";
            cbs = String.valueOf(cbs) + this.getBranchNames(this.getPredecessors());
            cbs = String.valueOf(cbs) + this.branchString;
            cbs = String.valueOf(cbs) + this.getBranchNames(this.getSuccessors());
            return cbs;
        }

        private String getBranchNames(List<BranchWalker> walkers) {
            String cbs = "";
            if (!walkers.isEmpty()) {
                cbs = String.valueOf(cbs) + "[";
                Collections.sort(walkers, AllBranchPrintWalker::compareBranches);
                boolean addedBW = false;
                for (BranchWalker bw : walkers) {
                    cbs = String.valueOf(cbs) + this.getBranchLetter(bw) + bw.getNumber() + "|";
                    addedBW = true;
                }
                if (!addedBW) {
                    return "";
                }
                cbs = String.valueOf(cbs.substring(0, cbs.length() - 1)) + "]";
            }
            return cbs;
        }

        private String getBranchLetter(BranchWalker bw) {
            return bw.isDeadCodeBranch() ? "b" : "B";
        }

        static int compareBranches(BranchWalkerInternal b1, BranchWalkerInternal b2) {
            return b1.getNumber() - b2.getNumber();
        }

        @Override
        public String toString() {
            return this.branchString;
        }
    }
}

