/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.analysis;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.n4js.flowgraphs.ControlFlowType;
import org.eclipse.n4js.flowgraphs.analysis.NextEdgesProvider;
import org.eclipse.n4js.flowgraphs.model.ControlFlowEdge;
import org.eclipse.n4js.flowgraphs.model.JumpToken;
import org.eclipse.n4js.flowgraphs.model.Node;
import org.eclipse.n4js.utils.collections.Collections2;

public class FinallyFlowContext {
    final Set<JumpToken> finallyBlockContexts = new HashSet<JumpToken>();

    FinallyFlowContext(ControlFlowEdge edge) {
        this(null, edge);
    }

    FinallyFlowContext(FinallyFlowContext flowContext) {
        this(flowContext, null);
    }

    FinallyFlowContext(FinallyFlowContext flowContext, ControlFlowEdge edge) {
        this.follow(flowContext);
        if (edge.finallyPathContext != null) {
            this.finallyBlockContexts.add(edge.finallyPathContext);
        }
    }

    void follow(FinallyFlowContext flowContext) {
        this.joinWith(flowContext);
    }

    void update(NextEdgesProvider edgeProvider, ControlFlowEdge edge) {
        boolean added;
        if (edge.finallyPathContext != null && !(added = this.finallyBlockContexts.add(edge.finallyPathContext))) {
            Node nextNode = edgeProvider.getNextNode(edge);
            if (nextNode.jumpToken.contains(edge.finallyPathContext)) {
                this.finallyBlockContexts.remove(edge.finallyPathContext);
            }
        }
    }

    void joinWith(FinallyFlowContext flowContext) {
        if (flowContext != null) {
            this.finallyBlockContexts.addAll(flowContext.finallyBlockContexts);
        }
    }

    List<ControlFlowEdge> filterEdges(List<ControlFlowEdge> nextEdges) {
        List<ControlFlowEdge> finallyBlockContextEdges = this.findFinallyBlockContextEdge(nextEdges);
        if (!finallyBlockContextEdges.isEmpty()) {
            return finallyBlockContextEdges;
        }
        return nextEdges;
    }

    private List<ControlFlowEdge> findFinallyBlockContextEdge(List<ControlFlowEdge> nextEdges) {
        LinkedList<ControlFlowEdge> fbContextFreeEdges = new LinkedList<ControlFlowEdge>();
        HashMap<JumpToken, ControlFlowEdge> contextEdges = new HashMap<JumpToken, ControlFlowEdge>();
        this.mapFinallyBlockContextEdges(nextEdges, fbContextFreeEdges, contextEdges);
        if (contextEdges.isEmpty()) {
            return Lists.newLinkedList();
        }
        ControlFlowEdge matchedFBContextEdge = null;
        Map.Entry otherEdgePair = null;
        for (Map.Entry ctxEdgePair : contextEdges.entrySet()) {
            JumpToken fbContext = (JumpToken)ctxEdgePair.getKey();
            otherEdgePair = ctxEdgePair;
            if (!this.finallyBlockContexts.contains(fbContext)) continue;
            matchedFBContextEdge = (ControlFlowEdge)ctxEdgePair.getValue();
        }
        if (matchedFBContextEdge != null) {
            return Collections2.newLinkedList((Object[])new ControlFlowEdge[]{matchedFBContextEdge});
        }
        if (!fbContextFreeEdges.isEmpty()) {
            return fbContextFreeEdges;
        }
        if (otherEdgePair != null) {
            LinkedList<ControlFlowEdge> contextAndDeadEdges = new LinkedList<ControlFlowEdge>();
            contextAndDeadEdges.add((ControlFlowEdge)otherEdgePair.getValue());
            for (ControlFlowEdge edge : nextEdges) {
                if (edge.cfType != ControlFlowType.DeadCode) continue;
                contextAndDeadEdges.add(edge);
            }
            return contextAndDeadEdges;
        }
        return null;
    }

    private void mapFinallyBlockContextEdges(List<ControlFlowEdge> nextEdges, List<ControlFlowEdge> fbContextFreeEdges, Map<JumpToken, ControlFlowEdge> contextEdges) {
        for (ControlFlowEdge nE : nextEdges) {
            if (!nE.cfType.isInOrEmpty(ControlFlowType.NonDeadTypes)) continue;
            JumpToken finallyPathContext = nE.finallyPathContext;
            if (finallyPathContext != null) {
                contextEdges.put(finallyPathContext, nE);
                continue;
            }
            fbContextFreeEdges.add(nE);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FinallyFlowContext)) {
            return false;
        }
        FinallyFlowContext ffc = (FinallyFlowContext)obj;
        return this.finallyBlockContexts.equals(ffc.finallyBlockContexts);
    }

    public int hashCode() {
        int hashCode = 0;
        for (JumpToken o : this.finallyBlockContexts) {
            hashCode += ((Object)o).hashCode();
        }
        return hashCode;
    }

    public String toString() {
        return this.finallyBlockContexts.isEmpty() ? "empty" : this.finallyBlockContexts.toString();
    }
}

