/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.analysis;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.n4js.flowgraphs.ControlFlowType;
import org.eclipse.n4js.flowgraphs.FGUtils;
import org.eclipse.n4js.flowgraphs.analysis.NextEdgesProvider;
import org.eclipse.n4js.flowgraphs.model.ComplexNode;
import org.eclipse.n4js.flowgraphs.model.ControlFlowEdge;
import org.eclipse.n4js.flowgraphs.model.FlowGraph;
import org.eclipse.n4js.flowgraphs.model.Node;
import org.eclipse.n4js.flowgraphs.model.RepresentingNode;
import org.eclipse.n4js.n4JS.ControlFlowElement;

public class SuccessorPredecessorAnalysis {
    final FlowGraph cfg;

    public SuccessorPredecessorAnalysis(FlowGraph cfg) {
        this.cfg = cfg;
    }

    public Set<ControlFlowElement> getPredecessors(ControlFlowElement cfe) {
        NextEdgesProvider.Backward nextEdgesProvider = new NextEdgesProvider.Backward();
        Node nextNode = this.getNextNode(cfe, false, nextEdgesProvider);
        Set<ControlFlowElement> predecessors = this.getNextCFEs(nextEdgesProvider, cfe, nextNode);
        return predecessors;
    }

    public Set<ControlFlowElement> getPredecessorsSkipInternal(ControlFlowElement cfe) {
        NextEdgesProvider.Backward nextEdgesProvider = new NextEdgesProvider.Backward();
        Node nextNode = this.getNextNode(cfe, true, nextEdgesProvider);
        Set<ControlFlowElement> predecessors = this.getNextCFEs(nextEdgesProvider, cfe, nextNode);
        return predecessors;
    }

    public Set<ControlFlowElement> getSuccessors(ControlFlowElement cfe) {
        NextEdgesProvider.Forward nextEdgesProvider = new NextEdgesProvider.Forward();
        Node nextNode = this.getNextNode(cfe, false, nextEdgesProvider);
        Set<ControlFlowElement> successors = this.getNextCFEs(nextEdgesProvider, cfe, nextNode);
        return successors;
    }

    public Set<ControlFlowElement> getSuccessorsSkipInternal(ControlFlowElement cfe) {
        NextEdgesProvider.Forward nextEdgesProvider = new NextEdgesProvider.Forward();
        Node nextNode = this.getNextNode(cfe, true, nextEdgesProvider);
        Set<ControlFlowElement> successors = this.getNextCFEs(nextEdgesProvider, cfe, nextNode);
        return successors;
    }

    private Node getNextNode(ControlFlowElement cfe, boolean skipInternal, NextEdgesProvider nextEdgesProvider) {
        ComplexNode cn = this.cfg.getComplexNode(cfe);
        if (skipInternal && FGUtils.isControlStatement(cfe)) {
            return nextEdgesProvider.getEndNode(cn);
        }
        if (cn.hasRepresentingNode()) {
            return cn.getRepresent();
        }
        return nextEdgesProvider.getStartNode(cn);
    }

    private Set<ControlFlowElement> getNextCFEs(NextEdgesProvider nextEdgesProvider, ControlFlowElement cfe, Node nextNode) {
        Objects.requireNonNull(cfe);
        HashSet<ControlFlowElement> nexts = new HashSet<ControlFlowElement>();
        LinkedList<ControlFlowEdge> allEdges = new LinkedList<ControlFlowEdge>();
        List<ControlFlowEdge> nextEdges = nextEdgesProvider.getNextEdges(nextNode, ControlFlowType.NonDeadTypes);
        allEdges.addAll(nextEdges);
        while (!allEdges.isEmpty()) {
            ControlFlowEdge nextEdge = (ControlFlowEdge)allEdges.removeFirst();
            nextNode = nextEdgesProvider.getNextNode(nextEdge);
            if (nextNode instanceof RepresentingNode) {
                ControlFlowElement succ = nextNode.getRepresentedControlFlowElement();
                nexts.add(succ);
                continue;
            }
            nextEdges = nextEdgesProvider.getNextEdges(nextNode, ControlFlowType.NonDeadTypes);
            allEdges.addAll(nextEdges);
        }
        return nexts;
    }

    public boolean isSuccessor(ControlFlowElement cfe1, ControlFlowElement cfe2) {
        Set<ControlFlowElement> succs = this.getSuccessors(cfe1);
        return succs.contains(cfe2);
    }

    public boolean isPredecessor(ControlFlowElement cfe1, ControlFlowElement cfe2) {
        Set<ControlFlowElement> preds = this.getPredecessors(cfe1);
        return preds.contains(cfe2);
    }
}

