/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.factories;

import java.util.LinkedList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.n4js.flowgraphs.ControlFlowType;
import org.eclipse.n4js.flowgraphs.factories.DelegatingNodeFactory;
import org.eclipse.n4js.flowgraphs.factories.ReentrantASTIterator;
import org.eclipse.n4js.flowgraphs.model.CatchToken;
import org.eclipse.n4js.flowgraphs.model.ComplexNode;
import org.eclipse.n4js.flowgraphs.model.DelegatingNode;
import org.eclipse.n4js.flowgraphs.model.HelperNode;
import org.eclipse.n4js.flowgraphs.model.Node;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.ExportDeclaration;
import org.eclipse.n4js.n4JS.ExportableElement;
import org.eclipse.n4js.n4JS.ExportedVariableStatement;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.ScriptElement;
import org.eclipse.n4js.n4JS.Statement;

class ScriptFactory {
    ScriptFactory() {
    }

    static ComplexNode buildComplexNode(ReentrantASTIterator astpp, Script script) {
        ComplexNode cNode = new ComplexNode(astpp.container(), (ControlFlowElement)script);
        HelperNode entryNode = new HelperNode("entry", astpp.pos(), (ControlFlowElement)script);
        LinkedList<DelegatingNode> scriptNodes = new LinkedList<DelegatingNode>();
        EList scriptElems = script.getScriptElements();
        int n = 0;
        while (n < scriptElems.size()) {
            ScriptElement scriptElement = ScriptFactory.getScriptElementAt(script, n);
            if (ScriptFactory.isControlFlowStatement(scriptElement)) {
                DelegatingNode blockNode = DelegatingNodeFactory.create(astpp, "stmt_" + n, (ControlFlowElement)script, (ControlFlowElement)((Statement)scriptElement));
                scriptNodes.add(blockNode);
            }
            ++n;
        }
        HelperNode exitNode = new HelperNode("exit", astpp.pos(), (ControlFlowElement)script);
        cNode.addNode(entryNode);
        for (Node node : scriptNodes) {
            cNode.addNode(node);
        }
        cNode.addNode(exitNode);
        LinkedList<Node> linkedList = new LinkedList<Node>();
        linkedList.add(entryNode);
        linkedList.addAll(scriptNodes);
        linkedList.add(exitNode);
        cNode.connectInternalSucc(linkedList);
        cNode.setEntryNode(entryNode);
        cNode.setExitNode(exitNode);
        exitNode.addCatchToken(new CatchToken(ControlFlowType.CatchesAll));
        return cNode;
    }

    private static ScriptElement getScriptElementAt(Script script, int i) {
        ExportableElement expElem;
        EList scriptElems = script.getScriptElements();
        ScriptElement scriptElement = (ScriptElement)scriptElems.get(i);
        if (scriptElement instanceof ExportDeclaration && (expElem = ((ExportDeclaration)scriptElement).getExportedElement()) instanceof ExportedVariableStatement) {
            scriptElement = (ExportedVariableStatement)expElem;
        }
        return scriptElement;
    }

    private static boolean isControlFlowStatement(ScriptElement scriptElem) {
        boolean isControlFlowStatement = scriptElem instanceof Statement;
        return isControlFlowStatement &= !(scriptElem instanceof FunctionDeclaration);
    }
}

