/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.imports;

import com.google.common.collect.Iterables;
import java.util.HashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.n4JS.ImportSpecifier;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.scoping.UsageAwareObjectDescription;
import org.eclipse.n4js.scoping.imports.AmbiguousImportDescription;
import org.eclipse.n4js.scoping.imports.PlainAccessOfAliasedImportDescription;
import org.eclipse.n4js.xtext.scoping.IEObjectDescriptionWithError;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;

public class OriginAwareScope
implements IScope {
    private final IScope delegatee;
    private final HashMap<IEObjectDescription, ImportSpecifier> origins;

    OriginAwareScope(IScope scope, HashMap<IEObjectDescription, ImportSpecifier> map) {
        this.delegatee = scope;
        this.origins = map;
    }

    public IEObjectDescription getSingleElement(QualifiedName name) {
        EObject script;
        IEObjectDescription ret = this.delegatee.getSingleElement(name);
        if (ret == null) {
            return null;
        }
        ImportSpecifier origin = this.origins.get(ret);
        if (!(origin == null || (script = EcoreUtil.getRootContainer((EObject)origin)) instanceof Script && ((Script)script).isFlaggedUsageMarkingFinished())) {
            return this.getUsageAwareDescription(ret);
        }
        return ret;
    }

    public Iterable<IEObjectDescription> getElements(QualifiedName name) {
        return Iterables.transform((Iterable)this.delegatee.getElements(name), this::getUsageAwareDescription);
    }

    public IEObjectDescription getSingleElement(EObject object) {
        return this.delegatee.getSingleElement(object);
    }

    public Iterable<IEObjectDescription> getElements(EObject object) {
        return this.delegatee.getElements(object);
    }

    public Iterable<IEObjectDescription> getAllElements() {
        return this.delegatee.getAllElements();
    }

    private IEObjectDescription getUsageAwareDescription(IEObjectDescription original) {
        EObject script;
        ImportSpecifier origin = this.origins.get(original);
        if (!(origin == null || (script = EcoreUtil.getRootContainer((EObject)origin)) instanceof Script && ((Script)script).isFlaggedUsageMarkingFinished())) {
            if (original instanceof AmbiguousImportDescription) {
                AmbiguousImportDescription ambiguousImportDescription = (AmbiguousImportDescription)original;
                return new UsageAwareAmbiguousImportDescription(ambiguousImportDescription);
            }
            if (original instanceof PlainAccessOfAliasedImportDescription) {
                PlainAccessOfAliasedImportDescription plainAccess = (PlainAccessOfAliasedImportDescription)original;
                return new UsageAwarePlainAccessOfAliasedImportDescription(plainAccess);
            }
            if (IEObjectDescriptionWithError.isErrorDescription((IEObjectDescription)original)) {
                return new UsageAwareImportDescriptionWithError(this, (IEObjectDescriptionWithError)original);
            }
            return new UsageAwareImportDescription(this, original);
        }
        return original;
    }

    private void markImportSpecifierAsUsed(ImportSpecifier origin) {
        boolean wasDeliver = origin.eDeliver();
        try {
            origin.eSetDeliver(false);
            origin.setFlaggedUsedInCode(true);
        }
        finally {
            origin.eSetDeliver(wasDeliver);
        }
    }

    public String toString() {
        return "OriginAwareScope -> " + this.delegatee.toString();
    }

    private class UsageAwareAmbiguousImportDescription
    extends UsageAwareImportDescriptionWithError<AmbiguousImportDescription> {
        public UsageAwareAmbiguousImportDescription(AmbiguousImportDescription delegate) {
            super(OriginAwareScope.this, (IEObjectDescriptionWithError)delegate);
        }

        @Override
        public void markAsUsed() {
            super.markAsUsed();
            for (ImportSpecifier ispec : ((AmbiguousImportDescription)((Object)this.getDelegate())).getOriginatingImports()) {
                OriginAwareScope.this.markImportSpecifierAsUsed(ispec);
            }
        }
    }

    private static class UsageAwareImportDescription<T extends IEObjectDescription>
    extends UsageAwareObjectDescription<T> {
        final /* synthetic */ OriginAwareScope this$0;

        public UsageAwareImportDescription(T delegate) {
            this.this$0 = var1_1;
            super(delegate);
        }

        @Override
        public void markAsUsed() {
            this.this$0.markImportSpecifierAsUsed(this.this$0.origins.get(this.getDelegate()));
        }

        public String toString() {
            return this.getDelegate().toString();
        }
    }

    private static class UsageAwareImportDescriptionWithError<T extends IEObjectDescriptionWithError>
    extends UsageAwareImportDescription<T>
    implements IEObjectDescriptionWithError {
        final /* synthetic */ OriginAwareScope this$0;

        public UsageAwareImportDescriptionWithError(T delegate) {
            this.this$0 = var1_1;
            super((OriginAwareScope)var1_1, delegate);
        }

        public String getMessage() {
            return ((IEObjectDescriptionWithError)this.getDelegate()).getMessage();
        }

        public String getIssueCode() {
            return ((IEObjectDescriptionWithError)this.getDelegate()).getIssueCode();
        }
    }

    private class UsageAwarePlainAccessOfAliasedImportDescription
    extends UsageAwareImportDescriptionWithError<PlainAccessOfAliasedImportDescription> {
        public UsageAwarePlainAccessOfAliasedImportDescription(PlainAccessOfAliasedImportDescription delegate) {
            super(OriginAwareScope.this, (IEObjectDescriptionWithError)delegate);
        }

        @Override
        public void markAsUsed() {
            super.markAsUsed();
            ImportSpecifier plainImport = OriginAwareScope.this.origins.get(((PlainAccessOfAliasedImportDescription)((Object)this.getDelegate())).delegate());
            if (plainImport != null) {
                OriginAwareScope.this.markImportSpecifierAsUsed(plainImport);
            }
        }
    }
}

