/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.n4idl.versioning;

import java.util.stream.StreamSupport;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.VersionedElement;
import org.eclipse.n4js.n4idl.N4IDLGlobals;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInTypeScope;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.xtext.EcoreUtil2;

public class VersionUtils {
    public static boolean isVersioned(EObject element) {
        return element instanceof VersionedElement && ((VersionedElement)element).getDeclaredVersion() != null && ((VersionedElement)element).getDeclaredVersion().intValue() != 0;
    }

    public static boolean isVersionAwareContext(EObject context) {
        if (context instanceof AnnotableElement && VersionUtils.hasVersionAwarenessAnnotation((AnnotableElement)context)) {
            return true;
        }
        if (context instanceof TAnnotableElement && VersionUtils.hasVersionAwarenessAnnotation((TAnnotableElement)context)) {
            return true;
        }
        if (context instanceof ImportDeclaration) {
            return true;
        }
        if (context == BuiltInTypeScope.get((ResourceSet)context.eResource().getResourceSet()).getMigrationContextType()) {
            return true;
        }
        return StreamSupport.stream(EcoreUtil2.getAllContainers((EObject)context).spliterator(), false).filter(AnnotableElement.class::isInstance).map(e -> (AnnotableElement)e).findAny().map(VersionUtils::isVersionAwareContext).orElse(false);
    }

    public static boolean hasVersionAwarenessAnnotation(AnnotableElement element) {
        return N4IDLGlobals.VERSION_AWARENESS_ANNOTATIONS.stream().anyMatch(anno -> anno.hasAnnotation(element));
    }

    public static boolean hasVersionAwarenessAnnotation(TAnnotableElement element) {
        return N4IDLGlobals.VERSION_AWARENESS_ANNOTATIONS.stream().anyMatch(anno -> anno.hasAnnotation(element));
    }

    private VersionUtils() {
    }
}

