/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesbuilder;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.N4EnumDeclaration;
import org.eclipse.n4js.n4JS.N4EnumLiteral;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.VersionedElement;
import org.eclipse.n4js.ts.types.AccessibleTypeElement;
import org.eclipse.n4js.ts.types.DeclaredTypeWithAccessModifier;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TEnum;
import org.eclipse.n4js.ts.types.TEnumLiteral;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.TVersionable;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypesFactory;
import org.eclipse.n4js.typesbuilder.N4JSTypesBuilderHelper;
import org.eclipse.n4js.typesbuilder.VersionedTypesBuilderUtil;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class N4JSEnumDeclarationTypesBuilder {
    @Inject
    @Extension
    private N4JSTypesBuilderHelper _n4JSTypesBuilderHelper;

    boolean relinkTEnum(N4EnumDeclaration n4Enum, TModule target, boolean preLinkingPhase, int idx) {
        boolean _tripleEquals;
        String _name = n4Enum.getName();
        boolean bl = _tripleEquals = _name == null;
        if (_tripleEquals) {
            return false;
        }
        Type _get = (Type)target.getTopLevelTypes().get(idx);
        TEnum enumType = (TEnum)_get;
        this._n4JSTypesBuilderHelper.ensureEqualName((NamedElement)n4Enum, (IdentifiableElement)enumType);
        this.relinkTEnumLiterals(n4Enum, enumType, preLinkingPhase);
        enumType.setAstElement((EObject)n4Enum);
        n4Enum.setDefinedType((Type)enumType);
        return true;
    }

    private int relinkTEnumLiterals(N4EnumDeclaration n4Enum, TEnum tEnum, boolean preLinkingPhase) {
        Functions.Function2 _function = (idx, n4EnumLit) -> {
            boolean _relinkTEnumLiteral = this.relinkTEnumLiteral((N4EnumLiteral)n4EnumLit, tEnum, preLinkingPhase, (int)idx);
            if (_relinkTEnumLiteral) {
                return idx + 1;
            }
            return idx;
        };
        return (Integer)IterableExtensions.fold((Iterable)n4Enum.getLiterals(), (Object)0, (Functions.Function2)_function);
    }

    private boolean relinkTEnumLiteral(N4EnumLiteral n4EnumLit, TEnum tEnum, boolean preLinkingPhase, int idx) {
        TEnumLiteral tEnumLit = (TEnumLiteral)tEnum.getLiterals().get(idx);
        this._n4JSTypesBuilderHelper.ensureEqualName((NamedElement)n4EnumLit, (IdentifiableElement)tEnumLit);
        tEnumLit.setAstElement((EObject)n4EnumLit);
        n4EnumLit.setDefinedLiteral(tEnumLit);
        return true;
    }

    protected TEnum createTEnum(N4EnumDeclaration n4Enum, TModule target, boolean preLinkingPhase) {
        boolean _tripleEquals;
        String _name = n4Enum.getName();
        boolean bl = _tripleEquals = _name == null;
        if (_tripleEquals) {
            return null;
        }
        TEnum enumType = this.createTEnum(n4Enum);
        this._n4JSTypesBuilderHelper.setTypeAccessModifier((AccessibleTypeElement)enumType, n4Enum);
        this._n4JSTypesBuilderHelper.setProvidedByRuntime((DeclaredTypeWithAccessModifier)enumType, (AnnotableElement)n4Enum, preLinkingPhase);
        this.addLiterals(enumType, n4Enum, preLinkingPhase);
        this._n4JSTypesBuilderHelper.copyAnnotations((TAnnotableElement)enumType, (AnnotableElement)n4Enum, preLinkingPhase);
        enumType.setAstElement((EObject)n4Enum);
        n4Enum.setDefinedType((Type)enumType);
        EList _topLevelTypes = target.getTopLevelTypes();
        _topLevelTypes.add((Object)enumType);
        VersionedTypesBuilderUtil.setTypeVersion((TVersionable)enumType, (VersionedElement)n4Enum);
        return enumType;
    }

    private TEnum createTEnum(N4EnumDeclaration n4Enum) {
        TEnum _xblockexpression = null;
        TEnum enumType = TypesFactory.eINSTANCE.createTEnum();
        enumType.setName(n4Enum.getName());
        enumType.setExportedName(n4Enum.getExportedName());
        enumType.setExternal(n4Enum.isExternal());
        _xblockexpression = enumType;
        return _xblockexpression;
    }

    private void addLiterals(TEnum enumType, N4EnumDeclaration n4Enum, boolean preLinkingPhase) {
        Functions.Function1 _function = it -> this.createEnumLiteral((N4EnumLiteral)it, preLinkingPhase);
        Iterables.addAll((Collection)enumType.getLiterals(), (Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)n4Enum.getLiterals(), N4EnumLiteral.class), (Functions.Function1)_function));
    }

    private TEnumLiteral createEnumLiteral(N4EnumLiteral it, boolean preLinkingPhase) {
        TEnumLiteral _xblockexpression = null;
        TEnumLiteral enumLiteral = TypesFactory.eINSTANCE.createTEnumLiteral();
        enumLiteral.setName(it.getName());
        enumLiteral.setValue(it.getValue());
        enumLiteral.setAstElement((EObject)it);
        it.setDefinedLiteral(enumLiteral);
        _xblockexpression = enumLiteral;
        return _xblockexpression;
    }
}

