/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.internal.genericeditor.ExtensionBasedTextViewerConfiguration;
import org.eclipse.ui.internal.genericeditor.GenericEditorPlugin;
import org.eclipse.ui.internal.genericeditor.preferences.GenericEditorPreferenceConstants;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

public class ExtensionBasedTextEditor
extends TextEditor {
    private static final String CONTEXT_ID = "org.eclipse.ui.genericeditor.genericEditorContext";
    private static final String MATCHING_BRACKETS = "matchingBrackets";
    private static final String MATCHING_BRACKETS_COLOR = "matchingBracketsColor";
    private static final String HIGHLIGHT_BRACKET_AT_CARET_LOCATION = "highlightBracketAtCaretLocation";
    private static final String ENCLOSING_BRACKETS = "enclosingBrackets";
    private ExtensionBasedTextViewerConfiguration configuration = new ExtensionBasedTextViewerConfiguration((ITextEditor)this, this.getPreferenceStore());

    public ExtensionBasedTextEditor() {
        this.setSourceViewerConfiguration((SourceViewerConfiguration)this.configuration);
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{CONTEXT_ID});
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        this.configuration.watchDocument(this.getDocumentProvider().getDocument((Object)input));
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.getAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        SourceViewerDecorationSupport support = this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        this.configureCharacterPairMatcher((ISourceViewer)viewer, support);
        return viewer;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors()).install();
        viewer.doOperation(19);
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setPreferenceStore((IPreferenceStore)new ChainedPreferenceStore(new IPreferenceStore[]{GenericEditorPreferenceConstants.getPreferenceStore(), EditorsUI.getPreferenceStore()}));
    }

    private void configureCharacterPairMatcher(ISourceViewer viewer, SourceViewerDecorationSupport support) {
        List<ICharacterPairMatcher> matchers = GenericEditorPlugin.getDefault().getCharacterPairMatcherRegistry().getCharacterPairMatchers(viewer, (ITextEditor)this, this.configuration.getContentTypes(viewer));
        if (!matchers.isEmpty()) {
            ICharacterPairMatcher matcher = matchers.get(0);
            support.setCharacterPairMatcher(matcher);
            support.setMatchingCharacterPainterPreferenceKeys(MATCHING_BRACKETS, MATCHING_BRACKETS_COLOR, HIGHLIGHT_BRACKET_AT_CARET_LOCATION, ENCLOSING_BRACKETS);
        }
    }
}

