/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.refactoring;

import com.google.inject.Inject;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.ImportSpecifier;
import org.eclipse.n4js.n4JS.LiteralOrComputedPropertyName;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.ui.refactoring.ui.DefaultRenameElementHandler;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class N4JSRenameElementHandler
extends DefaultRenameElementHandler {
    @Inject
    private EObjectAtOffsetHelper eObjectAtOffsetHelper;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            final XtextEditor editor = EditorUtils.getActiveXtextEditor((ExecutionEvent)event);
            if (editor != null) {
                this.syncUtil.totalSync(this.preferences.isSaveAllBeforeRefactoring(), this.renameRefactoringController.getActiveLinkedMode() == null);
                final ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
                IRenameElementContext renameElementContext = (IRenameElementContext)editor.getDocument().priorityReadOnly((IUnitOfWork)new IUnitOfWork<IRenameElementContext, XtextResource>(){

                    public IRenameElementContext exec(XtextResource resource) throws Exception {
                        IRenameElementContext renameElementContext;
                        EObject selectedElement = N4JSRenameElementHandler.this.eObjectAtOffsetHelper.resolveElementAt(resource, selection.getOffset());
                        if (selectedElement instanceof LiteralOrComputedPropertyName) {
                            selectedElement = selectedElement.eContainer();
                        }
                        if (!(selectedElement instanceof FormalParameter) && N4JSLanguageUtils.getDefinedTypeModelElement((EObject)selectedElement) != null) {
                            selectedElement = N4JSLanguageUtils.getDefinedTypeModelElement((EObject)selectedElement);
                        }
                        N4JSResource res = (N4JSResource)resource;
                        Script script = (Script)res.getContents().get(0);
                        List importDecls = script.getScriptElements().stream().filter(elem -> elem instanceof ImportDeclaration).map(elem -> (ImportDeclaration)elem).collect(Collectors.toList());
                        for (ImportDeclaration importDecl : importDecls) {
                            for (ImportSpecifier importSpecified : importDecl.getImportSpecifiers()) {
                                NamedImportSpecifier namedImportSpecifier;
                                if (!(importSpecified instanceof NamedImportSpecifier) || (namedImportSpecifier = (NamedImportSpecifier)importSpecified).getAlias() == null || namedImportSpecifier.getImportedElement() != selectedElement) continue;
                                throw new UnsupportedOperationException("Renaming alias is NOT supported at the moment. Sorry.");
                            }
                        }
                        if (selectedElement != null && N4JSRenameElementHandler.this.isRefactoringEnabled(renameElementContext = N4JSRenameElementHandler.this.renameContextFactory.createRenameElementContext(selectedElement, editor, selection, resource), resource)) {
                            return renameElementContext;
                        }
                        return null;
                    }
                });
                if (renameElementContext != null) {
                    this.startRenameElement(renameElementContext);
                }
            }
        }
        catch (OperationCanceledException e) {
            return null;
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (Exception exc) {
            LOG.error((Object)"Error initializing refactoring", (Throwable)exc);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error initializing refactoring", (String)(String.valueOf(exc.getMessage()) + "\nSee log for details"));
        }
        return null;
    }

    protected boolean isRefactoringEnabled(IRenameElementContext renameElementContext, XtextResource resource) {
        if (renameElementContext.getTargetElementURI().scheme().equals("n4scheme")) {
            return false;
        }
        return super.isRefactoringEnabled(renameElementContext, resource);
    }
}

