/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.subscribers;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.internal.core.mapping.AbstractResourceMappingScope;

public class RootResourceSynchronizationScope
extends AbstractResourceMappingScope {
    private IResource[] roots;

    public RootResourceSynchronizationScope(IResource[] roots) {
        this.roots = roots;
    }

    @Override
    public ResourceTraversal[] getTraversals() {
        return new ResourceTraversal[]{new ResourceTraversal(this.roots, 2, 0)};
    }

    public void setRoots(IResource[] roots) {
        this.roots = roots;
        this.fireTraversalsChangedEvent(this.getTraversals(), this.getMappings());
    }

    @Override
    public ResourceMapping[] getInputMappings() {
        return this.getMappings();
    }

    @Override
    public ISynchronizationScope asInputScope() {
        return this;
    }

    @Override
    public ResourceMapping[] getMappings() {
        ArrayList<ResourceMapping> result = new ArrayList<ResourceMapping>();
        int i = 0;
        while (i < this.roots.length) {
            IResource resource = this.roots[i];
            Object o = resource.getAdapter(ResourceMapping.class);
            if (o instanceof ResourceMapping) {
                result.add((ResourceMapping)o);
            }
            ++i;
        }
        return result.toArray(new ResourceMapping[result.size()]);
    }

    @Override
    public ResourceTraversal[] getTraversals(ResourceMapping mapping) {
        Object object = mapping.getModelObject();
        if (object instanceof IResource) {
            IResource resource = (IResource)object;
            return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{resource}, 2, 0)};
        }
        return null;
    }

    @Override
    public boolean hasAdditionalMappings() {
        return false;
    }

    @Override
    public boolean hasAdditonalResources() {
        return false;
    }

    @Override
    public IProject[] getProjects() {
        return ResourcesPlugin.getWorkspace().getRoot().getProjects();
    }

    @Override
    public ResourceMappingContext getContext() {
        return ResourceMappingContext.LOCAL_CONTEXT;
    }

    @Override
    public void refresh(ResourceMapping[] mappings) {
    }
}

