/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.server;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.ide.server.BuildManager;
import org.eclipse.xtext.ide.server.WorkspaceManager;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.ISourceFolder;
import org.eclipse.xtext.workspace.IWorkspaceConfig;
import org.eclipse.xtext.xbase.lib.Procedures;

public class N4JSWorkspaceManager
extends WorkspaceManager {
    private Procedures.Procedure2<? super URI, ? super Iterable<Issue>> issueAcceptor;

    public void initialize(URI baseDir, Procedures.Procedure2<? super URI, ? super Iterable<Issue>> pIssueAcceptor, CancelIndicator cancelIndicator) {
        super.initialize(baseDir, pIssueAcceptor, cancelIndicator);
        this.issueAcceptor = pIssueAcceptor;
    }

    public BuildManager.Buildable didClose(final URI uri) {
        final IProjectConfig projectConfig = this.getWorkspaceConfig().findProjectContaining(uri);
        final BuildManager.Buildable closedBuildable = super.didClose(uri);
        BuildManager.Buildable cleaningBuildable = new BuildManager.Buildable(){

            public List<IResourceDescription.Delta> build(CancelIndicator cancelIndicator) {
                List build = closedBuildable.build(cancelIndicator);
                ISourceFolder sourceFolder = projectConfig.findSourceFolderContaining(uri);
                if (sourceFolder == null) {
                    N4JSWorkspaceManager.this.clearIssues(uri);
                }
                return build;
            }
        };
        return cleaningBuildable;
    }

    public void clearIssues(URI uri) {
        this.issueAcceptor.apply((Object)uri, Collections.emptyList());
    }

    protected IWorkspaceConfig getWorkspaceConfig() {
        return super.getWorkspaceConfig();
    }
}

