/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.compare;

import com.google.common.base.Joiner;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.n4js.compare.ProjectCompareResult;
import org.eclipse.n4js.compare.ProjectComparison;
import org.eclipse.n4js.compare.ProjectComparisonEntry;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TEnum;
import org.eclipse.n4js.ui.compare.ProjectCompareTreeHelper;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class ProjectCompareTree
extends TreeViewer {
    private static final int NUM_OF_IMPLEMENTATION_COLUMNS = 4;
    private static final String[] SPECIAL_COLUMN_TITLES = new String[]{"Status", "Description", "Documentation"};
    private static final int NUM_OF_SPECIAL_COLUMNS = SPECIAL_COLUMN_TITLES.length;
    private static final int NUM_OF_COLUMNS = Math.max(5, 2 + NUM_OF_SPECIAL_COLUMNS);
    protected final Color col_diff_error_fg;
    protected final Color col_diff_conformant_fg;
    protected final Color col_classifier_bg;
    protected final ProjectCompareTreeHelper projectCompareTreeHelper;
    protected ProjectComparison comparison = null;
    protected int focusImplIndex = -1;
    protected Map<ProjectComparisonEntry, String> cachedDocumentation = null;

    public ProjectCompareTree(Composite parent, int style, ProjectCompareTreeHelper projectCompareTreeHelper) {
        super(parent, style);
        this.projectCompareTreeHelper = projectCompareTreeHelper;
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ProjectCompareTree.this.onDispose();
            }
        });
        this.col_diff_error_fg = new Color((Device)parent.getDisplay(), 255, 40, 40);
        this.col_diff_conformant_fg = new Color((Device)parent.getDisplay(), 60, 127, 95);
        this.col_classifier_bg = new Color((Device)parent.getDisplay(), 200, 220, 250);
        Tree tree = this.getTree();
        int n = 0;
        while (n < NUM_OF_COLUMNS) {
            TreeColumn colN = new TreeColumn(tree, 16384);
            if (n == 0) {
                colN.setWidth(300);
            } else {
                colN.setWidth(200);
            }
            ++n;
        }
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.setLabelProvider((IBaseLabelProvider)new MyLabelProvider());
        this.setContentProvider((IContentProvider)new MyContentProvider());
        this.setComparison(null, null, null);
    }

    public void setComparison() {
        ProgressMonitorDialog dlg = new ProgressMonitorDialog(this.getTree().getShell());
        try {
            dlg.run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ProjectCompareTree.this.setComparison(monitor);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    public void setComparison(IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.beginTask("Building comparison for API / implementation projects in workspace ...", -1);
            monitor.worked(1);
        }
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (monitor != null) {
            monitor.subTask("Comparing projects in workspace ...");
            monitor.worked(1);
        }
        ProjectComparison newComparison = this.projectCompareTreeHelper.createComparison(true, errorMessages);
        if (errorMessages.isEmpty()) {
            N4JSProjectName newFocusImplId = newComparison != null && newComparison.getImplCount() == 1 ? newComparison.getImplId(0) : null;
            this.setComparison(newComparison, newFocusImplId, monitor);
        } else {
            this.setComparison(null, null, null);
            MessageDialog.openError((Shell)this.getTree().getShell(), (String)"Setup Invalid", (String)("The API / implementation setup is invalid:\n" + Joiner.on((char)'\n').join(errorMessages)));
        }
        if (monitor != null) {
            monitor.done();
        }
    }

    public void setComparison(ProjectComparison comparison, N4JSProjectName focusImplId, IProgressMonitor monitor) {
        this.comparison = comparison;
        this.focusImplIndex = comparison != null && focusImplId != null ? comparison.getImplIndex(focusImplId) : -1;
        this.cachedDocumentation = null;
        if (comparison != null && focusImplId != null) {
            if (monitor != null) {
                monitor.subTask("Scanning jsdoc ...");
                monitor.worked(1);
            }
            int focusImplIdx = comparison.getImplIndex(focusImplId);
            this.cachedDocumentation = this.projectCompareTreeHelper.readDocumentation(comparison, new int[]{focusImplIdx});
        }
        if (monitor != null) {
            monitor.subTask("Updating UI ...");
            monitor.worked(1);
        }
        this.setInput(comparison);
        this.refreshColumnHeaders();
        this.expandAll();
    }

    protected void refreshColumnHeaders() {
        block5: {
            this.setColumnHeader(0, "API");
            int idx = 1;
            while (idx < NUM_OF_COLUMNS) {
                this.setColumnHeader(idx, "");
                ++idx;
            }
            if (this.comparison == null) break block5;
            if (this.focusImplIndex >= 0) {
                this.setColumnHeader(1, this.comparison.getImplId(this.focusImplIndex).getRawName());
                int specialColumnIdx = 0;
                while (specialColumnIdx < NUM_OF_SPECIAL_COLUMNS) {
                    this.setColumnHeader(2 + specialColumnIdx, SPECIAL_COLUMN_TITLES[specialColumnIdx]);
                    ++specialColumnIdx;
                }
            } else {
                int implColumnIdx = 0;
                while (implColumnIdx < 4) {
                    this.setColumnHeader(1 + implColumnIdx, this.comparison.getImplId(implColumnIdx).getRawName());
                    ++implColumnIdx;
                }
            }
        }
    }

    private void setColumnHeader(int idx, String label) {
        this.getTree().getColumn(idx).setText(label != null ? label : "");
    }

    protected void onDispose() {
        if (this.col_diff_error_fg != null) {
            this.col_diff_error_fg.dispose();
        }
        if (this.col_diff_conformant_fg != null) {
            this.col_diff_conformant_fg.dispose();
        }
        if (this.col_classifier_bg != null) {
            this.col_classifier_bg.dispose();
        }
    }

    private class MyContentProvider
    implements ITreeContentProvider {
        private MyContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((ProjectComparison)inputElement).getEntries();
        }

        public boolean hasChildren(Object element) {
            return ((ProjectComparisonEntry)element).hasChildren();
        }

        public Object[] getChildren(Object parentElement) {
            return ((ProjectComparisonEntry)parentElement).getChildren();
        }

        public Object getParent(Object element) {
            return ((ProjectComparisonEntry)element).getParent();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private class MyLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        private MyLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            ProjectComparisonEntry entry = (ProjectComparisonEntry)element;
            int idx = this.getEntryIndexForColumnIndex(columnIndex);
            if (idx >= -1 && idx < entry.getImplCount()) {
                StringBuffer sb = new StringBuffer();
                sb.append(columnIndex == 0 ? entry.getTextAPI() : entry.getTextImpl(idx));
                if (columnIndex == 0 ? entry.isInherited() : entry.isInherited(idx)) {
                    sb.append(" (inherited)");
                }
                if (columnIndex == 0 ? entry.isOverride() : entry.isOverride(idx)) {
                    sb.append(" (override)");
                }
                return sb.toString();
            }
            if (idx == -2) {
                return this.getSpecialColumnText(entry, columnIndex - 2);
            }
            return null;
        }

        private String getSpecialColumnText(ProjectComparisonEntry entry, int specialColumnIndex) {
            if (ProjectCompareTree.this.focusImplIndex < 0 || ProjectCompareTree.this.focusImplIndex >= entry.getImplCount()) {
                throw new IllegalStateException();
            }
            if (specialColumnIndex == 0) {
                ProjectCompareResult result = ProjectCompareTree.this.projectCompareTreeHelper.compareApiImpl(entry, ProjectCompareTree.this.focusImplIndex);
                switch (result.status) {
                    case EQUAL: {
                        return null;
                    }
                    case COMPLIANT: {
                        return "diff";
                    }
                    case ERROR: {
                        return "*ERROR*";
                    }
                }
            } else {
                if (specialColumnIndex == 1) {
                    ProjectCompareResult result = ProjectCompareTree.this.projectCompareTreeHelper.compareApiImpl(entry, ProjectCompareTree.this.focusImplIndex);
                    return result.description;
                }
                if (specialColumnIndex == 2) {
                    return ProjectCompareTree.this.cachedDocumentation != null ? ProjectCompareTree.this.cachedDocumentation.get(entry) : null;
                }
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            ProjectComparisonEntry entry;
            EObject api;
            if (columnIndex == 0 && (api = (entry = (ProjectComparisonEntry)element).getElementAPI()) != null) {
                return ProjectCompareTree.this.projectCompareTreeHelper.getImage(api);
            }
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return null;
            }
            int idx = this.getEntryIndexForColumnIndex(columnIndex);
            if (idx >= 0) {
                ProjectCompareResult result = ProjectCompareTree.this.projectCompareTreeHelper.compareApiImpl((ProjectComparisonEntry)element, idx);
                switch (result.status) {
                    case EQUAL: {
                        return null;
                    }
                    case COMPLIANT: {
                        return ProjectCompareTree.this.col_diff_conformant_fg;
                    }
                    case ERROR: {
                        return ProjectCompareTree.this.col_diff_error_fg;
                    }
                }
            }
            return null;
        }

        public Color getBackground(Object element, int columnIndex) {
            EObject[] eObjectArray = ((ProjectComparisonEntry)element).getAllElements();
            int n = eObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                EObject currElem = eObjectArray[n2];
                if (currElem instanceof TClassifier || currElem instanceof TEnum) {
                    return ProjectCompareTree.this.col_classifier_bg;
                }
                ++n2;
            }
            return null;
        }

        private int getEntryIndexForColumnIndex(int columnIndex) {
            if (ProjectCompareTree.this.focusImplIndex >= 0) {
                if (columnIndex == 0) {
                    return -1;
                }
                if (columnIndex == 1) {
                    return ProjectCompareTree.this.focusImplIndex;
                }
                return -2;
            }
            return columnIndex - 1;
        }
    }
}

