/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.types.impl;

import com.google.common.base.Objects;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.MemberAccessModifier;
import org.eclipse.n4js.ts.types.MemberType;
import org.eclipse.n4js.ts.types.SyntaxRelatedTElement;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TAnnotation;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.ts.types.impl.IdentifiableElementImpl;

public abstract class TMemberImpl
extends IdentifiableElementImpl
implements TMember {
    protected EList<TAnnotation> annotations;
    protected EObject astElement;
    protected static final boolean DECLARED_FINAL_EDEFAULT = false;
    protected boolean declaredFinal = false;
    protected static final boolean DECLARED_STATIC_EDEFAULT = false;
    protected boolean declaredStatic = false;
    protected static final boolean DECLARED_OVERRIDE_EDEFAULT = false;
    protected boolean declaredOverride = false;
    protected static final boolean HAS_COMPUTED_NAME_EDEFAULT = false;
    protected boolean hasComputedName = false;
    protected EList<TMember> constituentMembers;
    protected static final boolean COMPOSED_EDEFAULT = false;
    protected boolean composed = false;

    protected TMemberImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return TypesPackage.Literals.TMEMBER;
    }

    @Override
    public EList<TAnnotation> getAnnotations() {
        if (this.annotations == null) {
            this.annotations = new EObjectContainmentEList(TAnnotation.class, (InternalEObject)this, 1);
        }
        return this.annotations;
    }

    @Override
    public EObject getAstElement() {
        if (this.astElement != null && this.astElement.eIsProxy()) {
            InternalEObject oldAstElement = (InternalEObject)this.astElement;
            this.astElement = this.eResolveProxy(oldAstElement);
            if (this.astElement != oldAstElement && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 2, (Object)oldAstElement, (Object)this.astElement));
            }
        }
        return this.astElement;
    }

    public EObject basicGetAstElement() {
        return this.astElement;
    }

    @Override
    public void setAstElement(EObject newAstElement) {
        EObject oldAstElement = this.astElement;
        this.astElement = newAstElement;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldAstElement, (Object)this.astElement));
        }
    }

    @Override
    public boolean isDeclaredFinal() {
        return this.declaredFinal;
    }

    @Override
    public void setDeclaredFinal(boolean newDeclaredFinal) {
        boolean oldDeclaredFinal = this.declaredFinal;
        this.declaredFinal = newDeclaredFinal;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, oldDeclaredFinal, this.declaredFinal));
        }
    }

    @Override
    public boolean isDeclaredStatic() {
        return this.declaredStatic;
    }

    @Override
    public void setDeclaredStatic(boolean newDeclaredStatic) {
        boolean oldDeclaredStatic = this.declaredStatic;
        this.declaredStatic = newDeclaredStatic;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, oldDeclaredStatic, this.declaredStatic));
        }
    }

    @Override
    public boolean isDeclaredOverride() {
        return this.declaredOverride;
    }

    @Override
    public void setDeclaredOverride(boolean newDeclaredOverride) {
        boolean oldDeclaredOverride = this.declaredOverride;
        this.declaredOverride = newDeclaredOverride;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, oldDeclaredOverride, this.declaredOverride));
        }
    }

    @Override
    public boolean isHasComputedName() {
        return this.hasComputedName;
    }

    @Override
    public void setHasComputedName(boolean newHasComputedName) {
        boolean oldHasComputedName = this.hasComputedName;
        this.hasComputedName = newHasComputedName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, oldHasComputedName, this.hasComputedName));
        }
    }

    @Override
    public EList<TMember> getConstituentMembers() {
        if (this.constituentMembers == null) {
            this.constituentMembers = new EObjectResolvingEList(TMember.class, (InternalEObject)this, 7);
        }
        return this.constituentMembers;
    }

    @Override
    public boolean isComposed() {
        return this.composed;
    }

    @Override
    public void setComposed(boolean newComposed) {
        boolean oldComposed = this.composed;
        this.composed = newComposed;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, oldComposed, this.composed));
        }
    }

    @Override
    public ContainerType<?> getContainingType() {
        EObject myContainer = this.eContainer();
        ContainerType _xifexpression = null;
        _xifexpression = myContainer instanceof ContainerType ? (ContainerType)myContainer : null;
        return _xifexpression;
    }

    @Override
    public MemberAccessModifier getMemberAccessModifier() {
        throw new UnsupportedOperationException();
    }

    @Override
    public MemberType getMemberType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isField() {
        MemberType _memberType = this.getMemberType();
        return Objects.equal((Object)((Object)_memberType), (Object)((Object)MemberType.FIELD));
    }

    @Override
    public boolean isGetter() {
        MemberType _memberType = this.getMemberType();
        return Objects.equal((Object)((Object)_memberType), (Object)((Object)MemberType.GETTER));
    }

    @Override
    public boolean isSetter() {
        MemberType _memberType = this.getMemberType();
        return Objects.equal((Object)((Object)_memberType), (Object)((Object)MemberType.SETTER));
    }

    @Override
    public boolean isAccessor() {
        return Objects.equal((Object)((Object)this.getMemberType()), (Object)((Object)MemberType.SETTER)) || Objects.equal((Object)((Object)this.getMemberType()), (Object)((Object)MemberType.GETTER));
    }

    @Override
    public boolean isMethod() {
        MemberType _memberType = this.getMemberType();
        return Objects.equal((Object)((Object)_memberType), (Object)((Object)MemberType.METHOD));
    }

    @Override
    public boolean isConstructor() {
        return false;
    }

    @Override
    public boolean isOptional() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    @Override
    public boolean isWriteable() {
        return false;
    }

    @Override
    public String getMemberAsString() {
        return this.getName();
    }

    @Override
    public boolean isFinal() {
        return this.isDeclaredFinal();
    }

    @Override
    public boolean isStatic() {
        return this.isDeclaredStatic();
    }

    @Override
    public boolean isConst() {
        return false;
    }

    @Override
    public boolean isPolyfilled() {
        ContainerType<?> containingType = this.getContainingType();
        if (containingType == null) {
            return false;
        }
        return containingType.isPolyfill() || containingType.isStaticPolyfill();
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getAnnotations()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getAnnotations();
            }
            case 2: {
                if (resolve) {
                    return this.getAstElement();
                }
                return this.basicGetAstElement();
            }
            case 3: {
                return this.isDeclaredFinal();
            }
            case 4: {
                return this.isDeclaredStatic();
            }
            case 5: {
                return this.isDeclaredOverride();
            }
            case 6: {
                return this.isHasComputedName();
            }
            case 7: {
                return this.getConstituentMembers();
            }
            case 8: {
                return this.isComposed();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.getAnnotations().clear();
                this.getAnnotations().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.setAstElement((EObject)newValue);
                return;
            }
            case 3: {
                this.setDeclaredFinal((Boolean)newValue);
                return;
            }
            case 4: {
                this.setDeclaredStatic((Boolean)newValue);
                return;
            }
            case 5: {
                this.setDeclaredOverride((Boolean)newValue);
                return;
            }
            case 6: {
                this.setHasComputedName((Boolean)newValue);
                return;
            }
            case 7: {
                this.getConstituentMembers().clear();
                this.getConstituentMembers().addAll((Collection)newValue);
                return;
            }
            case 8: {
                this.setComposed((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.getAnnotations().clear();
                return;
            }
            case 2: {
                this.setAstElement(null);
                return;
            }
            case 3: {
                this.setDeclaredFinal(false);
                return;
            }
            case 4: {
                this.setDeclaredStatic(false);
                return;
            }
            case 5: {
                this.setDeclaredOverride(false);
                return;
            }
            case 6: {
                this.setHasComputedName(false);
                return;
            }
            case 7: {
                this.getConstituentMembers().clear();
                return;
            }
            case 8: {
                this.setComposed(false);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.annotations != null && !this.annotations.isEmpty();
            }
            case 2: {
                return this.astElement != null;
            }
            case 3: {
                return this.declaredFinal;
            }
            case 4: {
                return this.declaredStatic;
            }
            case 5: {
                return this.declaredOverride;
            }
            case 6: {
                return this.hasComputedName;
            }
            case 7: {
                return this.constituentMembers != null && !this.constituentMembers.isEmpty();
            }
            case 8: {
                return this.composed;
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == TAnnotableElement.class) {
            switch (derivedFeatureID) {
                case 1: {
                    return 0;
                }
            }
            return -1;
        }
        if (baseClass == SyntaxRelatedTElement.class) {
            switch (derivedFeatureID) {
                case 2: {
                    return 0;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == TAnnotableElement.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 1;
                }
            }
            return -1;
        }
        if (baseClass == SyntaxRelatedTElement.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 2;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 1: {
                return this.getContainingType();
            }
            case 2: {
                return this.getMemberAccessModifier();
            }
            case 3: {
                return this.getMemberType();
            }
            case 4: {
                return this.isField();
            }
            case 5: {
                return this.isGetter();
            }
            case 6: {
                return this.isSetter();
            }
            case 7: {
                return this.isAccessor();
            }
            case 8: {
                return this.isMethod();
            }
            case 9: {
                return this.isConstructor();
            }
            case 10: {
                return this.isOptional();
            }
            case 11: {
                return this.isAbstract();
            }
            case 12: {
                return this.isReadable();
            }
            case 13: {
                return this.isWriteable();
            }
            case 14: {
                return this.getMemberAsString();
            }
            case 15: {
                return this.isFinal();
            }
            case 16: {
                return this.isStatic();
            }
            case 17: {
                return this.isConst();
            }
            case 18: {
                return this.isPolyfilled();
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (declaredFinal: ");
        result.append(this.declaredFinal);
        result.append(", declaredStatic: ");
        result.append(this.declaredStatic);
        result.append(", declaredOverride: ");
        result.append(this.declaredOverride);
        result.append(", hasComputedName: ");
        result.append(this.hasComputedName);
        result.append(", composed: ");
        result.append(this.composed);
        result.append(')');
        return result.toString();
    }
}

