/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.building;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.internal.events.BuildManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;

public class BuildManagerAccess {
    private static final Method requestRebuild;
    private static final Field autoBuildJob;
    private static final Method forceBuild;

    static {
        try {
            requestRebuild = BuildManager.class.getDeclaredMethod("requestRebuild", new Class[0]);
            requestRebuild.setAccessible(true);
            autoBuildJob = BuildManager.class.getDeclaredField("autoBuildJob");
            autoBuildJob.setAccessible(true);
            Class<?> autoBuildJobClass = autoBuildJob.getType();
            forceBuild = autoBuildJobClass.getDeclaredMethod("forceBuild", new Class[0]);
            forceBuild.setAccessible(true);
        }
        catch (NoSuchFieldException | NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static void needBuild() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace instanceof Workspace) {
            BuildManager buildManager = ((Workspace)workspace).getBuildManager();
            try {
                requestRebuild.invoke((Object)buildManager, new Object[0]);
                Object job = autoBuildJob.get(buildManager);
                forceBuild.invoke(job, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new RuntimeException("Unexpected workspace implementation");
        }
    }
}

