/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.SSECoreMessages;
import org.eclipse.wst.sse.core.internal.encoding.EncodingRule;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.IModelHandler;
import org.eclipse.wst.sse.core.internal.model.FactoryRegistry;
import org.eclipse.wst.sse.core.internal.model.LifecycleNotificationManager;
import org.eclipse.wst.sse.core.internal.model.ModelLifecycleEvent;
import org.eclipse.wst.sse.core.internal.model.ModelManagerImpl;
import org.eclipse.wst.sse.core.internal.provisional.DocumentChanged;
import org.eclipse.wst.sse.core.internal.provisional.IModelLifecycleListener;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.events.AboutToBeChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.IModelAboutToBeChangedListener;
import org.eclipse.wst.sse.core.internal.provisional.events.IStructuredDocumentListener;
import org.eclipse.wst.sse.core.internal.provisional.events.NewDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.NoChangeEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentRegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceInUse;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.undo.IStructuredTextUndoManager;
import org.eclipse.wst.sse.core.internal.util.URIResolver;
import org.eclipse.wst.sse.core.internal.util.Utilities;

public abstract class AbstractStructuredModel
implements IStructuredModel {
    private static final String MODEL_MANAGER_NULL = "Warning: AbstractStructuredModel::close:  model manager was null during a close of a model (which should be impossible)";
    private FactoryRegistry factoryRegistry;
    private String fBaseLocation;
    boolean fDirtyState;
    DirtyStateWatcher fDirtyStateWatcher;
    DocumentToModelNotifier fDocumentToModelNotifier;
    private String fExplicitContentTypeIdentifier;
    private String fId;
    private LifecycleNotificationManager fLifecycleNotificationManager;
    private final Object fListenerLock = new byte[0];
    protected ILock fLockObject;
    private IModelHandler fModelHandler;
    private IModelManager fModelManager;
    private int fModelStateChanging;
    private Object[] fModelStateListeners;
    private boolean fNewState = false;
    private URIResolver fResolver;
    protected IStructuredDocument fStructuredDocument;
    public long fSynchronizationStamp = -1L;
    private boolean reinitializationNeeded;
    private Object reinitializeStateData;
    private final Object STATE_LOCK = new Object();

    public AbstractStructuredModel() {
        this.fDirtyStateWatcher = new DirtyStateWatcher();
        this.fDocumentToModelNotifier = new DocumentToModelNotifier();
    }

    private ModelManagerImpl _getModelManager() {
        if (this.fModelManager == null) {
            this.fModelManager = StructuredModelManager.getModelManager();
        }
        return (ModelManagerImpl)this.fModelManager;
    }

    @Override
    public void aboutToChangeModel() {
        this.internalAboutToBeChanged();
    }

    public void aboutToReinitializeModel() {
        this.fireModelAboutToBeReinitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addModelLifecycleListener(IModelLifecycleListener listener) {
        Object object = this.fListenerLock;
        synchronized (object) {
            if (this.fLifecycleNotificationManager == null) {
                this.fLifecycleNotificationManager = new LifecycleNotificationManager();
            }
            this.fLifecycleNotificationManager.addListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addModelStateListener(IModelStateListener listener) {
        Object object = this.fListenerLock;
        synchronized (object) {
            if (!Utilities.contains(this.fModelStateListeners, listener)) {
                int oldSize = 0;
                if (this.fModelStateListeners != null) {
                    oldSize = this.fModelStateListeners.length;
                }
                int newSize = oldSize + 1;
                Object[] newListeners = new Object[newSize];
                if (this.fModelStateListeners != null) {
                    System.arraycopy(this.fModelStateListeners, 0, newListeners, 0, oldSize);
                }
                newListeners[newSize - 1] = listener;
                this.fModelStateListeners = newListeners;
            }
        }
    }

    protected final void beginLock() {
    }

    @Override
    public void beginRecording(Object requester) {
        this.beginRecording(requester, null, null);
    }

    @Override
    public void beginRecording(Object requester, int cursorPosition, int selectionLength) {
        this.beginRecording(requester, null, null, cursorPosition, selectionLength);
    }

    @Override
    public void beginRecording(Object requester, String label) {
        this.beginRecording(requester, label, null);
    }

    @Override
    public void beginRecording(Object requester, String label, int cursorPosition, int selectionLength) {
        this.beginRecording(requester, label, null, cursorPosition, selectionLength);
    }

    @Override
    public void beginRecording(Object requester, String label, String description) {
        if (this.getUndoManager() != null) {
            this.getUndoManager().beginRecording(requester, label, description);
        }
    }

    @Override
    public void beginRecording(Object requester, String label, String description, int cursorPosition, int selectionLength) {
        if (this.getUndoManager() != null) {
            this.getUndoManager().beginRecording(requester, label, description, cursorPosition, selectionLength);
        }
    }

    @Override
    public void changedModel() {
        this.internalModelChanged();
        if (this.fModelStateChanging == 0 && this.isReinitializationNeeded()) {
            this.reinit();
        }
    }

    @Override
    public long computeModificationStamp(IResource resource) {
        long modificationStamp = resource.getModificationStamp();
        IPath path = resource.getLocation();
        if (path == null) {
            return modificationStamp;
        }
        File file = path.toFile();
        if (!file.exists()) {
            return modificationStamp;
        }
        modificationStamp = file.lastModified();
        return modificationStamp;
    }

    @Override
    public IStructuredModel copy(String newId) throws ResourceInUse {
        IStructuredModel newModel = null;
        newModel = this.getModelManager().getExistingModelForEdit(newId);
        if (newModel != null) {
            newModel.releaseFromEdit();
            throw new ResourceInUse();
        }
        newModel = this.getModelManager().copyModelForEdit(this.getId(), newId);
        return newModel;
    }

    @Override
    public void disableUndoManagement() {
        if (this.getUndoManager() != null) {
            this.getUndoManager().disableUndoManagement();
        }
    }

    @Override
    public void enableUndoManagement() {
        if (this.getUndoManager() != null) {
            this.getUndoManager().enableUndoManagement();
        }
    }

    protected final void endLock() {
    }

    @Override
    public void endRecording(Object requester) {
        if (this.getUndoManager() != null) {
            this.getUndoManager().endRecording(requester);
        }
    }

    @Override
    public void endRecording(Object requester, int cursorPosition, int selectionLength) {
        if (this.getUndoManager() != null) {
            this.getUndoManager().endRecording(requester, cursorPosition, selectionLength);
        }
    }

    private void fireModelAboutToBeChanged() {
        if (this.fModelStateListeners != null) {
            Object[] holdListeners = this.fModelStateListeners;
            int i = 0;
            while (i < holdListeners.length) {
                ((IModelStateListener)holdListeners[i]).modelAboutToBeChanged(this);
                ++i;
            }
        }
    }

    protected void fireModelAboutToBeReinitialized() {
        if (this.fModelStateListeners != null) {
            if (Logger.DEBUG_MODELSTATE) {
                Logger.log(1, "IModelStateListener event for " + this.getId() + " : modelAboutToBeReinitialized");
            }
            Object[] holdListeners = this.fModelStateListeners;
            int i = 0;
            while (i < holdListeners.length) {
                IModelStateListener listener = (IModelStateListener)holdListeners[i];
                listener.modelAboutToBeReinitialized(this);
                ++i;
            }
        }
    }

    private void fireModelChanged() {
        if (this.fModelStateListeners != null) {
            Object[] holdListeners = this.fModelStateListeners;
            int i = 0;
            while (i < holdListeners.length) {
                try {
                    ((IModelStateListener)holdListeners[i]).modelChanged(this);
                }
                catch (Exception e) {
                    Logger.logException(e);
                }
                ++i;
            }
        }
    }

    protected void fireModelDirtyStateChanged(IStructuredModel element, boolean isDirty) {
        if (this.fModelStateListeners != null) {
            if (Logger.DEBUG_MODELSTATE) {
                Logger.log(1, "IModelStateListener event for " + this.getId() + " : modelDirtyStateChanged");
            }
            Object[] holdListeners = this.fModelStateListeners;
            int i = 0;
            while (i < holdListeners.length) {
                ((IModelStateListener)holdListeners[i]).modelDirtyStateChanged(element, isDirty);
                ++i;
            }
        }
    }

    protected void fireModelReinitialized() {
        if (this.fModelStateListeners != null) {
            if (Logger.DEBUG_MODELSTATE) {
                Logger.log(1, "IModelStateListener event for " + this.getId() + " : modelReinitialized");
            }
            Object[] holdListeners = this.fModelStateListeners;
            int i = 0;
            while (i < holdListeners.length) {
                IModelStateListener listener = (IModelStateListener)holdListeners[i];
                listener.modelReinitialized(this);
                ++i;
            }
        }
    }

    protected void fireModelResourceDeleted(IStructuredModel element) {
        if (this.fModelStateListeners != null) {
            if (Logger.DEBUG_MODELSTATE) {
                Logger.log(1, "IModelStateListener event for " + this.getId() + " : modelResourceDeleted");
            }
            Object[] holdListeners = this.fModelStateListeners;
            int i = 0;
            while (i < holdListeners.length) {
                ((IModelStateListener)holdListeners[i]).modelResourceDeleted(element);
                ++i;
            }
        }
    }

    protected void fireModelResourceMoved(IStructuredModel originalElement, IStructuredModel movedElement) {
        if (this.fModelStateListeners != null) {
            if (Logger.DEBUG_MODELSTATE) {
                Logger.log(1, "IModelStateListener event for " + this.getId() + " : modelResourceMoved");
            }
            Object[] holdListeners = this.fModelStateListeners;
            int i = 0;
            while (i < holdListeners.length) {
                ((IModelStateListener)holdListeners[i]).modelResourceMoved(originalElement, movedElement);
                ++i;
            }
        }
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    @Override
    public String getBaseLocation() {
        return this.fBaseLocation;
    }

    @Override
    public String getContentTypeIdentifier() {
        if (this.fExplicitContentTypeIdentifier != null) {
            return this.fExplicitContentTypeIdentifier;
        }
        return this.fModelHandler.getAssociatedContentTypeId();
    }

    @Override
    public FactoryRegistry getFactoryRegistry() {
        if (this.factoryRegistry == null) {
            this.factoryRegistry = new FactoryRegistry();
        }
        return this.factoryRegistry;
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public abstract IndexedRegion getIndexedRegion(int var1);

    @Override
    public IModelHandler getModelHandler() {
        return this.fModelHandler;
    }

    @Override
    public IModelManager getModelManager() {
        return this._getModelManager();
    }

    @Override
    public int getReferenceCount() {
        if (this.getModelManager() == null) {
            return 0;
        }
        return this.getModelManager().getReferenceCount(this.getId());
    }

    @Override
    public int getReferenceCountForEdit() {
        if (this.getModelManager() == null) {
            return 0;
        }
        return this.getModelManager().getReferenceCountForEdit(this.getId());
    }

    @Override
    public int getReferenceCountForRead() {
        if (this.getModelManager() == null) {
            return 0;
        }
        return this.getModelManager().getReferenceCountForRead(this.getId());
    }

    @Override
    public Object getReinitializeStateData() {
        return this.reinitializeStateData;
    }

    @Override
    public URIResolver getResolver() {
        return this.fResolver;
    }

    @Override
    public IStructuredDocument getStructuredDocument() {
        IStructuredDocument result = null;
        result = this.fStructuredDocument;
        return result;
    }

    @Override
    public long getSynchronizationStamp() {
        return this.fSynchronizationStamp;
    }

    @Override
    public IStructuredTextUndoManager getUndoManager() {
        IStructuredTextUndoManager structuredTextUndoManager = null;
        IStructuredDocument structuredDocument = this.getStructuredDocument();
        structuredTextUndoManager = structuredDocument == null ? null : structuredDocument.getUndoManager();
        return structuredTextUndoManager;
    }

    public void initId(String id) {
        this.fId = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void internalAboutToBeChanged() {
        int state = 0;
        Object object = this.STATE_LOCK;
        synchronized (object) {
            state = this.fModelStateChanging++;
        }
        if (state == 0) {
            if (Logger.DEBUG_MODELSTATE) {
                Logger.log(1, "IModelStateListener event for " + this.getId() + " : modelAboutToBeChanged");
            }
            try {
                this.fireModelAboutToBeChanged();
            }
            catch (Exception e) {
                Logger.logException("Exception while notifying model state listers of about to change", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void internalModelChanged() {
        int state = 0;
        Object object = this.STATE_LOCK;
        synchronized (object) {
            state = --this.fModelStateChanging;
        }
        if (state < 0) {
            state = 0;
            throw new IllegalStateException("Program Error: modelStateChanging was less than zero");
        }
        if (state == 0) {
            if (Logger.DEBUG_MODELSTATE) {
                Logger.log(1, "IModelStateListener event for " + this.getId() + " : modelChanged");
            }
            this.fireModelChanged();
        }
    }

    @Override
    public boolean isDirty() {
        return this.fDirtyState;
    }

    protected boolean isModelChangeStateOnVergeOfEnding() {
        return this.fModelStateChanging == 1;
    }

    @Override
    public boolean isModelStateChanging() {
        return this.fModelStateChanging > 0;
    }

    @Override
    public boolean isNew() {
        return this.fNewState;
    }

    @Override
    public boolean isReinitializationNeeded() {
        return this.reinitializationNeeded;
    }

    @Override
    public boolean isSaveNeeded() {
        if (!this.isSharedForEdit()) {
            return this.isDirty();
        }
        return false;
    }

    @Override
    public boolean isShared() {
        if (this.getModelManager() == null) {
            return false;
        }
        return this.getModelManager().isShared(this.getId());
    }

    @Override
    public boolean isSharedForEdit() {
        if (this.getModelManager() == null) {
            return false;
        }
        return this.getModelManager().isSharedForEdit(this.getId());
    }

    @Override
    public boolean isSharedForRead() {
        if (this.getModelManager() == null) {
            return false;
        }
        return this.getModelManager().isSharedForRead(this.getId());
    }

    public void modelReinitialized() {
        this.fireModelReinitialized();
    }

    @Override
    public IStructuredModel newInstance() throws IOException {
        IStructuredModel newModel = null;
        newModel = this.getModelManager().createNewInstance(this);
        return newModel;
    }

    @Override
    public IStructuredModel reinit() {
        IStructuredModel result = null;
        if (this.fModelStateChanging == 0) {
            try {
                this.aboutToChangeModel();
                this.aboutToReinitializeModel();
                result = this._getModelManager().reinitialize(this);
            }
            finally {
                this.setReinitializeNeeded(false);
                this.setReinitializeStateData(null);
                this.modelReinitialized();
                this.changedModel();
            }
        } else if (Logger.DEBUG_MODELSTATE) {
            Logger.log(1, "indeed!!!");
        }
        return result;
    }

    @Override
    public void releaseFromEdit() {
        if (this.getModelManager() == null) {
            throw new IllegalStateException(MODEL_MANAGER_NULL);
        }
        boolean isShared = this.isShared();
        if (!isShared) {
            this.signalPreLifeCycleEventRelease(this);
        }
        this._getModelManager().releaseFromEdit(this);
        if (!isShared) {
            this.signalPostLifeCycleListenerRelease(this);
        }
    }

    @Override
    public void releaseFromRead() {
        if (this.getModelManager() == null) {
            throw new IllegalStateException(MODEL_MANAGER_NULL);
        }
        boolean isShared = this.isShared();
        if (!isShared) {
            this.signalPreLifeCycleEventRelease(this);
        }
        this._getModelManager().releaseFromRead(this);
        if (!isShared) {
            this.signalPostLifeCycleListenerRelease(this);
        }
    }

    @Override
    public IStructuredModel reload(InputStream inputStream) throws IOException {
        IStructuredModel result = null;
        try {
            try {
                this.aboutToChangeModel();
                result = this._getModelManager().reloadModel(this.getId(), inputStream);
            }
            catch (UnsupportedEncodingException e) {
                Logger.log(1, e.getMessage());
                this.changedModel();
            }
        }
        finally {
            this.changedModel();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeModelLifecycleListener(IModelLifecycleListener listener) {
        if (this.fLifecycleNotificationManager == null) {
            return;
        }
        Object object = this.fListenerLock;
        synchronized (object) {
            this.fLifecycleNotificationManager.removeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeModelStateListener(IModelStateListener listener) {
        if (listener == null) {
            return;
        }
        if (this.fModelStateListeners == null) {
            return;
        }
        Object object = this.fListenerLock;
        synchronized (object) {
            if (Utilities.contains(this.fModelStateListeners, listener)) {
                int oldSize = this.fModelStateListeners.length;
                int newSize = oldSize - 1;
                Object[] newListeners = new Object[newSize];
                int index = 0;
                int i = 0;
                while (i < oldSize) {
                    if (this.fModelStateListeners[i] != listener) {
                        newListeners[index++] = this.fModelStateListeners[i];
                    }
                    ++i;
                }
                this.fModelStateListeners = newListeners;
            }
        }
    }

    @Override
    public void resetSynchronizationStamp(IResource resource) {
        this.setSynchronizationStamp(this.computeModificationStamp(resource));
    }

    @Override
    public void resourceDeleted() {
        this.fireModelResourceDeleted(this);
    }

    @Override
    public void resourceMoved(IStructuredModel newModel) {
        this.fireModelResourceMoved(this, newModel);
    }

    @Override
    public void save() throws UnsupportedEncodingException, IOException, CoreException {
        int type = 257;
        ModelLifecycleEvent modelLifecycleEvent = new ModelLifecycleEvent(this, type);
        this.signalLifecycleEvent(modelLifecycleEvent);
        try {
            String stringId = this.getId();
            this._getModelManager().saveModel(stringId, EncodingRule.CONTENT_BASED);
        }
        finally {
            type = 513;
            modelLifecycleEvent = new ModelLifecycleEvent(this, type);
            this.signalLifecycleEvent(modelLifecycleEvent);
        }
    }

    @Override
    public void save(EncodingRule encodingRule) throws UnsupportedEncodingException, IOException, CoreException {
        int type = 257;
        ModelLifecycleEvent modelLifecycleEvent = new ModelLifecycleEvent(this, type);
        this.signalLifecycleEvent(modelLifecycleEvent);
        try {
            String stringId = this.getId();
            this._getModelManager().saveModel(stringId, encodingRule);
        }
        finally {
            type = 513;
            modelLifecycleEvent = new ModelLifecycleEvent(this, type);
            this.signalLifecycleEvent(modelLifecycleEvent);
        }
    }

    @Override
    public void save(IFile iFile) throws UnsupportedEncodingException, IOException, CoreException {
        int type = 257;
        ModelLifecycleEvent modelLifecycleEvent = new ModelLifecycleEvent(this, type);
        this.signalLifecycleEvent(modelLifecycleEvent);
        try {
            String stringId = this.getId();
            this._getModelManager().saveModel(iFile, stringId, EncodingRule.CONTENT_BASED);
        }
        finally {
            type = 513;
            modelLifecycleEvent = new ModelLifecycleEvent(this, type);
            this.signalLifecycleEvent(modelLifecycleEvent);
        }
    }

    @Override
    public void save(IFile iFile, EncodingRule encodingRule) throws UnsupportedEncodingException, IOException, CoreException {
        int type = 257;
        ModelLifecycleEvent modelLifecycleEvent = new ModelLifecycleEvent(this, type);
        this.signalLifecycleEvent(modelLifecycleEvent);
        try {
            String stringId = this.getId();
            this._getModelManager().saveModel(iFile, stringId, encodingRule);
        }
        finally {
            type = 513;
            modelLifecycleEvent = new ModelLifecycleEvent(this, type);
            this.signalLifecycleEvent(modelLifecycleEvent);
        }
    }

    @Override
    public void save(OutputStream outputStream) throws UnsupportedEncodingException, CoreException, IOException {
        int type = 257;
        ModelLifecycleEvent modelLifecycleEvent = new ModelLifecycleEvent(this, type);
        this.signalLifecycleEvent(modelLifecycleEvent);
        try {
            String stringId = this.getId();
            this._getModelManager().saveModel(stringId, outputStream, EncodingRule.CONTENT_BASED);
        }
        finally {
            type = 513;
            modelLifecycleEvent = new ModelLifecycleEvent(this, type);
            this.signalLifecycleEvent(modelLifecycleEvent);
        }
    }

    @Override
    public void setBaseLocation(String newBaseLocation) {
        this.fBaseLocation = newBaseLocation;
        if (this.fResolver != null) {
            this.fResolver.setFileBaseLocation(newBaseLocation);
        }
    }

    public void setContentTypeIdentifier(String contentTypeIdentifier) {
        this.fExplicitContentTypeIdentifier = contentTypeIdentifier;
    }

    @Override
    public void setDirtyState(boolean dirtyState) {
        if (this.fDirtyState != dirtyState) {
            int type = 260;
            ModelLifecycleEvent modelLifecycleEvent = new ModelLifecycleEvent(this, type);
            this.signalLifecycleEvent(modelLifecycleEvent);
            this.fDirtyState = dirtyState;
            if (!this.fDirtyState) {
                this.getStructuredDocument().addDocumentChangedListener(this.fDirtyStateWatcher);
            }
            this.fireModelDirtyStateChanged(this, dirtyState);
            type = 516;
            modelLifecycleEvent = new ModelLifecycleEvent(this, type);
            this.signalLifecycleEvent(modelLifecycleEvent);
        }
    }

    @Override
    public void setFactoryRegistry(FactoryRegistry factoryRegistry) {
        this.factoryRegistry = factoryRegistry;
    }

    @Override
    public void setId(String newId) throws ResourceInUse {
        boolean inUse;
        if (newId == null) {
            throw new IllegalArgumentException(SSECoreMessages.A_model_s_id_can_not_be_nu_EXC_);
        }
        if (newId.equals(this.fId)) {
            return;
        }
        if (this.getModelManager() != null && (inUse = ((ModelManagerImpl)this.getModelManager()).isIdInUse(newId))) {
            throw new ResourceInUse();
        }
        try {
            this.aboutToChangeModel();
            String oldId = this.fId;
            this.fId = newId;
            if (this.getModelManager() != null && oldId != null && newId != null && !newId.equals(oldId)) {
                this.getModelManager().moveModel(oldId, newId);
            }
        }
        finally {
            this.changedModel();
        }
    }

    @Override
    public void setModelHandler(IModelHandler modelHandler) {
        boolean trueChange = false;
        if (this.fModelHandler != null) {
            trueChange = true;
        }
        if (trueChange) {
            this.internalAboutToBeChanged();
        }
        this.fModelHandler = modelHandler;
        if (trueChange) {
            this.internalModelChanged();
        }
    }

    @Override
    public void setModelManager(IModelManager newModelManager) {
        this.fModelManager = newModelManager;
    }

    @Override
    public void setNewState(boolean newState) {
        this.fNewState = newState;
    }

    @Override
    public void setReinitializeNeeded(boolean needed) {
        this.reinitializationNeeded = needed;
    }

    @Override
    public void setReinitializeStateData(Object object) {
        this.reinitializeStateData = object;
    }

    @Override
    public void setResolver(URIResolver newResolver) {
        this.fResolver = newResolver;
    }

    @Override
    public void setStructuredDocument(IStructuredDocument newStructuredDocument) {
        boolean lifeCycleNotification = false;
        if (this.fStructuredDocument != null) {
            this.fStructuredDocument.removeDocumentChangedListener(this.fDirtyStateWatcher);
            this.fStructuredDocument.removeDocumentAboutToChangeListener(this.fDocumentToModelNotifier);
            this.fStructuredDocument.removeDocumentChangedListener(this.fDocumentToModelNotifier);
            lifeCycleNotification = true;
            DocumentChanged modelLifecycleEvent = new DocumentChanged(256, this, this.fStructuredDocument, newStructuredDocument);
            this.signalLifecycleEvent(modelLifecycleEvent);
        }
        IStructuredDocument previousDocument = this.fStructuredDocument;
        this.fStructuredDocument = newStructuredDocument;
        if (this.fStructuredDocument != null) {
            this.fStructuredDocument.addDocumentChangedListener(this.fDirtyStateWatcher);
            this.fStructuredDocument.addDocumentAboutToChangeListener(this.fDocumentToModelNotifier);
            this.fStructuredDocument.addDocumentChangedListener(this.fDocumentToModelNotifier);
        }
        if (lifeCycleNotification) {
            DocumentChanged modelLifecycleEvent = new DocumentChanged(512, this, previousDocument, newStructuredDocument);
            this.signalLifecycleEvent(modelLifecycleEvent);
        }
    }

    protected void setSynchronizationStamp(long newSynchronizationStamp) {
        this.fSynchronizationStamp = newSynchronizationStamp;
    }

    @Override
    public void setUndoManager(IStructuredTextUndoManager undoManager) {
        IStructuredDocument structuredDocument = this.getStructuredDocument();
        if (structuredDocument == null) {
            throw new IllegalStateException("document was null when undo manager set on model");
        }
        structuredDocument.setUndoManager(undoManager);
    }

    void signalLifecycleEvent(ModelLifecycleEvent event) {
        if (this.fLifecycleNotificationManager == null) {
            return;
        }
        this.fLifecycleNotificationManager.signalLifecycleEvent(event);
    }

    private void signalPostLifeCycleListenerRelease(IStructuredModel structuredModel) {
        int type = 514;
        ModelLifecycleEvent event = new ModelLifecycleEvent(structuredModel, type);
        ((AbstractStructuredModel)structuredModel).signalLifecycleEvent(event);
    }

    private void signalPreLifeCycleEventRelease(IStructuredModel structuredModel) {
        int type = 258;
        ModelLifecycleEvent event = new ModelLifecycleEvent(structuredModel, type);
        ((AbstractStructuredModel)structuredModel).signalLifecycleEvent(event);
    }

    class DirtyStateWatcher
    implements IStructuredDocumentListener {
        DirtyStateWatcher() {
        }

        @Override
        public void newModel(NewDocumentEvent structuredDocumentEvent) {
            AbstractStructuredModel.this.setDirtyState(AbstractStructuredModel.this.fDirtyState);
        }

        @Override
        public void noChange(NoChangeEvent structuredDocumentEvent) {
        }

        @Override
        public void nodesReplaced(StructuredDocumentRegionsReplacedEvent structuredDocumentEvent) {
            AbstractStructuredModel.this.setDirtyState(true);
            if (AbstractStructuredModel.this.fStructuredDocument != null) {
                AbstractStructuredModel.this.fStructuredDocument.removeDocumentChangedListener(AbstractStructuredModel.this.fDirtyStateWatcher);
            }
        }

        @Override
        public void regionChanged(RegionChangedEvent structuredDocumentEvent) {
            AbstractStructuredModel.this.setDirtyState(true);
            if (AbstractStructuredModel.this.fStructuredDocument != null) {
                AbstractStructuredModel.this.fStructuredDocument.removeDocumentChangedListener(AbstractStructuredModel.this.fDirtyStateWatcher);
            }
        }

        @Override
        public void regionsReplaced(RegionsReplacedEvent structuredDocumentEvent) {
            AbstractStructuredModel.this.setDirtyState(true);
            if (AbstractStructuredModel.this.fStructuredDocument != null) {
                AbstractStructuredModel.this.fStructuredDocument.removeDocumentChangedListener(AbstractStructuredModel.this.fDirtyStateWatcher);
            }
        }
    }

    class DocumentToModelNotifier
    implements IStructuredDocumentListener,
    IModelAboutToBeChangedListener {
        DocumentToModelNotifier() {
        }

        @Override
        public void modelAboutToBeChanged(AboutToBeChangedEvent structuredDocumentEvent) {
            if (structuredDocumentEvent.getOriginalRequester() != this) {
                AbstractStructuredModel.this.aboutToChangeModel();
            }
        }

        @Override
        public void newModel(NewDocumentEvent structuredDocumentEvent) {
            if (structuredDocumentEvent.getOriginalRequester() != this) {
                AbstractStructuredModel.this.changedModel();
            }
        }

        @Override
        public void noChange(NoChangeEvent structuredDocumentEvent) {
            if (structuredDocumentEvent.getOriginalRequester() != this) {
                AbstractStructuredModel.this.changedModel();
            }
        }

        @Override
        public void nodesReplaced(StructuredDocumentRegionsReplacedEvent structuredDocumentEvent) {
            if (structuredDocumentEvent.getOriginalRequester() != this) {
                AbstractStructuredModel.this.changedModel();
            }
        }

        @Override
        public void regionChanged(RegionChangedEvent structuredDocumentEvent) {
            if (structuredDocumentEvent.getOriginalRequester() != this) {
                AbstractStructuredModel.this.changedModel();
            }
        }

        @Override
        public void regionsReplaced(RegionsReplacedEvent structuredDocumentEvent) {
            if (structuredDocumentEvent.getOriginalRequester() != this) {
                AbstractStructuredModel.this.changedModel();
            }
        }
    }
}

