/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Arrays;
import org.eclipse.n4js.ts.typeRefs.BoundThisTypeRef;
import org.eclipse.n4js.ts.typeRefs.IntersectionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.types.TypingStrategy;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.typesystem.utils.TypeSystemHelper;
import org.eclipse.n4js.utils.AndFunction1;
import org.eclipse.n4js.utils.ContainerTypesHelper;
import org.eclipse.n4js.utils.StructuralMembersPredicates;
import org.eclipse.n4js.utils.StructuralMembersTripleIterator;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class StructuralTypesHelper {
    @Inject
    private ContainerTypesHelper containerTypesHelper;
    @Inject
    private TypeSystemHelper tsh;

    public StructuralMembersTripleIterator getMembersTripleIterator(RuleEnvironment G, TypeRef left, TypeRef right, boolean restrictInitTyping) {
        TypingStrategy rightStrategy = right.getTypingStrategy();
        TypingStrategy leftStrategy = left.getTypingStrategy();
        if (TypingStrategy.STRUCTURAL_FIELD_INITIALIZER == rightStrategy) {
            TypingStrategy _xifexpression = null;
            _xifexpression = restrictInitTyping ? TypingStrategy.STRUCTURAL_READ_ONLY_FIELDS : TypingStrategy.STRUCTURAL_FIELDS;
            leftStrategy = _xifexpression;
            TypingStrategy _xifexpression_1 = null;
            _xifexpression_1 = restrictInitTyping ? TypingStrategy.STRUCTURAL_WRITE_ONLY_FIELDS : TypingStrategy.STRUCTURAL_FIELDS;
            rightStrategy = _xifexpression_1;
        }
        if (TypingStrategy.STRUCTURAL_FIELD_INITIALIZER == leftStrategy) {
            TypingStrategy _xifexpression_2 = null;
            _xifexpression_2 = restrictInitTyping ? TypingStrategy.STRUCTURAL_READ_ONLY_FIELDS : TypingStrategy.STRUCTURAL_FIELDS;
            leftStrategy = _xifexpression_2;
        }
        Iterable<TMember> membersLeft = this.collectStructuralMembers(G, left, leftStrategy);
        Iterable<TMember> membersRight = this.collectStructuralMembers(G, right, rightStrategy);
        return StructuralMembersTripleIterator.ofUnprepared(membersLeft, membersRight, left.getTypingStrategy(), right.getTypingStrategy());
    }

    public Iterable<TMember> collectStructuralMembers(RuleEnvironment G, TypeRef typeRef, TypingStrategy strategy) {
        AndFunction1<TMember> _createBaseStructuralMembersPredicate = StructuralMembersPredicates.createBaseStructuralMembersPredicate(G);
        AndFunction1<TMember> _switchResult = null;
        if (strategy != null) {
            switch (strategy) {
                case STRUCTURAL_WRITE_ONLY_FIELDS: {
                    _switchResult = StructuralMembersPredicates.WRITABLE_FIELDS_PREDICATE;
                    break;
                }
                case STRUCTURAL_READ_ONLY_FIELDS: {
                    _switchResult = StructuralMembersPredicates.READABLE_FIELDS_PREDICATE;
                    break;
                }
                case STRUCTURAL_FIELDS: {
                    _switchResult = StructuralMembersPredicates.FIELDS_PREDICATE;
                    break;
                }
                case STRUCTURAL_FIELD_INITIALIZER: {
                    throw new IllegalStateException("Expected read-only and write-only variants instead.");
                }
                default: {
                    _switchResult = StructuralMembersPredicates.MEMBERS_PREDICATE;
                    break;
                }
            }
        } else {
            _switchResult = StructuralMembersPredicates.MEMBERS_PREDICATE;
        }
        AndFunction1 predicate = _createBaseStructuralMembersPredicate.and(new Functions.Function1[]{_switchResult});
        return this.doCollectMembers(G, typeRef, (Functions.Function1<TMember, Boolean>)predicate);
    }

    private Iterable<TMember> _doCollectMembers(RuleEnvironment G, TypeRef ref, Functions.Function1<TMember, Boolean> predicate) {
        return CollectionLiterals.emptyList();
    }

    private Iterable<TMember> _doCollectMembers(RuleEnvironment G, BoundThisTypeRef ref, Functions.Function1<TMember, Boolean> predicate) {
        boolean _not;
        Iterable<TMember> structMembersOfThis = this.doCollectMembers(G, (TypeRef)ref.getActualThisTypeRef(), predicate);
        boolean _isEmpty = ref.getStructuralMembers().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            return Iterables.concat(structMembersOfThis, (Iterable)ref.getStructuralMembers());
        }
        return structMembersOfThis;
    }

    private Iterable<TMember> _doCollectMembers(RuleEnvironment G, ParameterizedTypeRef ref, Functions.Function1<TMember, Boolean> predicate) {
        boolean _not;
        Iterable<TMember> nominalMembers = this.doCollectMembersOfType(G, ref.getDeclaredType(), predicate);
        boolean _isEmpty = ref.getStructuralMembers().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            return Iterables.concat(nominalMembers, (Iterable)ref.getStructuralMembers());
        }
        return nominalMembers;
    }

    private Iterable<TMember> _doCollectMembersOfType(RuleEnvironment G, Type type, Functions.Function1<TMember, Boolean> predicate) {
        return CollectionLiterals.emptyList();
    }

    private Iterable<TMember> _doCollectMembersOfType(RuleEnvironment G, ContainerType<?> type, Functions.Function1<TMember, Boolean> predicate) {
        return IterableExtensions.filter(this.containerTypesHelper.fromContext(RuleEnvironmentExtensions.getContextResource(G)).members(type), predicate);
    }

    private Iterable<TMember> _doCollectMembersOfType(RuleEnvironment G, TypeVariable type, Functions.Function1<TMember, Boolean> predicate) {
        TypeRef declUB = type.getDeclaredUpperBound();
        TypeRef _xifexpression = null;
        _xifexpression = declUB instanceof IntersectionTypeExpression ? this.tsh.join(G, (Iterable<? extends TypeRef>)((IntersectionTypeExpression)declUB).getTypeRefs()) : declUB;
        TypeRef joinOfUpperBounds = _xifexpression;
        if (joinOfUpperBounds != null) {
            return this.doCollectMembers(G, joinOfUpperBounds, predicate);
        }
        return CollectionLiterals.emptyList();
    }

    private Iterable<TMember> doCollectMembers(RuleEnvironment G, TypeRef ref, Functions.Function1<TMember, Boolean> predicate) {
        if (ref instanceof BoundThisTypeRef) {
            return this._doCollectMembers(G, (BoundThisTypeRef)ref, predicate);
        }
        if (ref instanceof ParameterizedTypeRef) {
            return this._doCollectMembers(G, (ParameterizedTypeRef)ref, predicate);
        }
        if (ref != null) {
            return this._doCollectMembers(G, ref, predicate);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(G, ref, predicate).toString());
    }

    private Iterable<TMember> doCollectMembersOfType(RuleEnvironment G, Type type, Functions.Function1<TMember, Boolean> predicate) {
        if (type instanceof ContainerType) {
            return this._doCollectMembersOfType(G, (ContainerType)type, predicate);
        }
        if (type instanceof TypeVariable) {
            return this._doCollectMembersOfType(G, (TypeVariable)type, predicate);
        }
        if (type != null) {
            return this._doCollectMembersOfType(G, type, predicate);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(G, type, predicate).toString());
    }
}

