/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.internal.edit.ui;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.html.core.internal.HTMLCorePlugin;
import org.eclipse.wst.html.ui.internal.HTMLUIMessages;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;

public class CleanupDialogHTML
extends Dialog
implements SelectionListener {
    protected Button fRadioButtonTagNameCaseAsis;
    protected Button fRadioButtonTagNameCaseLower;
    protected Button fRadioButtonTagNameCaseUpper;
    protected Button fRadioButtonAttrNameCaseAsis;
    protected Button fRadioButtonAttrNameCaseLower;
    protected Button fRadioButtonAttrNameCaseUpper;
    protected Button fCheckBoxCompressEmptyElementTags;
    protected Button fCheckBoxInsertRequiredAttrs;
    protected Button fCheckBoxInsertMissingTags;
    protected Button fCheckBoxQuoteAttrValues;
    protected Button fCheckBoxFormatSource;
    protected Button fCheckBoxConvertEOLCodes;
    protected Button fRadioButtonConvertEOLWindows;
    protected Button fRadioButtonConvertEOLUnix;
    protected Button fRadioButtonConvertEOLMac;
    protected Preferences fPreferences = null;
    private boolean fIsXHTML = false;
    private Group fTagNameCase;
    private Group fAttrNameCase;

    public CleanupDialogHTML(Shell shell) {
        super(shell);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(HTMLUIMessages.Cleanup_UI_);
        Composite composite = new Composite(parent, 0);
        this.createDialogAreaInComposite(composite);
        this.initializeOptions();
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control c = super.createButtonBar(parent);
        this.okButtonEnablement();
        return c;
    }

    protected void createDialogAreaInCompositeForHTML(Composite composite) {
        this.fTagNameCase = new Group(composite, 0);
        this.fTagNameCase.setText(HTMLUIMessages.Tag_name_case_for_HTML_UI_);
        GridLayout hLayout = new GridLayout();
        hLayout.numColumns = 3;
        this.fTagNameCase.setLayout((Layout)hLayout);
        this.fRadioButtonTagNameCaseAsis = new Button((Composite)this.fTagNameCase, 16);
        this.fRadioButtonTagNameCaseAsis.setText(HTMLUIMessages.Tag_name_case_As_is_UI_);
        this.fRadioButtonTagNameCaseAsis.addSelectionListener((SelectionListener)this);
        this.fRadioButtonTagNameCaseLower = new Button((Composite)this.fTagNameCase, 16);
        this.fRadioButtonTagNameCaseLower.setText(HTMLUIMessages.Tag_name_case_Lower_UI_);
        this.fRadioButtonTagNameCaseLower.addSelectionListener((SelectionListener)this);
        this.fRadioButtonTagNameCaseUpper = new Button((Composite)this.fTagNameCase, 16);
        this.fRadioButtonTagNameCaseUpper.setText(HTMLUIMessages.Tag_name_case_Upper_UI_);
        this.fRadioButtonTagNameCaseUpper.addSelectionListener((SelectionListener)this);
        this.fAttrNameCase = new Group(composite, 0);
        this.fAttrNameCase.setText(HTMLUIMessages.Attribute_name_case_for_HTML_UI_);
        this.fAttrNameCase.setLayout((Layout)hLayout);
        this.fRadioButtonAttrNameCaseAsis = new Button((Composite)this.fAttrNameCase, 16);
        this.fRadioButtonAttrNameCaseAsis.setText(HTMLUIMessages.Attribute_name_case_As_is_UI_);
        this.fRadioButtonAttrNameCaseAsis.addSelectionListener((SelectionListener)this);
        this.fRadioButtonAttrNameCaseLower = new Button((Composite)this.fAttrNameCase, 16);
        this.fRadioButtonAttrNameCaseLower.setText(HTMLUIMessages.Attribute_name_case_Lower_UI_);
        this.fRadioButtonAttrNameCaseLower.addSelectionListener((SelectionListener)this);
        this.fRadioButtonAttrNameCaseUpper = new Button((Composite)this.fAttrNameCase, 16);
        this.fRadioButtonAttrNameCaseUpper.setText(HTMLUIMessages.Attribute_name_case_Upper_UI_);
        this.fRadioButtonAttrNameCaseUpper.addSelectionListener((SelectionListener)this);
    }

    protected void createDialogAreaInComposite(Composite composite) {
        this.createDialogAreaInCompositeForHTML(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.wst.html.ui.xmlm1100");
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)layout);
        this.fCheckBoxCompressEmptyElementTags = new Button(composite, 32);
        this.fCheckBoxCompressEmptyElementTags.setText(XMLUIMessages.Compress_empty_element_tags_UI_);
        this.fCheckBoxCompressEmptyElementTags.addSelectionListener((SelectionListener)this);
        this.fCheckBoxInsertRequiredAttrs = new Button(composite, 32);
        this.fCheckBoxInsertRequiredAttrs.setText(HTMLUIMessages.Insert_required_attributes_UI_);
        this.fCheckBoxInsertRequiredAttrs.addSelectionListener((SelectionListener)this);
        this.fCheckBoxInsertMissingTags = new Button(composite, 32);
        this.fCheckBoxInsertMissingTags.setText(HTMLUIMessages.Insert_missing_tags_UI_);
        this.fCheckBoxInsertMissingTags.addSelectionListener((SelectionListener)this);
        this.fCheckBoxQuoteAttrValues = new Button(composite, 32);
        this.fCheckBoxQuoteAttrValues.setText(HTMLUIMessages.Quote_attribute_values_UI_);
        this.fCheckBoxQuoteAttrValues.addSelectionListener((SelectionListener)this);
        this.fCheckBoxFormatSource = new Button(composite, 32);
        this.fCheckBoxFormatSource.setText(HTMLUIMessages.Format_source_UI_);
        this.fCheckBoxFormatSource.addSelectionListener((SelectionListener)this);
        this.fCheckBoxConvertEOLCodes = new Button(composite, 32);
        this.fCheckBoxConvertEOLCodes.setText(HTMLUIMessages.Convert_EOL_codes_UI_);
        this.fCheckBoxConvertEOLCodes.addSelectionListener((SelectionListener)this);
        Composite EOLCodes = new Composite(composite, 0);
        GridLayout hLayout = new GridLayout();
        hLayout.numColumns = 3;
        EOLCodes.setLayout((Layout)hLayout);
        this.fRadioButtonConvertEOLWindows = new Button(EOLCodes, 16);
        this.fRadioButtonConvertEOLWindows.setText(HTMLUIMessages.EOL_Windows_UI);
        this.fRadioButtonConvertEOLWindows.addSelectionListener((SelectionListener)this);
        this.fRadioButtonConvertEOLUnix = new Button(EOLCodes, 16);
        this.fRadioButtonConvertEOLUnix.setText(HTMLUIMessages.EOL_Unix_UI);
        this.fRadioButtonConvertEOLUnix.addSelectionListener((SelectionListener)this);
        this.fRadioButtonConvertEOLMac = new Button(EOLCodes, 16);
        this.fRadioButtonConvertEOLMac.setText(HTMLUIMessages.EOL_Mac_UI);
        this.fRadioButtonConvertEOLMac.addSelectionListener((SelectionListener)this);
    }

    protected void okPressed() {
        this.storeOptions();
        super.okPressed();
    }

    protected void initializeOptionsForHTML() {
        boolean caseSensitive = this.isXHTMLType();
        if (caseSensitive) {
            this.fRadioButtonTagNameCaseLower.setSelection(true);
        } else {
            int tagNameCase = this.getModelPreferences().getInt("cleanupTagNameCase");
            if (tagNameCase == 2) {
                this.fRadioButtonTagNameCaseUpper.setSelection(true);
            } else if (tagNameCase == 1) {
                this.fRadioButtonTagNameCaseLower.setSelection(true);
            } else {
                this.fRadioButtonTagNameCaseAsis.setSelection(true);
            }
        }
        if (caseSensitive) {
            this.fRadioButtonAttrNameCaseLower.setSelection(true);
        } else {
            int attrNameCase = this.getModelPreferences().getInt("cleanupAttrNameCase");
            if (attrNameCase == 2) {
                this.fRadioButtonAttrNameCaseUpper.setSelection(true);
            } else if (attrNameCase == 1) {
                this.fRadioButtonAttrNameCaseLower.setSelection(true);
            } else {
                this.fRadioButtonAttrNameCaseAsis.setSelection(true);
            }
        }
        this.enableCaseControls(!caseSensitive);
    }

    protected void initializeOptions() {
        this.initializeOptionsForHTML();
        this.fCheckBoxCompressEmptyElementTags.setSelection(this.getModelPreferences().getBoolean("compressEmptyElementTags"));
        this.fCheckBoxInsertRequiredAttrs.setSelection(this.getModelPreferences().getBoolean("insertRequiredAttrs"));
        this.fCheckBoxInsertMissingTags.setSelection(this.getModelPreferences().getBoolean("insertMissingTags"));
        this.fCheckBoxQuoteAttrValues.setSelection(this.getModelPreferences().getBoolean("quoteAttrValues"));
        this.fCheckBoxFormatSource.setSelection(this.getModelPreferences().getBoolean("formatSource"));
        this.fCheckBoxConvertEOLCodes.setSelection(this.getModelPreferences().getBoolean("convertEOLCodes"));
        if (this.fCheckBoxConvertEOLCodes.getSelection()) {
            String EOLCode = this.getModelPreferences().getString("cleanupEOLCode");
            if (EOLCode == "EOL_Unix") {
                this.fRadioButtonConvertEOLUnix.setSelection(true);
            } else if (EOLCode == "EOL_Mac") {
                this.fRadioButtonConvertEOLMac.setSelection(true);
            } else {
                this.fRadioButtonConvertEOLWindows.setSelection(true);
            }
        }
        this.enableEOLCodeRadios(this.fCheckBoxConvertEOLCodes.getSelection());
    }

    protected void storeOptionsForHTML() {
        if (!this.isXHTMLType() && this.fRadioButtonTagNameCaseUpper.getSelection()) {
            this.getModelPreferences().setValue("cleanupTagNameCase", 2);
        } else if (this.fRadioButtonTagNameCaseLower.getSelection()) {
            this.getModelPreferences().setValue("cleanupTagNameCase", 1);
        } else {
            this.getModelPreferences().setValue("cleanupTagNameCase", 0);
        }
        if (!this.isXHTMLType() && this.fRadioButtonAttrNameCaseUpper.getSelection()) {
            this.getModelPreferences().setValue("cleanupAttrNameCase", 2);
        } else if (this.fRadioButtonAttrNameCaseLower.getSelection()) {
            this.getModelPreferences().setValue("cleanupAttrNameCase", 1);
        } else {
            this.getModelPreferences().setValue("cleanupAttrNameCase", 0);
        }
        HTMLCorePlugin.getDefault().savePluginPreferences();
    }

    protected void storeOptions() {
        this.storeOptionsForHTML();
        this.getModelPreferences().setValue("compressEmptyElementTags", this.fCheckBoxCompressEmptyElementTags.getSelection());
        this.getModelPreferences().setValue("insertRequiredAttrs", this.fCheckBoxInsertRequiredAttrs.getSelection());
        this.getModelPreferences().setValue("insertMissingTags", this.fCheckBoxInsertMissingTags.getSelection());
        this.getModelPreferences().setValue("quoteAttrValues", this.fCheckBoxQuoteAttrValues.getSelection());
        this.getModelPreferences().setValue("formatSource", this.fCheckBoxFormatSource.getSelection());
        this.getModelPreferences().setValue("convertEOLCodes", this.fCheckBoxConvertEOLCodes.getSelection());
        if (this.fCheckBoxConvertEOLCodes.getSelection()) {
            if (this.fRadioButtonConvertEOLUnix.getSelection()) {
                this.getModelPreferences().setValue("cleanupEOLCode", "EOL_Unix");
            } else if (this.fRadioButtonConvertEOLMac.getSelection()) {
                this.getModelPreferences().setValue("cleanupEOLCode", "EOL_Mac");
            } else {
                this.getModelPreferences().setValue("cleanupEOLCode", "EOL_Windows");
            }
        }
        HTMLCorePlugin.getDefault().savePluginPreferences();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.fCheckBoxConvertEOLCodes) {
            this.enableEOLCodeRadios(this.fCheckBoxConvertEOLCodes.getSelection());
        }
        this.okButtonEnablement();
    }

    protected Preferences getModelPreferences() {
        return HTMLCorePlugin.getDefault().getPluginPreferences();
    }

    private boolean isXHTMLType() {
        return this.fIsXHTML;
    }

    protected void enableEOLCodeRadios(boolean enable) {
        if (this.fRadioButtonConvertEOLWindows != null && this.fRadioButtonConvertEOLUnix != null && this.fRadioButtonConvertEOLMac != null) {
            this.fRadioButtonConvertEOLWindows.setEnabled(enable);
            this.fRadioButtonConvertEOLUnix.setEnabled(enable);
            this.fRadioButtonConvertEOLMac.setEnabled(enable);
            if (!(this.fRadioButtonConvertEOLWindows.getSelection() || this.fRadioButtonConvertEOLUnix.getSelection() || this.fRadioButtonConvertEOLMac.getSelection())) {
                this.fRadioButtonConvertEOLWindows.setSelection(true);
            }
        }
    }

    private void enableCaseControls(boolean enable) {
        this.fTagNameCase.setEnabled(enable);
        this.fRadioButtonTagNameCaseAsis.setEnabled(enable);
        this.fRadioButtonTagNameCaseLower.setEnabled(enable);
        this.fRadioButtonTagNameCaseUpper.setEnabled(enable);
        this.fAttrNameCase.setEnabled(enable);
        this.fRadioButtonAttrNameCaseAsis.setEnabled(enable);
        this.fRadioButtonAttrNameCaseLower.setEnabled(enable);
        this.fRadioButtonAttrNameCaseUpper.setEnabled(enable);
    }

    private void okButtonEnablement() {
        boolean tagNameCaseCheck = this.fRadioButtonTagNameCaseUpper != null && this.fRadioButtonTagNameCaseUpper.getSelection() || this.fRadioButtonTagNameCaseLower.getSelection();
        boolean attrNameCaseCheck = this.fRadioButtonAttrNameCaseUpper != null && this.fRadioButtonAttrNameCaseUpper.getSelection() || this.fRadioButtonAttrNameCaseLower.getSelection();
        boolean eolCheck = this.fCheckBoxConvertEOLCodes.getSelection() && (this.fRadioButtonConvertEOLUnix.getSelection() || this.fRadioButtonConvertEOLMac.getSelection() || this.fRadioButtonConvertEOLWindows.getSelection());
        boolean buttonEnabled = false;
        buttonEnabled = this.isXHTMLType() ? this.fCheckBoxInsertRequiredAttrs.getSelection() || this.fCheckBoxInsertMissingTags.getSelection() || this.fCheckBoxQuoteAttrValues.getSelection() || this.fCheckBoxFormatSource.getSelection() || eolCheck : tagNameCaseCheck || attrNameCaseCheck || this.fCheckBoxInsertRequiredAttrs.getSelection() || this.fCheckBoxInsertMissingTags.getSelection() || this.fCheckBoxQuoteAttrValues.getSelection() || this.fCheckBoxFormatSource.getSelection() || eolCheck;
        this.getButton(0).setEnabled(buttonEnabled);
    }

    void setisXHTMLType(boolean isXHTML) {
        this.fIsXHTML = isXHTML;
    }
}

