/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es.transform;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.AssignmentExpression;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ExpressionStatement;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.IfStatement;
import org.eclipse.n4js.n4JS.N4ClassifierDeclaration;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4InterfaceDeclaration;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.RelationalOperator;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.transpiler.Transformation;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.assistants.TypeAssistant;
import org.eclipse.n4js.transpiler.es.assistants.BootstrapCallAssistant;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryInternal;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryOriginal;
import org.eclipse.n4js.transpiler.utils.TranspilerUtils;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class InterfaceDeclarationTransformation
extends Transformation {
    @Inject
    private BootstrapCallAssistant bootstrapCallAssistant;
    @Inject
    private TypeAssistant typeAssistant;

    public void assertPreConditions() {
        this.typeAssistant.assertClassifierPreConditions();
    }

    public void assertPostConditions() {
    }

    public void analyze() {
    }

    public void transform() {
        Consumer<N4InterfaceDeclaration> _function = it -> this.transformInterfaceDecl((N4InterfaceDeclaration)it);
        this.collectNodes((EObject)this.getState().im, N4InterfaceDeclaration.class, false).forEach(_function);
    }

    private void transformInterfaceDecl(N4InterfaceDeclaration ifcDecl) {
        SymbolTableEntry ifcSTE = this.findSymbolTableEntryForElement((NamedElement)ifcDecl, true);
        VariableDeclaration varDecl = this.createVarDecl(ifcDecl);
        ExpressionStatement fieldInitFun = this.createInstanceFieldInitializationFunction(ifcDecl, ifcSTE);
        List<Statement> staticFieldInits = this.createStaticFieldInitializations(ifcSTE, ifcDecl);
        Statement[] memberDefs = this.bootstrapCallAssistant.createInterfaceMemberDefinitionSection(ifcDecl);
        ExpressionStatement makeIfcCall = this.bootstrapCallAssistant.createMakeInterfaceCall(ifcDecl);
        this.getState().tracer.copyTrace((EObject)ifcDecl, (EObject[])Conversions.unwrapArray(staticFieldInits, EObject.class));
        this.getState().tracer.copyTrace((EObject)ifcDecl, (EObject[])memberDefs);
        this.getState().tracer.copyTrace((EObject)ifcDecl, new EObject[]{makeIfcCall});
        this.replace(ifcDecl, varDecl);
        EObject root = TranspilerUtils.orContainingExportDeclaration((EObject)varDecl.eContainer());
        Iterable _plus = Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new ExpressionStatement[]{fieldInitFun})), staticFieldInits);
        Iterable _plus_1 = Iterables.concat((Iterable)_plus, (Iterable)((Iterable)Conversions.doWrapArray((Object)memberDefs)));
        Iterable _plus_2 = Iterables.concat((Iterable)_plus_1, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new ExpressionStatement[]{makeIfcCall})));
        this.insertAfter(root, (EObject[])Conversions.unwrapArray((Object)_plus_2, EObject.class));
        this.getState().info.markAsToHoist(varDecl);
    }

    private VariableDeclaration createVarDecl(N4InterfaceDeclaration ifcDecl) {
        VariableDeclaration __VariableDeclaration = TranspilerBuilderBlocks._VariableDeclaration((String)ifcDecl.getName());
        Procedures.Procedure1 _function = it -> it.setExpression((Expression)TranspilerBuilderBlocks._ObjLit());
        return (VariableDeclaration)ObjectExtensions.operator_doubleArrow((Object)__VariableDeclaration, (Procedures.Procedure1)_function);
    }

    private ExpressionStatement createInstanceFieldInitializationFunction(N4InterfaceDeclaration ifcDecl, SymbolTableEntry ifcSTE) {
        SymbolTableEntryInternal $fieldInitSTE = this.steFor_$fieldInit();
        AssignmentExpression __AssignmentExpr = TranspilerBuilderBlocks._AssignmentExpr();
        Procedures.Procedure1 _function = it -> {
            it.setLhs((Expression)TranspilerBuilderBlocks._PropertyAccessExpr((SymbolTableEntry)ifcSTE, (SymbolTableEntry[])new SymbolTableEntry[]{$fieldInitSTE}));
            String _name = ifcDecl.getName();
            String _plus = String.valueOf(_name) + "_fieldInit";
            FormalParameter __Fpar = TranspilerBuilderBlocks._Fpar((String)"spec");
            FormalParameter __Fpar_1 = TranspilerBuilderBlocks._Fpar((String)"mixinExclusion");
            FunctionExpression __FunExpr = TranspilerBuilderBlocks._FunExpr((boolean)false, (String)_plus, (FormalParameter[])new FormalParameter[]{__Fpar, __Fpar_1});
            Procedures.Procedure1 _function_1 = it_1 -> {
                EList _statements = it_1.getBody().getStatements();
                Statement[] _createInstanceFieldInitializations = this.createInstanceFieldInitializations(ifcDecl);
                Iterables.addAll((Collection)_statements, (Iterable)((Iterable)Conversions.doWrapArray((Object)_createInstanceFieldInitializations)));
                EList _statements_1 = it_1.getBody().getStatements();
                Statement[] _createDelegationToFieldInitOfExtendedInterfaces = this.createDelegationToFieldInitOfExtendedInterfaces(ifcDecl);
                Iterables.addAll((Collection)_statements_1, (Iterable)((Iterable)Conversions.doWrapArray((Object)_createDelegationToFieldInitOfExtendedInterfaces)));
            };
            FunctionExpression _doubleArrow = (FunctionExpression)ObjectExtensions.operator_doubleArrow((Object)__FunExpr, (Procedures.Procedure1)_function_1);
            it.setRhs((Expression)_doubleArrow);
        };
        AssignmentExpression _doubleArrow = (AssignmentExpression)ObjectExtensions.operator_doubleArrow((Object)__AssignmentExpr, (Procedures.Procedure1)_function);
        return TranspilerBuilderBlocks._ExprStmnt((Expression)_doubleArrow);
    }

    private Statement[] createInstanceFieldInitializations(N4InterfaceDeclaration ifcDecl) {
        boolean _not;
        Functions.Function1 _function = it -> {
            boolean _isStatic = it.isStatic();
            return !_isStatic;
        };
        List fields = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)ifcDecl.getOwnedFields(), (Functions.Function1)_function));
        boolean _isEmpty = fields.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            SymbolTableEntryOriginal hasOwnPropertySTE = this.getSymbolTableEntryForMember(RuleEnvironmentExtensions.objectType((RuleEnvironment)this.getState().G), "hasOwnProperty", false, false, true);
            ArrayList fieldInitsFromSpec = CollectionLiterals.newArrayList();
            ArrayList fieldInitsNormal = CollectionLiterals.newArrayList();
            for (N4FieldDeclaration field : fields) {
                SymbolTableEntry fieldSTE = this.findSymbolTableEntryForElement((NamedElement)field, true);
                Object _xifexpression = null;
                Expression _expression = field.getExpression();
                boolean _tripleNotEquals = _expression != null;
                _xifexpression = _tripleNotEquals ? (Expression)this.copy((EObject)field.getExpression()) : this.undefinedRef();
                ExpressionStatement specStmnt = TranspilerBuilderBlocks._ExprStmnt((Expression)TranspilerBuilderBlocks._AssignmentExpr((Expression)TranspilerBuilderBlocks._PropertyAccessExpr((Expression)TranspilerBuilderBlocks._Snippet((String)"this"), (SymbolTableEntry[])new SymbolTableEntry[]{fieldSTE}), (Expression)TranspilerBuilderBlocks._ConditionalExpr((Expression)TranspilerBuilderBlocks._RelationalExpr((Expression)TranspilerBuilderBlocks._StringLiteralForSTE((SymbolTableEntry)fieldSTE), (RelationalOperator)RelationalOperator.IN, (Expression)TranspilerBuilderBlocks._Snippet((String)"spec")), (Expression)TranspilerBuilderBlocks._PropertyAccessExpr((Expression)TranspilerBuilderBlocks._Snippet((String)"spec"), (SymbolTableEntry[])new SymbolTableEntry[]{fieldSTE}), (Expression)_xifexpression)));
                IfStatement _ifStmntMixinExclusionORtarget = this.ifStmntMixinExclusionORtarget((SymbolTableEntry)hasOwnPropertySTE, fieldSTE, (Statement)specStmnt);
                fieldInitsFromSpec.add(_ifStmntMixinExclusionORtarget);
                Object _xifexpression_1 = null;
                Expression _expression_1 = field.getExpression();
                boolean _tripleNotEquals_1 = _expression_1 != null;
                _xifexpression_1 = _tripleNotEquals_1 ? (Expression)this.copy((EObject)field.getExpression()) : this.undefinedRef();
                ExpressionStatement trueBody = TranspilerBuilderBlocks._ExprStmnt((Expression)TranspilerBuilderBlocks._AssignmentExpr((Expression)TranspilerBuilderBlocks._PropertyAccessExpr((Expression)TranspilerBuilderBlocks._Snippet((String)"this"), (SymbolTableEntry[])new SymbolTableEntry[]{fieldSTE}), (Expression)_xifexpression_1));
                IfStatement _ifStmntMixinExclusionORtarget_1 = this.ifStmntMixinExclusionORtarget((SymbolTableEntry)hasOwnPropertySTE, fieldSTE, (Statement)trueBody);
                fieldInitsNormal.add(_ifStmntMixinExclusionORtarget_1);
            }
            IfStatement __IfStmnt = TranspilerBuilderBlocks._IfStmnt((Expression)TranspilerBuilderBlocks._Snippet((String)"spec"), (Statement)TranspilerBuilderBlocks._Block((Statement[])((Statement[])Conversions.unwrapArray((Object)fieldInitsFromSpec, Statement.class))), (Statement)TranspilerBuilderBlocks._Block((Statement[])((Statement[])Conversions.unwrapArray((Object)fieldInitsNormal, Statement.class))));
            return new Statement[]{__IfStmnt};
        }
        return new Statement[0];
    }

    private IfStatement ifStmntMixinExclusionORtarget(SymbolTableEntry hasOwnPropertySTE, SymbolTableEntry fieldSTE, Statement trueBody) {
        return TranspilerBuilderBlocks._IfStmnt((Expression)TranspilerBuilderBlocks._NOT((Expression)TranspilerBuilderBlocks._Parenthesis((Expression)TranspilerBuilderBlocks._OR((Expression)TranspilerBuilderBlocks._CallExpr((Expression)TranspilerBuilderBlocks._PropertyAccessExpr((Expression)TranspilerBuilderBlocks._Snippet((String)"mixinExclusion"), (SymbolTableEntry[])new SymbolTableEntry[]{hasOwnPropertySTE}), (Expression[])new Expression[]{TranspilerBuilderBlocks._StringLiteralForSTE((SymbolTableEntry)fieldSTE)}), (Expression)TranspilerBuilderBlocks._CallExpr((Expression)TranspilerBuilderBlocks._PropertyAccessExpr((Expression)TranspilerBuilderBlocks._Snippet((String)"this"), (SymbolTableEntry[])new SymbolTableEntry[]{hasOwnPropertySTE}), (Expression[])new Expression[]{TranspilerBuilderBlocks._StringLiteralForSTE((SymbolTableEntry)fieldSTE)})))), (Statement)trueBody);
    }

    private Statement[] createDelegationToFieldInitOfExtendedInterfaces(N4InterfaceDeclaration ifcDecl) {
        ArrayList result = CollectionLiterals.newArrayList();
        SymbolTableEntryInternal $fieldInitSTE = this.steFor_$fieldInit();
        Functions.Function1 _function = it -> {
            IdentifiableElement _originalTarget = it.getOriginalTarget();
            boolean _builtInOrProvidedByRuntimeOrExternalWithoutN4JSAnnotation = N4JSLanguageUtils.builtInOrProvidedByRuntimeOrExternalWithoutN4JSAnnotation((TInterface)((TInterface)_originalTarget));
            return !_builtInOrProvidedByRuntimeOrExternalWithoutN4JSAnnotation;
        };
        Iterable superIfcSTEs = IterableExtensions.filter((Iterable)this.typeAssistant.getSuperInterfacesSTEs((N4ClassifierDeclaration)ifcDecl), (Functions.Function1)_function);
        for (SymbolTableEntryOriginal superIfcSTE : superIfcSTEs) {
            ExpressionStatement __ExprStmnt = TranspilerBuilderBlocks._ExprStmnt((Expression)TranspilerBuilderBlocks._CallExpr((Expression)this.__NSSafe_PropertyAccessExpr((SymbolTableEntry)superIfcSTE, new SymbolTableEntry[]{$fieldInitSTE, this.steFor_call()}), (Expression[])new Expression[]{TranspilerBuilderBlocks._Snippet((String)"this"), TranspilerBuilderBlocks._Snippet((String)"spec"), TranspilerBuilderBlocks._Snippet((String)"mixinExclusion")}));
            result.add(__ExprStmnt);
        }
        return (Statement[])Conversions.unwrapArray((Object)result, Statement.class);
    }

    protected List<Statement> createStaticFieldInitializations(SymbolTableEntry ifcSTE, N4InterfaceDeclaration ifcDecl) {
        Functions.Function1 _function = it -> it.isStatic();
        Functions.Function1 _function_1 = it -> {
            Expression _expression = it.getExpression();
            return _expression != null;
        };
        Functions.Function1 _function_2 = fieldDecl -> {
            AssignmentExpression __AssignmentExpr = TranspilerBuilderBlocks._AssignmentExpr();
            Procedures.Procedure1 _function_3 = it -> {
                it.setLhs((Expression)TranspilerBuilderBlocks._PropertyAccessExpr((SymbolTableEntry)ifcSTE, (SymbolTableEntry[])new SymbolTableEntry[]{this.findSymbolTableEntryForElement((NamedElement)fieldDecl, true)}));
                it.setRhs(fieldDecl.getExpression());
            };
            AssignmentExpression _doubleArrow = (AssignmentExpression)ObjectExtensions.operator_doubleArrow((Object)__AssignmentExpr, (Procedures.Procedure1)_function_3);
            return TranspilerBuilderBlocks._ExprStmnt((Expression)_doubleArrow);
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)ifcDecl.getOwnedMembers(), N4FieldDeclaration.class), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2));
    }
}

