/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.jsdoc.dom.Composite;
import org.eclipse.n4js.jsdoc.dom.ContentNode;
import org.eclipse.n4js.jsdoc.dom.Doclet;
import org.eclipse.n4js.jsdoc.dom.FullMemberReference;
import org.eclipse.n4js.jsdoc.dom.FullTypeReference;
import org.eclipse.n4js.jsdoc.dom.InlineTag;
import org.eclipse.n4js.jsdoc.dom.JSDocNode;
import org.eclipse.n4js.jsdoc.dom.LineTag;
import org.eclipse.n4js.jsdoc.dom.Literal;
import org.eclipse.n4js.jsdoc.dom.SimpleTypeReference;
import org.eclipse.n4js.jsdoc.dom.TagTitle;
import org.eclipse.n4js.jsdoc.dom.TagValue;
import org.eclipse.n4js.jsdoc.dom.Text;
import org.eclipse.n4js.jsdoc.dom.util.DomSwitch;

public class JSDocSerializer
extends DomSwitch<Boolean> {
    public static final String NL = "\n * ";
    public static final String NL_PREFIX = " * ";
    StringBuffer strb = new StringBuffer();

    public static String toJSDocString(EObject obj) {
        JSDocSerializer serializer = new JSDocSerializer();
        if (obj == null) {
            return "";
        }
        serializer.doSwitch(obj);
        return serializer.strb.toString();
    }

    public static String contentAsString(Composite composite) {
        JSDocSerializer serializer = new JSDocSerializer();
        serializer.appendContents(composite.getContents());
        return serializer.strb.toString();
    }

    @Override
    public Boolean caseDoclet(Doclet doclet) {
        this.strb.append("/**");
        if (!doclet.getContents().isEmpty()) {
            this.strb.append(NL);
        }
        this.appendContents(doclet.getContents());
        for (LineTag tag : doclet.getLineTags()) {
            this.doSwitch(tag);
        }
        if (!doclet.getLineTags().isEmpty()) {
            this.strb.append("\n");
        }
        this.strb.append(" */");
        return false;
    }

    @Override
    public Boolean caseLiteral(Literal object) {
        this.strb.append(object.getValue());
        return false;
    }

    @Override
    public Boolean caseSimpleTypeReference(SimpleTypeReference object) {
        this.strb.append(object.getTypeName());
        return false;
    }

    @Override
    public Boolean caseFullTypeReference(FullTypeReference object) {
        this.strb.append(object.getModuleName()).append(".");
        this.caseSimpleTypeReference(object);
        return false;
    }

    @Override
    public Boolean caseFullMemberReference(FullMemberReference object) {
        this.caseFullTypeReference(object);
        if (!object.getMemberName().isEmpty()) {
            if (object.isStaticMember()) {
                this.strb.append('#');
            } else {
                this.strb.append('.');
            }
            this.strb.append(object.getMemberName());
        }
        return false;
    }

    @Override
    public Boolean caseComposite(Composite object) {
        this.appendContents(object.getContents());
        return false;
    }

    private void appendContents(EList<ContentNode> contents) {
        for (ContentNode content : contents) {
            this.doSwitch(content);
            if (this.lastChar() != '\n') continue;
            this.strb.append(NL_PREFIX);
        }
    }

    char lastChar() {
        if (this.strb.length() > 0) {
            return this.strb.charAt(this.strb.length() - 1);
        }
        return '\u0000';
    }

    @Override
    public Boolean caseText(Text text) {
        this.strb.append(text.getText().replaceAll("\\r?\\n", NL));
        return false;
    }

    @Override
    public Boolean caseLineTag(LineTag lineTag) {
        this.strb.append(NL).append('@').append(lineTag.getTitle().getTitle());
        if (!lineTag.getValues().isEmpty()) {
            this.strb.append(" ");
        }
        for (JSDocNode node : lineTag.getValues()) {
            this.doSwitch(node);
        }
        return false;
    }

    @Override
    public Boolean caseTagTitle(TagTitle object) {
        this.strb.append(object.getTitle());
        return false;
    }

    @Override
    public Boolean caseInlineTag(InlineTag object) {
        this.strb.append("{").append('@').append(object.getTitle().getTitle());
        for (TagValue tagValue : object.getValues()) {
            this.doSwitch(tagValue);
        }
        this.strb.append("}");
        return false;
    }
}

