/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.dialog;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.ui.utils.UIUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;

public class ProjectSelectionDialog
extends ListDialog {
    @Inject
    public ProjectSelectionDialog(N4JSProjectContentProvider n4jsProjectContentProvider) {
        super(UIUtils.getShell());
        this.setContentProvider(n4jsProjectContentProvider);
        this.setLabelProvider((ILabelProvider)new N4JSProjectLabelProvider());
        this.setInput(ResourcesPlugin.getWorkspace().getRoot());
        this.setHelpAvailable(false);
    }

    public Object getFirstResult() {
        Object[] result = this.getResult();
        if (result != null && result.length > 0) {
            return result[0];
        }
        return null;
    }

    private static final class N4JSProjectContentProvider
    implements IStructuredContentProvider {
        @Inject
        private IN4JSCore n4jsCore;

        private N4JSProjectContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        private boolean isN4JSProject(IProject project) {
            URI uri = URI.createPlatformResourceURI((String)project.getName(), (boolean)true);
            IN4JSProject n4Project = (IN4JSProject)this.n4jsCore.findProject(uri).orNull();
            return n4Project != null && n4Project.exists();
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IContainer) {
                try {
                    List<IResource> projects = Arrays.asList(((IContainer)inputElement).members()).stream().filter(member -> member instanceof IProject).filter(project -> this.isN4JSProject((IProject)project)).sorted(new ResourceComparator()).collect(Collectors.toList());
                    return projects.toArray(new IResource[projects.size()]);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return null;
        }
    }

    private static final class N4JSProjectLabelProvider
    extends LabelProvider {
        private final Image projectImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");

        private N4JSProjectLabelProvider() {
        }

        public Image getImage(Object element) {
            return this.projectImage;
        }

        public String getText(Object element) {
            if (element instanceof IResource) {
                return ((IResource)element).getName();
            }
            return super.getText(element);
        }
    }

    private static final class ResourceComparator
    implements Comparator<IResource> {
        private ResourceComparator() {
        }

        @Override
        public int compare(IResource o1, IResource o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

