/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.registry;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.xpect.registry.IExtensionInfo;
import org.eclipse.xpect.util.ClasspathUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class StandaloneExtensionRegistry
implements IExtensionInfo.Registry {
    private static final Logger LOG = Logger.getLogger(StandaloneExtensionRegistry.class);
    private final Multimap<String, IExtensionInfo> extensions;

    public static void main(String[] args) {
        System.out.println(new StandaloneExtensionRegistry().toString());
    }

    public StandaloneExtensionRegistry() {
        this.extensions = ImmutableMultimap.copyOf(this.collectExtensions());
    }

    public StandaloneExtensionRegistry(URL url, InputStream in) {
        this.extensions = ImmutableMultimap.copyOf(this.collectExtensions(url, in));
    }

    private Multimap<String, IExtensionInfo> collectExtensions() {
        HashMultimap result = HashMultimap.create();
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            for (URL url : ClasspathUtil.findResources("plugin.xml", "fragment.xml")) {
                reader.setContentHandler(new PluginXMLContentHandler(url, (Multimap<String, IExtensionInfo>)result));
                InputStream openStream = null;
                try {
                    try {
                        openStream = url.openStream();
                        reader.parse(new InputSource(openStream));
                    }
                    catch (Throwable e) {
                        LOG.error((Object)("Error parsing " + url), e);
                        Closeables.close((Closeable)openStream, (boolean)true);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    Closeables.close((Closeable)openStream, (boolean)true);
                    throw throwable;
                }
                Closeables.close((Closeable)openStream, (boolean)true);
            }
        }
        catch (Throwable e) {
            LOG.error((Object)e.getMessage(), e);
        }
        return result;
    }

    private Multimap<String, IExtensionInfo> collectExtensions(URL url, InputStream in) {
        HashMultimap result = HashMultimap.create();
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(new PluginXMLContentHandler(url, (Multimap<String, IExtensionInfo>)result));
            reader.parse(new InputSource(in));
        }
        catch (Throwable e) {
            LOG.error((Object)("Error parsing " + url), e);
        }
        return result;
    }

    @Override
    public Collection<String> getExtensionPoints() {
        return this.extensions.keySet();
    }

    @Override
    public Collection<IExtensionInfo> getExtensions(String extensionPointName) {
        return this.extensions.get((Object)extensionPointName);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("<plugin>\n");
        for (String point : this.getExtensionPoints()) {
            result.append("  <extension point=\"");
            result.append(point);
            result.append("\">\n");
            for (IExtensionInfo ext : this.getExtensions(point)) {
                result.append("    ");
                result.append(ext.toString());
                result.append("\n");
            }
        }
        result.append("  </extension>\n");
        result.append("</plugin>");
        return result.toString();
    }

    protected static class PluginXMLContentHandler
    extends DefaultHandler {
        private int depth;
        private final Multimap<String, IExtensionInfo> extensions;
        private String point;
        private final URL url;

        public PluginXMLContentHandler(URL url, Multimap<String, IExtensionInfo> extensions) {
            this.url = url;
            this.extensions = extensions;
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            switch (this.depth) {
                case 1: {
                    this.point = null;
                }
            }
            --this.depth;
        }

        @Override
        public void startDocument() throws SAXException {
            this.depth = 0;
            this.point = null;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            switch (this.depth) {
                case 1: {
                    if (!"extension".equals(qName)) break;
                    this.point = attributes.getValue("point");
                    break;
                }
                case 2: {
                    if (this.point == null || attributes.getLength() <= 0) break;
                    HashMap attrs = Maps.newHashMap();
                    int i = 0;
                    while (i < attributes.getLength()) {
                        attrs.put(attributes.getQName(i), attributes.getValue(i));
                        ++i;
                    }
                    this.extensions.put((Object)this.point, (Object)new StandaloneExtension(this.url.toString(), qName, attrs));
                }
            }
            ++this.depth;
        }
    }

    private static class StandaloneExtension
    implements IExtensionInfo {
        private final Map<String, String> attribtues;
        private final String loacation;
        private final String name;

        public StandaloneExtension(String location, String name, Map<String, String> attribtues) {
            this.loacation = location;
            this.name = name;
            this.attribtues = ImmutableMap.copyOf(attribtues);
        }

        @Override
        public Collection<String> getAttributes() {
            return this.attribtues.keySet();
        }

        @Override
        public String getAttributeValue(String name) {
            return this.attribtues.get(name);
        }

        @Override
        public Function<String, Class<?>> getClassLoader() {
            return new Function<String, Class<?>>(){

                public Class<?> apply(String input) {
                    try {
                        return ClassLoader.getSystemClassLoader().loadClass(input);
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }

        @Override
        public String getLocation() {
            return this.loacation;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("<");
            result.append(this.name);
            ArrayList attrs = Lists.newArrayList(this.getAttributes());
            Collections.sort(attrs);
            for (String attr : attrs) {
                result.append(" ");
                result.append(attr);
                result.append("=\"");
                result.append(this.getAttributeValue(attr));
                result.append("\"");
            }
            result.append(" />");
            return result.toString();
        }
    }
}

