/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public abstract class N4JSLanguageConstants {
    public static final String CONSTRUCTOR = "constructor";
    public static final String EXPORT_KEYWORD = "export";
    public static final String EXTERNAL_KEYWORD = "external";
    public static final String YIELD_KEYWORD = "yield";
    public static final String EXTENDS_KEYWORD = "extends";
    public static final String IMPLEMENTS_KEYWORD = "implements";
    public static final Collection<String> DEFAULT_SUPPRESSED_ISSUE_CODES_FOR_TESTS = Collections.unmodifiableCollection(Sets.newHashSet((Object[])new String[]{"CFG_LOCAL_VAR_UNUSED", "DFG_NULL_DEREFERENCE"}));
    public static final Collection<String> BASE_TYPES = Collections.unmodifiableCollection(Sets.newHashSet((Object[])new String[]{"boolean", "number", "string", "null", "any"}));
    public static final String GET_KEYWORD = "get";
    public static final String SET_KEYWORD = "set";
    public static final Collection<String> GETTER_SETTER = Collections.unmodifiableCollection(Sets.newHashSet((Object[])new String[]{"get", "set"}));
    public static final Collection<String> BOOLEAN_LITERALS = Collections.unmodifiableCollection(Sets.newHashSet((Object[])new String[]{String.valueOf(Boolean.TRUE), String.valueOf(Boolean.FALSE)}));
    public static final Collection<String> FUTURE_RESERVED_WORDS = Collections.unmodifiableCollection(Sets.newHashSet((Object[])new String[]{"let", "enum", "await"}));
    public static final Collection<String> ACCESS_MODIFIERS = Collections.unmodifiableCollection(Sets.newHashSet((Object[])new String[]{"private", "project", "protected", "public"}));
    public static final Map<String, String> DISCOURAGED_CHARACTERS = ImmutableMap.of((Object)"$", (Object)"dollar sign");
    public static final Set<String> RESERVED_WORDS_IN_STRICT_MODE = ImmutableSet.of((Object)"implements", (Object)"interface", (Object)"let", (Object)"package", (Object)"private", (Object)"protected", (Object[])new String[]{"public", "static", "yield"});
    public static final String LOCAL_ARGUMENTS_VARIABLE_NAME = "arguments";
    public static final String EVAL_NAME = "eval";
    public static final String PROPERTY__PROTO__NAME = "__proto__";
    public static final String METHOD_STACKTRACE_SUFFIX = "___n4";
    public static final String DI_PROP_NAME = "$di";
    public static final String DEFAULT_PROJECT_OUTPUT = "src-gen";
    public static final String DEFAULT_PROJECT_SRC = "src";
    public static final String DEFAULT_PROJECT_TEST = "test";
    public static final String EXPORT_DEFAULT_NAME = "default";

    private N4JSLanguageConstants() {
    }
}

